/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.mappings;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingEObject;
import org.eclipse.qvt.declarative.ecore.adapters.AdaptingExtension;
import org.eclipse.qvt.declarative.ecore.mappings.EStructuralFeatureMap;
import org.eclipse.qvt.declarative.ecore.mappings.IMappingMetaDataRegistry;
import org.eclipse.qvt.declarative.ecore.mappings.MappingMetaData;
import org.eclipse.qvt.declarative.ecore.mappings.MappingMetaDataRegistry;
import org.eclipse.qvt.declarative.ecore.mappings.MappingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EClassMap {
    protected final MappingMetaData mappingMetaData;
    protected final EClass ecoreEClass;
    protected final EClass adaptingEClass;
    protected Map<EStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature>> adaptingFeatureMaps;
    protected Map<EStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature>> ecoreFeatureMaps;

    protected EClassMap(MappingMetaData mappingMetaData, EClass ecoreEClass, EClass adaptingEClass) {
        this.mappingMetaData = mappingMetaData;
        this.ecoreEClass = ecoreEClass;
        this.adaptingEClass = adaptingEClass;
    }

    public void compile(IMappingMetaDataRegistry.Install mappingMetaDataRegistry) {
        this.adaptingFeatureMaps = new HashMap<EStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature>>();
        this.ecoreFeatureMaps = new HashMap<EStructuralFeature, EStructuralFeatureMap<? extends EStructuralFeature>>();
        EList ecoreFeatures = this.ecoreEClass.getEAllStructuralFeatures();
        for (EStructuralFeature ecoreFeature : ecoreFeatures) {
            EStructuralFeatureMap<? extends EStructuralFeature> featureMap = this.mappingMetaData.getEcoreFeatureMap(mappingMetaDataRegistry, this.ecoreEClass, ecoreFeature);
            if (featureMap == null) continue;
            this.ecoreFeatureMaps.put(ecoreFeature, featureMap);
            EStructuralFeature adaptingFeature = featureMap.getAdaptingFeature();
            if (adaptingFeature == null) continue;
            this.adaptingFeatureMaps.put(adaptingFeature, featureMap);
        }
        if (this.adaptingEClass != null) {
            EList adaptingFeatures = this.adaptingEClass.getEAllStructuralFeatures();
            for (EStructuralFeature adaptingFeature : adaptingFeatures) {
                EStructuralFeatureMap<? extends EStructuralFeature> featureMap = this.mappingMetaData.getAdaptingFeatureMap(mappingMetaDataRegistry, this.adaptingEClass, adaptingFeature);
                if (featureMap == null || this.adaptingFeatureMaps.containsKey(adaptingFeature)) continue;
                this.adaptingFeatureMaps.put(adaptingFeature, featureMap);
                EStructuralFeature ecoreFeature = featureMap.getEcoreStructuralFeature();
                if (ecoreFeature == null) continue;
                this.ecoreFeatureMaps.put(ecoreFeature, featureMap);
            }
        }
    }

    public abstract AdaptingEObject createAdapter(MappingMetaDataRegistry var1, EObject var2);

    public EClass getAdaptingEClass() {
        return this.adaptingEClass;
    }

    public EClass getAdaptingEClass(EObject ecoreObject) {
        return this.adaptingEClass;
    }

    public EStructuralFeatureMap<? extends EStructuralFeature> getAdaptingFeatureMap(EStructuralFeature adaptingFeature) {
        return this.adaptingFeatureMaps.get(adaptingFeature);
    }

    public EStructuralFeatureMap<? extends EStructuralFeature> getAdaptingFeatureMap(EObject ecoreObject, EStructuralFeature adaptingFeature) {
        return this.adaptingFeatureMaps.get(adaptingFeature);
    }

    public Collection<EStructuralFeatureMap<? extends EStructuralFeature>> getAdaptingFeatureMaps() {
        return this.adaptingFeatureMaps.values();
    }

    public Collection<EStructuralFeatureMap<? extends EStructuralFeature>> getAdaptingFeatureMaps(EObject ecoreObject) {
        return this.adaptingFeatureMaps.values();
    }

    public EStructuralFeatureMap<? extends EStructuralFeature> getEcoreFeatureMap(EStructuralFeature ecoreFeature) {
        return this.ecoreFeatureMaps.get(ecoreFeature);
    }

    public Collection<EStructuralFeatureMap<? extends EStructuralFeature>> getEcoreFeatureMaps() {
        return this.ecoreFeatureMaps.values();
    }

    public EClass getEcoreEClass() {
        return this.ecoreEClass;
    }

    protected <E extends EClass> Class<? extends E> getInstanceClass(EClass ecoreEClass) {
        return ecoreEClass.getInstanceClass();
    }

    public MappingMetaData getMappingMetaData() {
        return this.mappingMetaData;
    }

    public void postLoad(MappingMetaDataRegistry mappingMetaDataRegistry, EObject ecoreObject) {
        AdaptingEObject adaptingObject = (AdaptingEObject)mappingMetaDataRegistry.getAdapter(ecoreObject);
        if (adaptingObject != null) {
            adaptingObject.postLoad();
        }
    }

    public void postSave(MappingMetaDataRegistry mappingMetaDataRegistry, EObject ecoreObject) {
        AdaptingEObject adaptingObject = (AdaptingEObject)mappingMetaDataRegistry.getAdapter(ecoreObject);
        if (adaptingObject != null) {
            adaptingObject.postSave();
        }
    }

    public void preLoad(MappingMetaDataRegistry mappingMetaDataRegistry, EObject ecoreObject) {
        AdaptingEObject adaptingObject = (AdaptingEObject)mappingMetaDataRegistry.getAdapter(ecoreObject);
        if (adaptingObject != null) {
            adaptingObject.preLoad();
        }
    }

    public void preSave(MappingMetaDataRegistry mappingMetaDataRegistry, EObject ecoreObject) {
        AdaptingEObject adaptingObject = (AdaptingEObject)mappingMetaDataRegistry.getAdapter(ecoreObject);
        if (adaptingObject != null) {
            adaptingObject.preSave();
        }
    }

    public String toString() {
        return String.valueOf(MappingUtils.formatFullName(this.ecoreEClass)) + " <==> " + MappingUtils.formatFullName(this.adaptingEClass);
    }

    public EStructuralFeature validate(MappingMetaDataRegistry mappingMetaDataRegistry, PrintWriter writer) {
        if (this.ecoreEClass == null || this.adaptingEClass == null) {
            return null;
        }
        EStructuralFeature badFeature = null;
        EList ecoreFeatures = this.ecoreEClass.getEAllStructuralFeatures();
        for (EStructuralFeature ecoreFeature : ecoreFeatures) {
            EStructuralFeatureMap<? extends EStructuralFeature> structuralFeatureMap = mappingMetaDataRegistry.getEcoreEStructuralFeatureMap(ecoreFeature);
            if (ecoreFeature instanceof EReference && ((EReference)ecoreFeature).isContainer()) {
                if (structuralFeatureMap == null) continue;
                if (writer != null) {
                    writer.println("Redundant container feature: " + MappingUtils.formatFullName(this.ecoreEClass) + " " + MappingUtils.formatFeatureName(ecoreFeature));
                }
                badFeature = ecoreFeature;
                continue;
            }
            if (ecoreFeature.isDerived()) {
                if (structuralFeatureMap == null) continue;
                if (writer != null) {
                    writer.println("Redundant derived feature: " + MappingUtils.formatFullName(this.ecoreEClass) + " " + MappingUtils.formatFeatureName(ecoreFeature));
                }
                badFeature = ecoreFeature;
                continue;
            }
            if (ecoreFeature.isTransient()) {
                if (structuralFeatureMap == null) continue;
                if (writer != null) {
                    writer.println("Redundant transient feature: " + MappingUtils.formatFullName(this.ecoreEClass) + " " + MappingUtils.formatFeatureName(ecoreFeature));
                }
                badFeature = ecoreFeature;
                continue;
            }
            if (structuralFeatureMap != null) continue;
            if (writer != null) {
                writer.println("Missing feature: " + MappingUtils.formatFullName(this.ecoreEClass) + " " + MappingUtils.formatFeatureName(ecoreFeature));
            }
            badFeature = ecoreFeature;
        }
        return badFeature;
    }

    public static class Direct
    extends EClassMap {
        public Direct(MappingMetaData mappingMetaData, EClass ecoreEClass, EClass adaptingEClass) {
            super(mappingMetaData, ecoreEClass, adaptingEClass);
        }

        public AdaptingEObject createAdapter(MappingMetaDataRegistry mappingMetaDataRegistry, EObject ecoreObject) {
            return new AdaptingEObject(mappingMetaDataRegistry, this, ecoreObject);
        }
    }

    public static class Extension
    extends EClassMap {
        public Extension(MappingMetaData mappingMetaData, EClass ecoreEClass) {
            super(mappingMetaData, ecoreEClass, XMLTypePackage.Literals.ANY_TYPE);
        }

        public AdaptingEObject createAdapter(MappingMetaDataRegistry mappingMetaDataRegistry, EObject ecoreObject) {
            return new AdaptingExtension(mappingMetaDataRegistry, this, ecoreObject);
        }
    }
}

