/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.unparser;

import org.eclipse.emf.ecore.resource.Resource;

public abstract class AbstractUnparser {
    protected final Resource resource;
    private final StringBuffer buffer = new StringBuffer();
    private int indentDepth = 0;
    private boolean startOfLine = true;

    public AbstractUnparser(Resource resource) {
        this.resource = resource;
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        int start = 0;
        int end = string.length();
        while (start < end) {
            int index = string.indexOf(10, start);
            if (this.startOfLine && this.indentDepth > 0) {
                int i = this.indentDepth;
                while (i > 0) {
                    this.buffer.append("    ");
                    --i;
                }
            }
            this.buffer.append(string.substring(start, index >= 0 ? index : end));
            if (index >= 0) {
                this.buffer.append("\n");
                this.startOfLine = true;
                start = index + 1;
                continue;
            }
            start = end;
            this.startOfLine = false;
        }
    }

    public void appendName(Object object) {
        this.append(this.formatName(object));
    }

    public void appendQualifiedName(Object object) {
        this.append(this.formatQualifiedName(object));
    }

    public void exdent() {
        assert (this.indentDepth > 0);
        --this.indentDepth;
    }

    protected abstract String formatName(Object var1);

    protected abstract String formatQualifiedName(Object var1);

    public byte[] getBytes() {
        return this.buffer.toString().getBytes();
    }

    public String getString() {
        return this.buffer.toString();
    }

    public void indent() {
        ++this.indentDepth;
    }

    protected void initialize() {
    }

    public abstract void unparse();

    protected void unparseUnsupported(Object object) {
        this.append("***" + this.getClass().getSimpleName() + "-Unsupported-" + object.getClass().getSimpleName() + "***\n");
    }
}

