/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.qvt.declarative.modelregistry.ModelRegistration;
import org.eclipse.qvt.declarative.modelregistry.ModelRegistry;
import org.eclipse.qvt.declarative.modelregistry.ModelRegistryFactory;
import org.eclipse.qvt.declarative.modelregistry.ModelRegistryPackage;
import org.eclipse.qvt.declarative.modelregistry.ModelRegistrySettings;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AccessorKindRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelSerializationRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.Accessor;
import org.eclipse.qvt.declarative.modelregistry.model.AccessorRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.FileHandleRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.ModelSerialization;
import org.eclipse.qvt.declarative.modelregistry.model.Registration;
import org.eclipse.qvt.declarative.modelregistry.model.UnregisteredAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectRegistry {
    public static final String DEFAULT_SERIALISATION_NAME = "XML";
    private final AbstractProjectHandle projectHandle;
    private final Map<AbstractFileHandle, FileHandleRegistry> map = new HashMap<AbstractFileHandle, FileHandleRegistry>();
    private final ResourceSet resourceSet;
    private Resource model = null;
    private Map<String, String> unregisteredKinds = null;

    public ProjectRegistry(AbstractProjectHandle projectHandle, ResourceSet resourceSet) {
        this.projectHandle = projectHandle;
        this.resourceSet = resourceSet;
    }

    public FileHandleRegistry add(AbstractFileHandle fileHandle) {
        FileHandleRegistry fileHandleRegistry = new FileHandleRegistry(this, fileHandle);
        this.map.put(fileHandle, fileHandleRegistry);
        return fileHandleRegistry;
    }

    public <A extends Accessor> Registration<A> add(Registration<A> registration) {
        AbstractFileHandle fileHandle = registration.getFileHandle();
        FileHandleRegistry fileHandleRegistry = this.getOrCreate(fileHandle);
        return fileHandleRegistry.add(registration);
    }

    private ModelRegistrySettings exportToModel() {
        ModelRegistrySettings modelRegistrySettings = ModelRegistryFactory.eINSTANCE.createModelRegistrySettings();
        ArrayList<FileHandleRegistry> fileHandleRegistries = new ArrayList<FileHandleRegistry>(this.map.values());
        Collections.sort(fileHandleRegistries);
        for (FileHandleRegistry fileHandleRegistry : fileHandleRegistries) {
            AbstractFileHandle fileHandle = fileHandleRegistry.getFileHandle();
            ModelRegistry modelRegistry = ModelRegistryFactory.eINSTANCE.createModelRegistry();
            modelRegistry.setName(fileHandle.getProjectRelativeName());
            modelRegistrySettings.getResource().add((Object)modelRegistry);
            ArrayList accessorRegistries = new ArrayList(fileHandleRegistry.getRegistries());
            Collections.sort(accessorRegistries);
            for (AccessorRegistry accessorRegistry : accessorRegistries) {
                ArrayList registrations = new ArrayList(accessorRegistry.getRegistrations());
                Collections.sort(registrations);
                for (Registration registration : registrations) {
                    Object accessor = registration.getAccessor();
                    ModelRegistration modelRegistration = ModelRegistryFactory.eINSTANCE.createModelRegistration();
                    modelRegistration.setAccessor(accessor.getName());
                    modelRegistration.setKind(accessor.getKind());
                    if (!DEFAULT_SERIALISATION_NAME.equals(registration.getSerializationName())) {
                        modelRegistration.setSerialization(registration.getSerializationName());
                    }
                    modelRegistration.setUri(registration.getURIString());
                    modelRegistry.getEntry().add((Object)modelRegistration);
                }
            }
        }
        return modelRegistrySettings;
    }

    public FileHandleRegistry get(AbstractFileHandle fileHandle) {
        return this.map.get(fileHandle);
    }

    public FileHandleRegistry getOrCreate(AbstractFileHandle fileHandle) {
        FileHandleRegistry fileHandleRegistry = this.map.get(fileHandle);
        if (fileHandleRegistry == null) {
            fileHandleRegistry = new FileHandleRegistry(this, fileHandle);
            this.map.put(fileHandle, fileHandleRegistry);
        }
        return fileHandleRegistry;
    }

    public AbstractProjectHandle getProject() {
        return this.projectHandle;
    }

    public <A extends Accessor> Registration<A> getRegistration(AbstractFileHandle fileHandle, A accessor) {
        AbstractFileHandle ancestorHandle = fileHandle;
        while (ancestorHandle != null) {
            Registration<A> registration;
            FileHandleRegistry fileHandleRegistry = this.get(ancestorHandle);
            if (fileHandleRegistry != null && (registration = fileHandleRegistry.getRegistration(accessor)) != null) {
                return registration;
            }
            ancestorHandle = ancestorHandle.getParentFileHandle();
        }
        return null;
    }

    public <A extends Accessor> Collection<Registration<A>> getRegistrations(AbstractFileHandle fileHandle, Class<A> accessorClass) {
        AccessorRegistry<A> flatAccessorRegistry = new AccessorRegistry<A>(this.get(fileHandle), accessorClass);
        AbstractFileHandle ancestorHandle = fileHandle;
        while (ancestorHandle != null) {
            AccessorRegistry<A> accessorRegistry;
            FileHandleRegistry fileHandleRegistry = this.get(ancestorHandle);
            if (fileHandleRegistry != null && (accessorRegistry = fileHandleRegistry.get(accessorClass)) != null) {
                for (Registration<A> registration : accessorRegistry.getRegistrations()) {
                    if (flatAccessorRegistry.get(registration.getAccessor()) != null) continue;
                    flatAccessorRegistry.add(registration);
                }
            }
            ancestorHandle = ancestorHandle.getParentFileHandle();
        }
        return flatAccessorRegistry.getRegistrations();
    }

    public URI getResolvedURI(AbstractFileHandle fileHandle, Accessor accessor) {
        return this.resolveURI(this.getURI(fileHandle, accessor));
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public URI getURI(AbstractFileHandle fileHandle, Accessor accessor) {
        Registration<Accessor> registration = this.getRegistration(fileHandle, accessor);
        return registration != null ? registration.getURI() : null;
    }

    private void importFromModel(Resource model, URI registryURI) {
        this.map.clear();
        AccessorKindRegistry accessorKindRegistry = ModelRegistryEnvironment.getInstance().getAccessorKindRegistry();
        ModelSerializationRegistry modelSerializationRegistry = ModelRegistryEnvironment.getInstance().getModelSerializationRegistry();
        for (EObject content : model.getContents()) {
            ModelRegistrySettings settings = (ModelRegistrySettings)content;
            for (ModelRegistry modelRegistry : settings.getResource()) {
                String name = modelRegistry.getName();
                AbstractFileHandle fileHandle = null;
                try {
                    fileHandle = this.projectHandle.getFileHandle(name);
                }
                catch (IOException e) {
                    ModelRegistryEnvironment.logError("Illegal model registry file handle name", e);
                }
                if (fileHandle == null) continue;
                FileHandleRegistry fileHandleRegistry = this.add(fileHandle);
                for (ModelRegistration modelRegistration : modelRegistry.getEntry()) {
                    String kind = modelRegistration.getKind();
                    Accessor accessor = accessorKindRegistry.createAccessor(kind, modelRegistration.getAccessor());
                    if (accessor == null) {
                        if (this.unregisteredKinds == null) {
                            this.unregisteredKinds = new HashMap<String, String>();
                        }
                        if (!this.unregisteredKinds.containsKey(kind)) {
                            this.unregisteredKinds.put(kind, kind);
                            ModelRegistryEnvironment.logError("Unregistered accessor kind '" + kind + "' used in '" + registryURI + "'", null);
                        }
                        accessor = new UnregisteredAccessor(kind, modelRegistration.getAccessor());
                    }
                    URI ecoreURI = URI.createURI((String)modelRegistration.getUri());
                    String serializationName = modelRegistration.getSerialization();
                    if (serializationName == null) {
                        serializationName = DEFAULT_SERIALISATION_NAME;
                    }
                    ModelSerialization modelSerialisation = modelSerializationRegistry.getSerializationOrCreate(serializationName);
                    fileHandleRegistry.add(accessor, ecoreURI, modelSerialisation);
                }
            }
        }
    }

    public boolean loadModel() {
        URI registryURI = this.projectHandle.getRegistryURI();
        try {
            if (this.model == null) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getPackageRegistry().put((Object)ModelRegistryPackage.eINSTANCE.getNsURI(), (Object)ModelRegistryPackage.eINSTANCE);
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                this.model = resourceSet.getResource(registryURI, true);
            }
            this.importFromModel(this.model, registryURI);
            return true;
        }
        catch (WrappedException e) {
            try {
                throw e.exception();
            }
            catch (FileNotFoundException fileNotFoundException) {
                return true;
            }
            catch (Exception e2) {
                ModelRegistryEnvironment.logError("Failed to get model registry from '" + registryURI + "'", e2);
                return false;
            }
        }
    }

    public <A extends Accessor> Registration<A> remove(Registration<A> registration) {
        AbstractFileHandle fileHandle = registration.getFileHandle();
        FileHandleRegistry fileHandleRegistry = this.map.get(fileHandle);
        return fileHandleRegistry.remove(registration);
    }

    public URI resolveURI(URI uri) {
        if (uri == null) {
            return uri;
        }
        return uri.resolve(this.projectHandle.getURI());
    }

    public boolean saveModel() {
        URI registryURI = this.projectHandle.getRegistryURI();
        ModelRegistrySettings settings = this.exportToModel();
        this.model = this.resourceSet.createResource(registryURI);
        this.model.getContents().add((Object)settings);
        try {
            this.model.save(null);
            this.projectHandle.refreshRegistry();
        }
        catch (IOException e) {
            ModelRegistryEnvironment.logError("Failed to create model registry at '" + registryURI + "'", e);
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getProject().toString();
    }
}

