/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.qvt.declarative.ecore.utils.EcoreUtils;
import org.eclipse.qvt.declarative.editor.AbstractNode;
import org.eclipse.qvt.declarative.editor.Behavior;
import org.eclipse.qvt.declarative.editor.EcoreNode;
import org.eclipse.qvt.declarative.editor.EditorDefinition;
import org.eclipse.qvt.declarative.editor.EditorFactory;
import org.eclipse.qvt.declarative.editor.EditorPackage;
import org.eclipse.qvt.declarative.editor.JavaNode;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonEditorDefinition
implements IResourceChangeListener,
IResourceDeltaVisitor {
    protected final URL editorURL;
    protected EditorDefinition editorDefinition = null;
    private Map<EClassifier, EcoreNode> ecoreMap = null;
    private Map<Class<?>, JavaNode> javaMap = null;

    public static CommonEditorDefinition create(ICommonPlugin plugin, String editorFile) {
        CommonEditorDefinition editorDefinition = null;
        Path path = new Path(editorFile);
        URL url = FileLocator.find((Bundle)plugin.getBundle(), (IPath)path, null);
        try {
            try {
                URL resolvedURL = FileLocator.resolve((URL)url);
                editorDefinition = new CommonEditorDefinition(resolvedURL);
            }
            catch (IOException e) {
                plugin.logException("Failed to load '" + String.valueOf(path) + "'", e);
                if (editorDefinition == null) {
                    editorDefinition = new CommonEditorDefinition(null);
                }
            }
        }
        finally {
            if (editorDefinition == null) {
                editorDefinition = new CommonEditorDefinition(null);
            }
        }
        return editorDefinition;
    }

    public CommonEditorDefinition(URL editorURL) {
        this.editorURL = editorURL;
        EditorPackage.eINSTANCE.getClass();
        if (editorURL != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public void dispose() {
        if (this.editorURL != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    protected EcoreNode findEcoreClass(EClass subType) {
        for (EClass superType : subType.getESuperTypes()) {
            EcoreNode ecoreNode = this.ecoreMap.get(superType);
            if (ecoreNode != null) {
                return ecoreNode;
            }
            ecoreNode = this.findEcoreClass(superType);
            if (ecoreNode == null) continue;
            return ecoreNode;
        }
        return null;
    }

    protected JavaNode findJavaClass(Class<?> subClass) {
        Class<?> superClass = subClass.getSuperclass();
        if (superClass != null) {
            JavaNode javaNode = this.javaMap.get(superClass);
            if (javaNode != null) {
                return javaNode;
            }
            javaNode = this.findJavaClass(superClass);
            if (javaNode != null) {
                return javaNode;
            }
        }
        Class<?>[] classArray = subClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> superInterface = classArray[n2];
            JavaNode javaNode = this.javaMap.get(superInterface);
            if (javaNode != null) {
                return javaNode;
            }
            javaNode = this.findJavaClass(superInterface);
            if (javaNode != null) {
                return javaNode;
            }
            ++n2;
        }
        return null;
    }

    public <T extends Behavior> T getBehavior(Object object, Class<T> behaviorClass) {
        AbstractNode node = this.getNode(object);
        while (node != null) {
            for (Behavior behavior : node.getBehavior()) {
                if (!behaviorClass.isAssignableFrom(behavior.getClass())) continue;
                Behavior castBehavior = behavior;
                return (T)castBehavior;
            }
            node = node.getBase();
        }
        return null;
    }

    public EditorDefinition getEditorDefinition() {
        if (this.editorDefinition == null && this.editorURL != null) {
            try {
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("editor", new XMIResourceFactoryImpl());
                    Resource resource = resourceSet.createResource(URI.createURI((String)this.editorURL.toString()));
                    resource.load(this.editorURL.openStream(), null);
                    this.editorDefinition = (EditorDefinition)resource.getContents().get(0);
                    this.installEditorDefinition(this.editorDefinition);
                }
                catch (Exception e) {
                    QVTEditorPlugin.logError("Failed to load '" + this.editorURL.toString() + "'", e);
                    if (this.editorDefinition == null) {
                        this.editorDefinition = EditorFactory.eINSTANCE.createEditorDefinition();
                    }
                }
            }
            finally {
                if (this.editorDefinition == null) {
                    this.editorDefinition = EditorFactory.eINSTANCE.createEditorDefinition();
                }
            }
        }
        return this.editorDefinition;
    }

    protected void installEditorDefinition(EditorDefinition editorDefinition) {
        EcoreUtil.resolveAll((EObject)editorDefinition);
        Map unresolvedMap = EcoreUtil.UnresolvedProxyCrossReferencer.find((EObject)editorDefinition);
        String diagnosis = EcoreUtils.diagnoseUnresolvedProxies((URI)EcoreUtil.getURI((EObject)editorDefinition), (Map)unresolvedMap);
        if (diagnosis != null) {
            QVTEditorPlugin.logError(diagnosis, null);
        }
        for (AbstractNode node : editorDefinition.getNode()) {
            if (node instanceof EcoreNode) {
                EcoreNode ecoreNode;
                EClassifier ecoreKey;
                if (this.ecoreMap == null) {
                    this.ecoreMap = new HashMap<EClassifier, EcoreNode>();
                }
                if (this.ecoreMap.containsKey(ecoreKey = (ecoreNode = (EcoreNode)node).getElement())) continue;
                this.ecoreMap.put(ecoreKey, ecoreNode);
                continue;
            }
            if (!(node instanceof JavaNode)) continue;
            if (this.javaMap == null) {
                this.javaMap = new HashMap();
            }
            try {
                JavaNode javaNode = (JavaNode)node;
                Class<?> javaKey = Class.forName(javaNode.getName());
                if (this.javaMap.containsKey(javaKey)) continue;
                this.javaMap.put(javaKey, javaNode);
            }
            catch (ClassNotFoundException e) {
                QVTEditorPlugin.logError("In '" + editorDefinition.getLanguage() + "'.editor definition", e);
            }
        }
        for (EditorDefinition ed : editorDefinition.getExtends()) {
            this.installEditorDefinition(ed);
        }
    }

    protected EcoreNode getEcoreNode(EClass ecoreClass) {
        if (this.ecoreMap == null) {
            return null;
        }
        EcoreNode ecoreNode = this.ecoreMap.get(ecoreClass);
        if (ecoreNode != null) {
            return ecoreNode;
        }
        if (this.ecoreMap.containsKey(ecoreClass)) {
            return null;
        }
        ecoreNode = this.findEcoreClass(ecoreClass);
        this.ecoreMap.put((EClassifier)ecoreClass, ecoreNode);
        return ecoreNode;
    }

    protected JavaNode getJavaNode(Class<?> javaClass) {
        if (this.javaMap == null) {
            return null;
        }
        JavaNode javaNode = this.javaMap.get(javaClass);
        if (javaNode != null) {
            return javaNode;
        }
        if (this.javaMap.containsKey(javaClass)) {
            return null;
        }
        javaNode = this.findJavaClass(javaClass);
        this.javaMap.put(javaClass, javaNode);
        return javaNode;
    }

    public AbstractNode getNode(Object object) {
        if (object == null) {
            return null;
        }
        if (this.editorDefinition == null) {
            this.getEditorDefinition();
        }
        if (object instanceof EObject) {
            return this.getEcoreNode(((EObject)object).eClass());
        }
        return this.getJavaNode(object.getClass());
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta delta = event.getDelta();
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        java.net.URI locationURI;
        int deltaKind;
        IResource resource = delta.getResource();
        if (resource instanceof IFile && ((deltaKind = delta.getKind()) == 2 || deltaKind == 4 || deltaKind == 262144) && (locationURI = resource.getLocationURI()) != null) {
            try {
                URL fileURL = locationURI.toURL();
                if (fileURL.equals(this.editorURL)) {
                    this.editorDefinition = null;
                    this.ecoreMap.clear();
                    this.javaMap.clear();
                    return false;
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return true;
    }
}

