/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.smapi;

import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.SourceDebugExtensionWriter;
import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.imp.smapi.LineMapBuilder;
import org.eclipse.imp.smapi.SmapBuilder;

public class Main {
    public static boolean debug = false;

    public static void main(String[] args) {
        String MAIN_CLASS = args[0];
        Main.smapify(MAIN_CLASS, null, null);
    }

    public static void smapify(String filename, String relPathPrefix, String outputfile) {
        String prefix = Main.removeExt(filename);
        String origExten = filename.substring(filename.lastIndexOf(46) + 1);
        if (debug) {
            System.out.println("origExten=" + origExten);
            System.out.println("smapify filename: " + filename);
            System.out.println("with pathPrefix: " + relPathPrefix);
            System.out.println("and outputfile: " + outputfile);
        }
        LineMapBuilder lmb = new LineMapBuilder(prefix);
        String smap = SmapBuilder.get(prefix, relPathPrefix, lmb.get(), origExten);
        if (debug) {
            System.out.println(smap);
        }
        try {
            OfflineInstrumenter oi = new OfflineInstrumenter();
            String inputName = null;
            inputName = outputfile == null ? String.valueOf(prefix) + ".class" : outputfile;
            File input = new File(inputName);
            oi.addInputClass(input);
            oi.beginTraversal();
            ClassInstrumenter ci = oi.nextClass();
            ClassReader cr = ci.getReader();
            ClassWriter w = new ClassWriter();
            w.setRawCP(cr.getCP(), true);
            w.setMajorVersion(cr.getMajorVersion());
            w.setMinorVersion(cr.getMinorVersion());
            w.setAccessFlags(cr.getAccessFlags());
            w.setName(cr.getName());
            w.setSuperName(cr.getSuperName());
            w.setInterfaceNames(cr.getInterfaceNames());
            ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
            int fieldCount = cr.getFieldCount();
            int i = 0;
            while (i < fieldCount) {
                cr.initFieldAttributeIterator(i, iter);
                w.addField(cr.getFieldAccessFlags(i), cr.getFieldName(i), cr.getFieldType(i), Main.collectAttributes(cr, iter));
                ++i;
            }
            int methodCount = cr.getMethodCount();
            int i2 = 0;
            while (i2 < methodCount) {
                cr.initMethodAttributeIterator(i2, iter);
                w.addMethod(cr.getMethodAccessFlags(i2), cr.getMethodName(i2), cr.getMethodType(i2), Main.collectAttributes(cr, iter));
                ++i2;
            }
            cr.initClassAttributeIterator(iter);
            while (iter.isValid()) {
                w.addClassAttribute(Main.getRawAttribute(cr, iter));
                iter.advance();
            }
            SourceDebugExtensionWriter sw = new SourceDebugExtensionWriter(w);
            sw.setDebugInfo(smap);
            w.addClassAttribute((ClassWriter.Element)sw);
            FileOutputStream fw = new FileOutputStream(new File(inputName));
            fw.write(w.makeBytes());
            fw.close();
            oi.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private static String removeExt(String filename) {
        int i = filename.lastIndexOf(".");
        return filename.substring(0, i);
    }

    private static ClassWriter.Element[] collectAttributes(ClassReader cr, ClassReader.AttrIterator iter) throws Exception {
        ClassWriter.Element[] elems = new ClassWriter.Element[iter.getRemainingAttributesCount()];
        int i = 0;
        while (i < elems.length) {
            elems[i] = Main.getRawAttribute(cr, iter);
            iter.advance();
            ++i;
        }
        return elems;
    }

    private static ClassWriter.Element getRawAttribute(ClassReader cr, ClassReader.AttrIterator iter) {
        int offset = iter.getRawOffset();
        int end = offset + iter.getRawSize();
        return new ClassWriter.RawElement(cr.getBytes(), offset, end - offset);
    }
}

