/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.utils;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.imp.editor.internal.ToggleBreakpointsAdapter;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;

public class BreakpointUtils {
    public static void resetJavaBreakpoints(IFile origSrcFile) {
        int i;
        IFile javaFile = ToggleBreakpointsAdapter.javaFileForRootSourceFile(origSrcFile);
        HashSet<Integer> lineNumbers = new HashSet<Integer>();
        try {
            IMarker[] markers = origSrcFile.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, false, 2);
            i = 0;
            while (i < markers.length) {
                Integer num = (Integer)markers[i].getAttribute("lineNumber");
                if (ToggleBreakpointsAdapter.validateLineNumber(origSrcFile, num)) {
                    lineNumbers.add(num);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            System.err.println((Object)e);
        }
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        i = 0;
        while (i < breakpoints.length) {
            IResource res = breakpoints[i].getMarker().getResource();
            if (res.equals((Object)javaFile)) {
                try {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoints[i], true);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        try {
            for (Integer origSrcLineNumber : lineNumbers) {
                String typeName = ToggleBreakpointsAdapter.getTypeName(origSrcFile);
                HashMap<String, String> bkptAttributes = new HashMap<String, String>();
                bkptAttributes.put("org.eclipse.jdt.debug.core.sourceName", typeName);
                IJavaLineBreakpoint bkpt = JDIDebugModel.createLineBreakpoint((IResource)javaFile, (String)typeName, (int)origSrcLineNumber, (int)-1, (int)-1, (int)0, (boolean)true, bkptAttributes);
                bkpt.getMarker();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

