/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.smapi.LineMapBuilder;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleBreakpointsAdapter
implements IToggleBreakpointsTarget,
IBreakpointListener {
    String origExten = null;
    UniversalEditor fEditor = null;

    public ToggleBreakpointsAdapter(UniversalEditor editor) {
        this.fEditor = editor;
        this.origExten = editor.fLanguage != null ? editor.fLanguage.getFilenameExtensions().iterator().next() : null;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (selection instanceof ITextSelection) {
            ITextSelection textSel = (ITextSelection)selection;
            IEditorPart editorPart = (IEditorPart)part.getAdapter(IEditorPart.class);
            IFileEditorInput fileInput = (IFileEditorInput)editorPart.getEditorInput();
            final IFile origSrcFile = fileInput.getFile();
            this.origExten = ((UniversalEditor)editorPart).fLanguage.getFilenameExtensions().iterator().next();
            origSrcFile.getName();
            final String typeName = ToggleBreakpointsAdapter.getTypeName(origSrcFile);
            final IFile javaFile = ToggleBreakpointsAdapter.javaFileForRootSourceFile(origSrcFile);
            if (!javaFile.exists()) {
                return;
            }
            final Integer origSrcLineNumber = new Integer(textSel.getStartLine() + 1);
            if (!ToggleBreakpointsAdapter.validateLineNumber(origSrcFile, origSrcLineNumber)) {
                return;
            }
            final IJavaLineBreakpoint existingBreakpoint = JDIDebugModel.lineBreakpointExists((IResource)javaFile, (String)typeName, (int)origSrcLineNumber);
            IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    if (existingBreakpoint != null) {
                        IMarker marker = ToggleBreakpointsAdapter.this.findMarker(origSrcFile, origSrcLineNumber);
                        marker.delete();
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                        return;
                    }
                    HashMap<String, String> bkptAttributes = new HashMap<String, String>();
                    bkptAttributes.put("org.eclipse.jdt.debug.core.sourceName", typeName);
                    IJavaLineBreakpoint bkpt = JDIDebugModel.createLineBreakpoint((IResource)javaFile, (String)typeName, (int)origSrcLineNumber, (int)-1, (int)-1, (int)0, (boolean)true, bkptAttributes);
                    IMarker javaMarker = bkpt.getMarker();
                    IMarker origSrcMarker = origSrcFile.createMarker(IBreakpoint.LINE_BREAKPOINT_MARKER);
                    Map javaMarkerAttrs = javaMarker.getAttributes();
                    for (String key : javaMarkerAttrs.keySet()) {
                        Object value = javaMarkerAttrs.get(key);
                        if (key.equals("lineNumber")) {
                            value = origSrcLineNumber;
                        }
                        if (key.equals("charEnd") || key.equals("charStart")) continue;
                        origSrcMarker.setAttribute(key, value);
                    }
                    origSrcMarker.setAttribute("lineNumber", (Object)origSrcLineNumber);
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(wr, null);
            }
            catch (CoreException e) {
                throw new DebugException(e.getStatus());
            }
        }
    }

    public static boolean validateLineNumber(IFile origSrcFile, Integer origSrcLineNumber) {
        LineMapBuilder lmb = new LineMapBuilder(origSrcFile.getRawLocation().removeFileExtension().toString());
        Map lineMap = lmb.getLineMap();
        return lineMap.containsKey(origSrcLineNumber);
    }

    private IMarker findMarker(IFile origSrcFile, int lineNumber) throws CoreException {
        IMarker[] markers = origSrcFile.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, false, 2);
        int k = 0;
        while (k < markers.length) {
            if ((Integer)markers[k].getAttribute("lineNumber") == lineNumber) {
                return markers[k];
            }
            ++k;
        }
        return null;
    }

    public static IFile javaFileForRootSourceFile(IFile rootSrcFile) {
        IProject project = rootSrcFile.getProject();
        String rootSrcName = rootSrcFile.getName();
        return project.getFile(rootSrcFile.getProjectRelativePath().removeLastSegments(1).append(String.valueOf(rootSrcName.substring(0, rootSrcName.lastIndexOf(46))) + ".java"));
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        IPath path = breakpoint.getMarker().getResource().getRawLocation();
        String fileName = path.lastSegment();
        fileName = String.valueOf(fileName.substring(0, fileName.indexOf(".") + 1)) + this.origExten;
        path = path.removeLastSegments(1).append(fileName);
        IFile origSrcFile = breakpoint.getMarker().getResource().getProject().getWorkspace().getRoot().getFileForLocation(path);
        try {
            IMarker marker = this.findMarker(origSrcFile, (Integer)breakpoint.getMarker().getAttribute("lineNumber"));
            if (marker != null) {
                marker.delete();
            }
        }
        catch (CoreException e) {
            System.err.println((Object)e);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public static String getTypeName(IFile origSrcFile) {
        String temp;
        IProject project = origSrcFile.getProject();
        IJavaProject javaProj = JavaCore.create((IProject)project);
        origSrcFile.getName();
        String pathPrefix = project.getWorkspace().getRoot().getRawLocation() + project.getFullPath().toString();
        IPath projPath = project.getFullPath();
        try {
            boolean projectIsSrcBin;
            boolean bl = projectIsSrcBin = javaProj.getOutputLocation().matchingFirstSegments(projPath) == projPath.segmentCount() && javaProj.getOutputLocation().segmentCount() == projPath.segmentCount();
            if (!projectIsSrcBin) {
                temp = origSrcFile.getRawLocation().toString().substring(pathPrefix.length()).substring(1);
                pathPrefix = String.valueOf(pathPrefix) + "/" + temp.substring(0, temp.indexOf("/"));
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        temp = origSrcFile.getRawLocation().toString().substring(pathPrefix.length()).replaceAll("/", ".");
        return temp.substring(1, temp.lastIndexOf("."));
    }
}

