/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.editor.StringMatcher;
import org.eclipse.imp.editor.UniversalEditor;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.runtime.PluginImages;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
IInformationControlExtension3,
DisposeListener {
    private static final int BORDER = 1;
    private static final int RIGHT_MARGIN = 3;
    private static final String STORE_DISABLE_RESTORE_SIZE = "DISABLE_RESTORE_SIZE";
    private static final String STORE_DISABLE_RESTORE_LOCATION = "DISABLE_RESTORE_LOCATION";
    private Shell fShell;
    Composite fComposite;
    private Text fFilterText;
    private TreeViewer fTreeViewer;
    private StringMatcher fStringMatcher;
    private Command fInvokingCommand;
    private Label fStatusField;
    private Font fStatusTextFont;
    private KeySequence[] fInvokingCommandKeySequences;
    private Rectangle fBounds;
    private Rectangle fTrim;
    private Button fViewMenuButton;
    private ToolBar fToolBar;
    private Composite fViewMenuButtonComposite;
    private MenuManager fViewMenuManager;
    private Listener fDeactivateListener;
    private boolean fIsDecativateListenerActive = false;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private IKeyBindingService fKeyBindingService;
    private String[] fKeyBindingScopes;
    private IAction fShowViewMenuAction;
    private IExecutionListener fShowViewMenuHandlerSubmission;

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle, String invokingCommandId, boolean showStatusField) {
        if (invokingCommandId != null) {
            ICommandService commandManager = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
            this.fInvokingCommand = commandManager.getCommand(invokingCommandId);
            if (this.fInvokingCommand != null && !this.fInvokingCommand.isDefined()) {
                this.fInvokingCommand = null;
            }
        }
        this.fShell = new Shell(parent, shellStyle);
        Display display = this.fShell.getDisplay();
        this.fShell.setBackground(display.getSystemColor(2));
        this.fComposite = new Composite((Composite)this.fShell, 16);
        GridLayout layout = new GridLayout(1, false);
        this.fComposite.setLayout((Layout)layout);
        this.fComposite.setLayoutData((Object)new GridData(768));
        this.fViewMenuButtonComposite = new Composite(this.fComposite, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fViewMenuButtonComposite.setLayout((Layout)layout);
        this.fViewMenuButtonComposite.setLayoutData((Object)new GridData(768));
        if (this.hasHeader()) {
            this.createHeader(this.fViewMenuButtonComposite);
            this.fFilterText = this.createFilterText(this.fComposite);
        } else {
            this.fFilterText = this.createFilterText(this.fViewMenuButtonComposite);
        }
        this.createViewMenu(this.fViewMenuButtonComposite);
        this.createHorizontalSeparator(this.fComposite);
        this.fTreeViewer = this.createTreeViewer(this.fComposite, treeStyle);
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup(this.getId(), (StructuredViewer)this.fTreeViewer);
        if (showStatusField) {
            this.createStatusField(this.fComposite);
        }
        final Tree tree = this.fTreeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInformationControl.this.gotoSelectedElement();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){
            TreeItem fLastItem = null;

            public void mouseMove(MouseEvent e) {
                TreeItem o;
                if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
                    if (!o.equals(this.fLastItem)) {
                        this.fLastItem = o;
                        tree.setSelection(new TreeItem[]{this.fLastItem});
                    } else if (e.y < tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollUp(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                        Point p = tree.toDisplay(e.x, e.y);
                        Item item = AbstractInformationControl.this.fTreeViewer.scrollDown(p.x, p.y);
                        if (item instanceof TreeItem) {
                            this.fLastItem = (TreeItem)item;
                            tree.setSelection(new TreeItem[]{this.fLastItem});
                        }
                    }
                }
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (tree.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (tree.equals(e.getSource())) {
                    TreeItem o = tree.getItem(new Point(e.x, e.y));
                    TreeItem selection = tree.getSelection()[0];
                    if (selection.equals(o)) {
                        AbstractInformationControl.this.gotoSelectedElement();
                    }
                }
            }
        });
        int border = (shellStyle & 8) == 0 ? 0 : 1;
        this.fShell.setLayout((Layout)new BorderFillLayout(border));
        if (this.hasHeader()) {
            this.fComposite.setTabList(new Control[]{this.fFilterText, this.fTreeViewer.getTree()});
        } else {
            this.fViewMenuButtonComposite.setTabList(new Control[]{this.fFilterText});
            this.fComposite.setTabList(new Control[]{this.fViewMenuButtonComposite, this.fTreeViewer.getTree()});
        }
        this.setInfoSystemColor();
        this.installFilter();
        this.addDisposeListener(this);
        this.fDeactivateListener = new Listener(){

            public void handleEvent(Event event) {
                if (AbstractInformationControl.this.fIsDecativateListenerActive) {
                    AbstractInformationControl.this.dispose();
                }
            }
        };
        this.fShell.addListener(27, this.fDeactivateListener);
        this.fIsDecativateListenerActive = true;
        this.fShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                if (e.widget == AbstractInformationControl.this.fShell && AbstractInformationControl.this.fShell.getShells().length == 0) {
                    AbstractInformationControl.this.fIsDecativateListenerActive = true;
                }
            }
        });
        this.fShell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                AbstractInformationControl.this.fBounds = AbstractInformationControl.this.fShell.getBounds();
                if (AbstractInformationControl.this.fTrim != null) {
                    Point location = AbstractInformationControl.this.fComposite.getLocation();
                    ((AbstractInformationControl)AbstractInformationControl.this).fBounds.x = ((AbstractInformationControl)AbstractInformationControl.this).fBounds.x - ((AbstractInformationControl)AbstractInformationControl.this).fTrim.x + location.x;
                    ((AbstractInformationControl)AbstractInformationControl.this).fBounds.y = ((AbstractInformationControl)AbstractInformationControl.this).fBounds.y - ((AbstractInformationControl)AbstractInformationControl.this).fTrim.y + location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                AbstractInformationControl.this.fBounds = AbstractInformationControl.this.fShell.getBounds();
                if (AbstractInformationControl.this.fTrim != null) {
                    Point location = AbstractInformationControl.this.fComposite.getLocation();
                    ((AbstractInformationControl)AbstractInformationControl.this).fBounds.x = ((AbstractInformationControl)AbstractInformationControl.this).fBounds.x - ((AbstractInformationControl)AbstractInformationControl.this).fTrim.x + location.x;
                    ((AbstractInformationControl)AbstractInformationControl.this).fBounds.y = ((AbstractInformationControl)AbstractInformationControl.this).fBounds.y - ((AbstractInformationControl)AbstractInformationControl.this).fTrim.y + location.y;
                }
            }
        });
    }

    public AbstractInformationControl(Shell parent, int shellStyle, int treeStyle) {
        this(parent, shellStyle, treeStyle, null, false);
    }

    protected abstract TreeViewer createTreeViewer(Composite var1, int var2);

    protected abstract String getId();

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    protected boolean hasHeader() {
        return false;
    }

    protected void createHeader(Composite parent) {
    }

    protected Text getFilterText() {
        return this.fFilterText;
    }

    protected Text createFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        GridData data = new GridData(768);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    AbstractInformationControl.this.gotoSelectedElement();
                }
                if (e.keyCode == 0x1000002) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.keyCode == 0x1000001) {
                    AbstractInformationControl.this.fTreeViewer.getTree().setFocus();
                }
                if (e.character == '\u001b') {
                    AbstractInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return this.fFilterText;
    }

    protected void createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 259);
        separator.setLayoutData((Object)new GridData(768));
    }

    private void createViewMenu(Composite toolbar) {
        this.fToolBar = new ToolBar(toolbar, 0x800000);
        ToolItem viewMenuButton = new ToolItem(this.fToolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        data.verticalAlignment = 1;
        this.fToolBar.setLayoutData((Object)data);
        viewMenuButton.setImage(PluginImages.get("view_menu.gif"));
        viewMenuButton.setDisabledImage(PluginImages.get("view_menu.gif"));
        viewMenuButton.setToolTipText("View Menu");
        viewMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractInformationControl.this.showViewMenu();
            }
        });
        IWorkbenchPart part = RuntimePlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        IWorkbenchPartSite site = part.getSite();
        this.fKeyBindingService = site.getKeyBindingService();
        this.fKeyBindingScopes = this.fKeyBindingService.getScopes();
        this.fKeyBindingService.setScopes(new String[]{"org.eclipse.ui.contexts.window"});
        this.fShowViewMenuAction = new Action("showViewMenu"){

            public void run() {
                AbstractInformationControl.this.showViewMenu();
            }
        };
        this.fShowViewMenuAction.setEnabled(true);
        this.fShowViewMenuAction.setActionDefinitionId("org.eclipse.ui.window.showViewMenu");
        this.fShowViewMenuHandlerSubmission = new ExecutionListener(this.fShowViewMenuAction.getActionDefinitionId(), this.fShowViewMenuAction);
        ((ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class)).addExecutionListener(this.fShowViewMenuHandlerSubmission);
    }

    private MenuManager getViewMenuManager() {
        if (this.fViewMenuManager == null) {
            this.fViewMenuManager = new MenuManager();
            this.fillViewMenu((IMenuManager)this.fViewMenuManager);
        }
        return this.fViewMenuManager;
    }

    private void showViewMenu() {
        this.fIsDecativateListenerActive = false;
        Menu aMenu = this.getViewMenuManager().createContextMenu((Control)this.fShell);
        Rectangle bounds = this.fToolBar.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.fShell.toDisplay(topLeft);
        aMenu.setLocation(topLeft.x, topLeft.y);
        aMenu.setVisible(true);
    }

    private void createStatusField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label separator = new Label(composite, 259);
        separator.setLayoutData((Object)new GridData(768));
        this.fStatusField = new Label(parent, 131072);
        this.fStatusField.setLayoutData((Object)new GridData(768));
        this.fStatusField.setText(this.getStatusFieldText());
        Font font = this.fStatusField.getFont();
        Display display = parent.getDisplay();
        FontData[] fontDatas = font.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setHeight(fontDatas[i].getHeight() * 9 / 10);
            ++i;
        }
        this.fStatusTextFont = new Font((Device)display, fontDatas);
        this.fStatusField.setFont(this.fStatusTextFont);
        this.fStatusField.setForeground(display.getSystemColor(17));
    }

    protected void updateStatusFieldText() {
        if (this.fStatusField != null) {
            this.fStatusField.setText(this.getStatusFieldText());
        }
    }

    protected void handleStatusFieldClicked() {
    }

    protected String getStatusFieldText() {
        return "";
    }

    private void setInfoSystemColor() {
        Display display = this.fShell.getDisplay();
        this.setForegroundColor(display.getSystemColor(28));
        this.setBackgroundColor(display.getSystemColor(29));
    }

    private void installFilter() {
        this.fFilterText.setText("");
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0 && text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                AbstractInformationControl.this.setMatcherString(text);
            }
        });
    }

    protected void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    protected void setMatcherString(String pattern) {
        if (pattern.length() == 0) {
            this.fStringMatcher = null;
        } else {
            boolean ignoreCase = pattern.toLowerCase().equals(pattern);
            this.fStringMatcher = new StringMatcher(pattern, ignoreCase, false);
        }
        this.stringMatcherUpdated();
    }

    protected StringMatcher getMatcher() {
        return this.fStringMatcher;
    }

    protected Object getSelectedElement() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            try {
                this.dispose();
                if (selectedElement instanceof IFile) {
                    AbstractInformationControl.openInEditor((IFile)selectedElement, true);
                } else {
                    IWorkbenchPage p = RuntimePlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editor = p.getActiveEditor();
                    UniversalEditor ue = (UniversalEditor)editor;
                    IParseController parseController = ue.getParseController();
                    ISourcePositionLocator locator = parseController.getNodeLocator();
                    Object element = selectedElement;
                    if (element instanceof ModelTreeNode) {
                        element = ((ModelTreeNode)selectedElement).getASTNode();
                    }
                    ue.selectAndReveal(locator.getStartOffset(element), 0);
                }
            }
            catch (CoreException ex) {
                RuntimePlugin.getInstance().writeErrorMsg(ex.getMessage());
            }
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (file != null && (p = RuntimePlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)p, (IFile)file, (boolean)activate);
            return editorPart;
        }
        return null;
    }

    protected void selectFirstMatch() {
        Tree tree = this.fTreeViewer.getTree();
        Object element = this.findElement(tree.getItems());
        if (element != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findElement(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.fTreeViewer.getLabelProvider();
        int i = 0;
        while (i < items.length) {
            String label;
            Object element = items[i].getData();
            if (this.fStringMatcher == null) {
                return element;
            }
            if (element != null && this.fStringMatcher.match(label = labelProvider.getText(element))) {
                return element;
            }
            element = this.findElement(items[i].getItems());
            if (element != null) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public void setInformation(String information) {
    }

    public abstract void setInput(Object var1);

    protected void fillViewMenu(IMenuManager viewMenu) {
        viewMenu.add((IContributionItem)new GroupMarker("SystemMenuStart"));
        viewMenu.add((IAction)new MoveAction());
        viewMenu.add((IAction)new ResizeAction());
        viewMenu.add((IAction)new RememberBoundsAction());
        viewMenu.add((IContributionItem)new Separator("SystemMenuEnd"));
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.fillViewMenu(viewMenu);
        }
    }

    protected void inputChanged(Object newInput, Object newSelection) {
        this.fFilterText.setText("");
        this.fTreeViewer.setInput(newInput);
        if (newSelection != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(newSelection));
        }
    }

    public void setVisible(boolean visible) {
        if (visible || this.fIsDecativateListenerActive) {
            this.fShell.setVisible(visible);
        }
    }

    public final void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        } else {
            this.widgetDisposed(null);
        }
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.fStatusTextFont != null && !this.fStatusTextFont.isDisposed()) {
            this.fStatusTextFont.dispose();
        }
        this.fShell = null;
        this.fTreeViewer = null;
        this.fComposite = null;
        this.fFilterText = null;
        this.fStatusTextFont = null;
        ((ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class)).removeExecutionListener(this.fShowViewMenuHandlerSubmission);
        if (this.fKeyBindingScopes != null && this.fKeyBindingService != null) {
            this.fKeyBindingService.setScopes(this.fKeyBindingScopes);
            this.fKeyBindingScopes = null;
            this.fKeyBindingService = null;
        }
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        if (maxWidth > -1 && maxHeight > -1) {
            GridData gd = new GridData(1808);
            if (maxWidth > -1) {
                gd.widthHint = maxWidth;
            }
            if (maxHeight > -1) {
                gd.heightHint = maxHeight;
            }
            this.fShell.setLayoutData((Object)gd);
        }
    }

    public Point computeSizeHint() {
        return this.fShell.computeSize(-1, -1);
    }

    public Rectangle getBounds() {
        return this.fBounds;
    }

    public boolean restoresLocation() {
        return !this.getDialogSettings().getBoolean(STORE_DISABLE_RESTORE_LOCATION);
    }

    public boolean restoresSize() {
        return !this.getDialogSettings().getBoolean(STORE_DISABLE_RESTORE_SIZE);
    }

    public Rectangle computeTrim() {
        if (this.fTrim != null) {
            return this.fTrim;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public void setLocation(Point location) {
        this.fTrim = this.fShell.computeTrim(0, 0, 0, 0);
        Point compositeLocation = this.fComposite.getLocation();
        location.x += this.fTrim.x - compositeLocation.x;
        location.y += this.fTrim.y - compositeLocation.y;
        this.fShell.setLocation(location);
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fTreeViewer.getTree().setForeground(foreground);
        this.fFilterText.setForeground(foreground);
        this.fComposite.setForeground(foreground);
        this.fViewMenuButtonComposite.setForeground(foreground);
        if (this.fStatusField != null) {
            this.fStatusField.getParent().setForeground(foreground);
        }
    }

    public void setBackgroundColor(Color background) {
        this.fTreeViewer.getTree().setBackground(background);
        this.fFilterText.setBackground(background);
        this.fComposite.setBackground(background);
        this.fViewMenuButtonComposite.setBackground(background);
        if (this.fStatusField != null) {
            this.fStatusField.setBackground(background);
            this.fStatusField.getParent().setBackground(background);
        }
        if (this.fViewMenuButton != null) {
            this.fViewMenuButton.setBackground(background);
        }
        if (this.fToolBar != null) {
            this.fToolBar.setBackground(background);
        }
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void setFocus() {
        this.fShell.forceFocus();
        this.fFilterText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fShell.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fShell.removeFocusListener(listener);
    }

    protected final Command getInvokingCommand() {
        return this.fInvokingCommand;
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getId();
        IDialogSettings settings = RuntimePlugin.getInstance().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = RuntimePlugin.getInstance().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    private static class BorderFillLayout
    extends Layout {
        final int fBorderSize;

        public BorderFillLayout(int borderSize) {
            if (borderSize < 0) {
                throw new IllegalArgumentException();
            }
            this.fBorderSize = borderSize;
        }

        public int getBorderSize() {
            return this.fBorderSize;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(0, 0);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Point size = children[i].computeSize(wHint, hHint, flushCache);
                    minSize.x = Math.max(minSize.x, size.x);
                    minSize.y = Math.max(minSize.y, size.y);
                    ++i;
                }
            }
            minSize.x += this.fBorderSize * 2 + 3;
            minSize.y += this.fBorderSize * 2;
            return minSize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point minSize = new Point(composite.getClientArea().width, composite.getClientArea().height);
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    Control child = children[i];
                    child.setSize(minSize.x - this.fBorderSize * 2, minSize.y - this.fBorderSize * 2);
                    child.setLocation(this.fBorderSize, this.fBorderSize);
                    ++i;
                }
            }
        }
    }

    private class ExecutionListener
    implements IExecutionListener {
        private final String fCommandDefID;
        private final IAction fAction;

        public ExecutionListener(String cmdDefID, IAction action) {
            this.fCommandDefID = cmdDefID;
            this.fAction = action;
        }

        public void notHandled(String commandId, NotHandledException exception) {
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
        }

        public void preExecute(String commandId, ExecutionEvent event) {
            this.fAction.run();
        }
    }

    private class MoveAction
    extends Action {
        MoveAction() {
            super("Move", 1);
        }

        public void run() {
            Tracker tracker = new Tracker(AbstractInformationControl.this.fShell.getDisplay(), 0);
            tracker.setStippled(true);
            Rectangle[] r = new Rectangle[]{AbstractInformationControl.this.getFilterText().getShell().getBounds()};
            tracker.setRectangles(r);
            if (tracker.open()) {
                AbstractInformationControl.this.fShell.setBounds(tracker.getRectangles()[0]);
            }
        }
    }

    public class NamePatternFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = AbstractInformationControl.this.getMatcher();
            if (matcher == null || !(viewer instanceof TreeViewer)) {
                return true;
            }
            TreeViewer treeViewer = (TreeViewer)viewer;
            String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
            if (matchName != null && matcher.match(matchName)) {
                return true;
            }
            return this.hasUnfilteredChild(treeViewer, element);
        }

        private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
            Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
            int i = 0;
            while (i < children.length) {
                if (this.select((Viewer)viewer, element, children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private class RememberBoundsAction
    extends Action {
        RememberBoundsAction() {
            super("Remember Size and Location", 2);
            this.setChecked(!AbstractInformationControl.this.getDialogSettings().getBoolean(AbstractInformationControl.STORE_DISABLE_RESTORE_LOCATION));
        }

        public void run() {
            IDialogSettings settings = AbstractInformationControl.this.getDialogSettings();
            boolean newValue = !this.isChecked();
            settings.put(AbstractInformationControl.STORE_DISABLE_RESTORE_LOCATION, newValue);
            settings.put(AbstractInformationControl.STORE_DISABLE_RESTORE_SIZE, newValue);
            AbstractInformationControl.this.fIsDecativateListenerActive = true;
        }
    }

    private class ResizeAction
    extends Action {
        ResizeAction() {
            super("Resize", 1);
        }

        public void run() {
            Tracker tracker = new Tracker(AbstractInformationControl.this.fShell.getDisplay(), 16);
            tracker.setStippled(true);
            Rectangle[] r = new Rectangle[]{AbstractInformationControl.this.getFilterText().getShell().getBounds()};
            tracker.setRectangles(r);
            if (tracker.open()) {
                AbstractInformationControl.this.fShell.setBounds(tracker.getRectangles()[0]);
            }
        }
    }
}

