/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyInfo {
    protected final Map<String, Set<String>> fDependsUpon = new HashMap<String, Set<String>>();
    protected final Map<String, Set<String>> fIsDependedUponBy = new HashMap<String, Set<String>>();
    protected final IProject fProject;
    protected final String fWorkspacePath;

    public DependencyInfo(IProject project) {
        this.fProject = project;
        this.fWorkspacePath = this.fProject.getProject().getWorkspace().getRoot().getLocation().toString();
    }

    protected Set<String> getEntry(Map<String, Set<String>> map, String unitPath) {
        Set<String> result = !map.containsKey(unitPath) ? Collections.emptySet() : map.get(unitPath);
        return result;
    }

    protected Set<String> getOrCreateEntry(Map<String, Set<String>> map, String unitPath) {
        Set<String> result;
        if (!map.containsKey(unitPath)) {
            result = new HashSet<String>();
            map.put(unitPath, result);
        } else {
            result = map.get(unitPath);
        }
        return result;
    }

    public void addDependency(String fromPath, String uponPath) {
        Set<String> fwdEntry = this.getOrCreateEntry(this.fDependsUpon, fromPath);
        fwdEntry.add(uponPath);
        Set<String> bkwdEntry = this.getOrCreateEntry(this.fIsDependedUponBy, uponPath);
        bkwdEntry.add(fromPath);
    }

    public void clearAllDependencies() {
        this.fDependsUpon.clear();
        this.fIsDependedUponBy.clear();
    }

    public void clearDependenciesOf(String unitPath) {
        Set<String> entry = this.getEntry(this.fDependsUpon, unitPath);
        this.fDependsUpon.put(unitPath, new HashSet());
        for (String uponPath : entry) {
            Set<String> uponSet = this.getEntry(this.fIsDependedUponBy, uponPath);
            uponSet.remove(unitPath);
        }
    }

    public Map getDependencies() {
        return Collections.unmodifiableMap(this.fDependsUpon);
    }

    public Set getDependentsOf(String unitPath) {
        return this.fIsDependedUponBy.get(unitPath);
    }

    public void dump() {
        System.out.println("*** Dependencies ***:");
        for (String unit : this.fDependsUpon.keySet()) {
            Set<String> dependents = this.fDependsUpon.get(unit);
            System.out.println("Unit " + unit + ": ");
            Iterator<String> iterator = dependents.iterator();
            while (iterator.hasNext()) {
                String uponUnit = iterator.next();
                System.out.print("  ");
                System.out.print(uponUnit);
                if (!iterator.hasNext()) continue;
                System.out.print(", ");
            }
            System.out.println();
        }
    }
}

