/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyCollections;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyList<E>
extends LazyCollection<E>
implements EList<E> {
    public LazyList(Iterable<E> dataSource) {
        super(dataSource);
    }

    public LazyList() {
    }

    @Override
    protected void createCache() {
        super.createCache();
        if (this.cache == null) {
            this.cache = new ArrayList();
        }
        assert (this.cache instanceof List);
    }

    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    public E get(int index) {
        if (index < this.cache.size()) {
            return ((List)this.cache).get(index);
        }
        int i = 0;
        for (Object e : this) {
            if (i == index) {
                return e;
            }
            ++i;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int indexOf(Object o) {
        int index = ((List)this.cache).indexOf(o);
        if (index > -1 || this.dataSource == null) {
            return index;
        }
        int i = 0;
        if (o == null) {
            for (Object e : this) {
                if (e == null) {
                    return i;
                }
                ++i;
            }
        } else {
            for (Object e : this) {
                if (o.equals(e)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        if (this.dataSource == null) {
            return ((List)this.cache).lastIndexOf(o);
        }
        int i = 0;
        int lastIndex = -1;
        if (o == null) {
            for (Object e : this) {
                if (e == null) {
                    lastIndex = i;
                }
                ++i;
            }
        } else {
            for (Object e : this) {
                if (e.equals(o)) {
                    lastIndex = i;
                }
                ++i;
            }
        }
        return lastIndex;
    }

    public ListIterator<E> listIterator() {
        if (this.dataSource == null) {
            return Collections.unmodifiableList((List)this.cache).listIterator();
        }
        return new LazyCollection.IteratorToListIterator(this);
    }

    public ListIterator<E> listIterator(int index) {
        if (this.dataSource == null) {
            return Collections.unmodifiableList((List)this.cache).listIterator(index);
        }
        return new LazyCollection.IteratorToListIterator((LazyCollection)this, index);
    }

    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    public LazyList<E> subList(int fromIndex, int toIndex) {
        return new SubList(fromIndex, toIndex, this);
    }

    public void move(int newPosition, E object) {
        throw new UnsupportedOperationException();
    }

    public E move(int newPosition, int oldPosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        Iterator e1 = this.iterator();
        Iterator e2 = ((Collection)o).iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (!(o1 == null ? o2 != null : !o1.equals(o2))) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    public String asString(ExecEnv env) {
        return this.appendElements(new StringBuffer("Sequence{"), env).append('}').toString();
    }

    public E at(int i) {
        return this.get(i - 1);
    }

    public int indexOf2(Object obj) throws IndexOutOfBoundsException {
        int i = this.indexOf(obj) + 1;
        if (i == 0) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    public int lastIndexOf2(Object obj) throws IndexOutOfBoundsException {
        int i = this.lastIndexOf(obj) + 1;
        if (i == 0) {
            throw new IndexOutOfBoundsException();
        }
        return i;
    }

    public E first() {
        if (this.cache.size() > 0) {
            return ((List)this.cache).get(0);
        }
        return this.iterator().next();
    }

    public E last() {
        if (this.dataSource == null) {
            int size = this.cache.size();
            if (size < 1) {
                throw new NoSuchElementException();
            }
            return ((List)this.cache).get(size - 1);
        }
        boolean lastSet = false;
        E last2 = null;
        for (E last2 : this) {
            lastSet = true;
        }
        if (!lastSet) {
            throw new NoSuchElementException();
        }
        return last2;
    }

    public LazyList<E> union(LazyList<? extends E> s) {
        return new UnionList<E>(s, this);
    }

    public LazyList<E> union(LazyList<? extends E> s, int index) {
        if (index == 1) {
            return this.union(s);
        }
        return this.subSequence(1, index - 1).union(s).union(this.subSequence(index, this.size()));
    }

    public LazyList<?> flatten() {
        final LazyList inner = this;
        return new LazyList<Object>(new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new LazyCollection.FlattenIterator(inner);
            }
        });
    }

    public LazyList<E> append(E object) {
        return new AppendList<E>(object, this);
    }

    public LazyList<E> prepend(E object) {
        return new PrependList<E>(object, this);
    }

    public LazyList<E> insertAt(int index, E object) {
        return new InsertAtList<E>(index - 1, object, this);
    }

    public LazyList<E> subSequence(int lower, int upper) {
        return new SubList(lower - 1, upper, this);
    }

    @Override
    public LazyList<E> including(E object) {
        return this.append(object);
    }

    @Override
    public LazyList<E> including(E object, int index) {
        if (index > 0) {
            return this.insertAt(index, object);
        }
        return this.append(object);
    }

    @Override
    public LazyList<E> includingAll(Collection<? extends E> coll) {
        return this.union(LazyCollections.asLazyList(coll));
    }

    @Override
    public LazyList<E> includingAll(Collection<? extends E> coll, int index) {
        if (index > 0) {
            return this.union(LazyCollections.asLazyList(coll), index);
        }
        return this.union(LazyCollections.asLazyList(coll));
    }

    @Override
    public LazyList<E> excluding(final Object object) {
        return new LazyList<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.ExcludingIterator((LazyCollection)this, object);
            }
        };
    }

    @Override
    public LazyList<E> excludingAll(final Collection<?> coll) {
        return new LazyList<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.SubtractionIterator((LazyCollection)this, coll);
            }
        };
    }

    public LazyList<E> reverse() {
        return new ReverseList(this);
    }

    @Override
    public LazyList<E> asSequence() {
        return this;
    }

    @Override
    public LazyList<E> includingRange(E first, E last) {
        if (first instanceof Integer && last instanceof Integer) {
            return this.union(new IntegerRangeList((Integer)first, (Integer)last));
        }
        if (first instanceof Long && last instanceof Long) {
            return this.union(new LongRangeList((Long)first, (Long)last));
        }
        throw new IllegalArgumentException(String.format("includingRange() not supported for arguments of type %s and %s", first.getClass().getName(), last.getClass().getName()));
    }

    public LazyList<E> select(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        condition.setParentFrame(null);
        return new LazyList<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.SelectIterator(this, condition, parentFrame);
            }
        };
    }

    public LazyList<E> reject(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        condition.setParentFrame(null);
        return new LazyList<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.RejectIterator(this, condition, parentFrame);
            }
        };
    }

    public <T> LazyList<T> collect(final CodeBlock function) {
        final StackFrame parentFrame = function.getParentFrame();
        function.setParentFrame(null);
        final LazyList inner = this;
        return new LazyList<T>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new LazyCollection.CollectIterator(inner, function, parentFrame);
            }
        }){

            @Override
            public T get(int index) {
                if (index < this.cache.size()) {
                    return ((List)this.cache).get(index);
                }
                return function.execute(parentFrame.getSubFrame(function, inner.get(index)));
            }

            @Override
            public T last() {
                if (this.dataSource == null) {
                    int size = this.cache.size();
                    if (size < 1) {
                        throw new NoSuchElementException();
                    }
                    return ((List)this.cache).get(size - 1);
                }
                return function.execute(parentFrame.getSubFrame(function, inner.last()));
            }

            @Override
            public int size() {
                return inner.size();
            }
        };
    }

    @Override
    public LazyList<E> sortedBy(final CodeBlock body) {
        final StackFrame parentFrame = body.getParentFrame();
        body.setParentFrame(null);
        return new LazyList<E>(this){

            @Override
            public Iterator<E> iterator() {
                Collection inner = (Collection)this.dataSource;
                if (inner != null) {
                    LazyCollection.CollectIterator sortingKeys = new LazyCollection.CollectIterator(inner, body, parentFrame);
                    Object[] innerCopy = inner.toArray();
                    final HashMap<Object, Comparable> elementsToKeys = new HashMap<Object, Comparable>(innerCopy.length);
                    Object[] objectArray = innerCopy;
                    int n = innerCopy.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        elementsToKeys.put(o, (Comparable)sortingKeys.next());
                        ++n2;
                    }
                    if (!$assertionsDisabled && sortingKeys.hasNext()) {
                        throw new AssertionError();
                    }
                    Arrays.sort(innerCopy, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            return ((Comparable)elementsToKeys.get(o1)).compareTo(elementsToKeys.get(o2));
                        }
                    });
                    this.cache = Arrays.asList(innerCopy);
                    this.dataSource = null;
                }
                return super.iterator();
            }

            @Override
            public int size() {
                if (this.dataSource == null) {
                    return this.cache.size();
                }
                return ((Collection)this.dataSource).size();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AppendList<E>
    extends NonCachingList<E> {
        protected final E object;

        public AppendList(E object, LazyList<E> dataSource) {
            super(dataSource);
            this.object = object;
        }

        @Override
        public E last() {
            return this.object;
        }

        @Override
        public E get(int index) {
            int size = ((List)this.dataSource).size();
            if (index < size) {
                return ((List)this.dataSource).get(index);
            }
            if (index == size) {
                return this.object;
            }
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public int indexOf(Object o) {
            int index = ((List)this.dataSource).indexOf(o);
            if (index > -1) {
                return index;
            }
            return (this.object == null ? o == null : this.object.equals(o)) ? this.size() - 1 : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.object == null ? o == null : this.object.equals(o)) {
                return this.size() - 1;
            }
            return ((List)this.dataSource).lastIndexOf(o);
        }

        @Override
        public boolean contains(Object o) {
            return !(this.object == null ? o != null : !this.object.equals(o)) || ((Collection)this.dataSource).contains(o);
        }

        @Override
        public int count(Object o) {
            return (this.object == null ? o == null : this.object.equals(o)) ? 1 : 0 + ((LazyCollection)this.dataSource).count(o);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.AppendIterator(this, this.object);
        }

        @Override
        public int size() {
            return ((Collection)this.dataSource).size() + 1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new AppendListIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new AppendListIterator(index);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AppendListIterator
        extends LazyCollection.WrappedListIterator {
            protected boolean beforeTail;

            public AppendListIterator() {
                super(AppendList.this);
                this.beforeTail = true;
            }

            public AppendListIterator(int index) {
                super(AppendList.this, index > 0 ? index - 1 : index);
                this.beforeTail = true;
                if (index > 0) {
                    this.next();
                }
            }

            @Override
            public boolean hasNext() {
                assert (this.beforeTail || !this.inner.hasNext());
                return this.beforeTail;
            }

            @Override
            public E next() {
                if (this.inner.hasNext()) {
                    return this.inner.next();
                }
                if (this.beforeTail) {
                    this.beforeTail = false;
                    return AppendList.this.object;
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this.inner.nextIndex() + (this.beforeTail ? 0 : 1);
            }

            @Override
            public boolean hasPrevious() {
                return !this.beforeTail || this.inner.hasPrevious();
            }

            @Override
            public E previous() {
                if (!this.beforeTail) {
                    this.beforeTail = true;
                    return AppendList.this.object;
                }
                return this.inner.previous();
            }

            @Override
            public int previousIndex() {
                return this.inner.previousIndex() + (this.beforeTail ? 0 : 1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectList<E>
    extends LazyList<E> {
        public CollectList(LazyList<E> dataSource) {
            super(dataSource);
            assert (dataSource != null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InsertAtList<E>
    extends AppendList<E> {
        protected final int index;

        public InsertAtList(int index, E object, LazyList<E> dataSource) {
            super(object, dataSource);
            this.index = index;
            if (index < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
        }

        @Override
        public E first() {
            assert (this.index >= 0);
            return (E)(this.index == 0 ? this.object : ((LazyList)this.dataSource).first());
        }

        @Override
        public E last() {
            int size = ((Collection)this.dataSource).size();
            if (this.index < size) {
                return ((LazyList)this.dataSource).last();
            }
            if (this.index == size) {
                return (E)this.object;
            }
            throw new IndexOutOfBoundsException(String.valueOf(this.index));
        }

        @Override
        public E get(int index) {
            int size = ((List)this.dataSource).size();
            if (index <= size) {
                if (index < this.index) {
                    return ((List)this.dataSource).get(index);
                }
                if (index == this.index) {
                    return (E)this.object;
                }
                assert (this.index >= 0);
                assert (index > this.index);
                return ((List)this.dataSource).get(index - 1);
            }
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public int indexOf(Object o) {
            int indexOf = ((List)this.dataSource).indexOf(o);
            if (indexOf > -1) {
                assert (this.index >= 0);
                if (indexOf > this.index && (this.object == null ? o == null : this.object.equals(o))) {
                    return this.index;
                }
                return indexOf;
            }
            if (this.object == null ? o == null : this.object.equals(o)) {
                if (this.index <= ((Collection)this.dataSource).size()) {
                    return this.index;
                }
                throw new IndexOutOfBoundsException(String.valueOf(this.index));
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int lastIndexOf = ((List)this.dataSource).lastIndexOf(o);
            if (lastIndexOf > -1) {
                assert (this.index >= 0);
                if (lastIndexOf < this.index && (this.object == null ? o == null : this.object.equals(o))) {
                    return this.index;
                }
                return lastIndexOf;
            }
            if (this.object == null ? o == null : this.object.equals(o)) {
                if (this.index <= ((Collection)this.dataSource).size()) {
                    return this.index;
                }
                throw new IndexOutOfBoundsException(String.valueOf(this.index));
            }
            return -1;
        }

        @Override
        public Iterator<E> iterator() {
            return new InsertAtIterator();
        }

        @Override
        public ListIterator<E> listIterator() {
            return new InsertAtListIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new InsertAtListIterator(index);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InsertAtIterator
        extends LazyCollection.WrappedIterator {
            protected int i;

            public InsertAtIterator() {
                super(InsertAtList.this);
                this.i = -1;
            }

            @Override
            public boolean hasNext() {
                return this.i < InsertAtList.this.index || this.inner.hasNext();
            }

            @Override
            public E next() {
                if (++this.i == InsertAtList.this.index) {
                    return InsertAtList.this.object;
                }
                return this.inner.next();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InsertAtListIterator
        extends LazyCollection.WrappedListIterator {
            protected int i;

            public InsertAtListIterator() {
                super(InsertAtList.this);
                this.i = -1;
            }

            public InsertAtListIterator(int index) {
                super(InsertAtList.this, index < InsertAtList.this.index ? index : index - 1);
                this.i = -1;
                this.i = index - 1;
            }

            @Override
            public boolean hasNext() {
                return this.i < InsertAtList.this.index || this.inner.hasNext();
            }

            @Override
            public E next() {
                if (++this.i == InsertAtList.this.index) {
                    return InsertAtList.this.object;
                }
                return this.inner.next();
            }

            @Override
            public int nextIndex() {
                return this.i + 1;
            }

            @Override
            public boolean hasPrevious() {
                return this.i >= InsertAtList.this.index || this.inner.hasPrevious();
            }

            @Override
            public E previous() {
                if (this.i-- == InsertAtList.this.index) {
                    return InsertAtList.this.object;
                }
                return this.inner.previous();
            }

            @Override
            public int previousIndex() {
                return this.i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerRangeList
    extends LazyList<Integer> {
        protected final int first;
        protected final int last;

        public IntegerRangeList(int first, int last) {
            if (first > last) {
                throw new IllegalArgumentException(String.format("The first element of a range (%d) cannot be greater than the last (%d)", first, last));
            }
            this.first = first;
            this.last = last;
        }

        @Override
        protected void createCache() {
        }

        @Override
        public Integer first() {
            return this.first;
        }

        @Override
        public Integer get(int index) {
            int element = this.first + index;
            if (element > this.last) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            return element;
        }

        @Override
        public int indexOf(Object o) {
            if (this.contains(o)) {
                return (Integer)o - this.first;
            }
            return -1;
        }

        @Override
        public Integer last() {
            return this.last;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public ListIterator<Integer> listIterator() {
            return new LazyCollection.IntegerRangeListIterator(this.first, this.last);
        }

        @Override
        public ListIterator<Integer> listIterator(int index) {
            return new LazyCollection.IntegerRangeListIterator(this.first, this.last, index);
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Integer) {
                Integer obj = (Integer)o;
                return obj >= this.first && obj <= this.last;
            }
            return false;
        }

        @Override
        public int count(Object object) {
            return this.contains(object) ? 1 : 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new LazyCollection.IntegerRangeListIterator(this.first, this.last);
        }

        @Override
        public int size() {
            return this.last - this.first + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongRangeList
    extends LazyList<Long> {
        protected final long first;
        protected final long last;

        public LongRangeList(long first, long last) {
            if (first > last) {
                throw new IllegalArgumentException(String.format("The first element of a range (%d) cannot be greater than the last (%d)", first, last));
            }
            this.first = first;
            this.last = last;
        }

        @Override
        protected void createCache() {
        }

        @Override
        public Long first() {
            return this.first;
        }

        @Override
        public Long get(int index) {
            long element = this.first + (long)index;
            if (element > this.last) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            return element;
        }

        @Override
        public int indexOf(Object o) {
            if (this.contains(o)) {
                return (int)((Long)o - this.first);
            }
            return -1;
        }

        @Override
        public Long last() {
            return this.last;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public ListIterator<Long> listIterator() {
            return new LazyCollection.LongRangeListIterator(this.first, this.last);
        }

        @Override
        public ListIterator<Long> listIterator(int index) {
            return new LazyCollection.LongRangeListIterator(this.first, this.last, index);
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Long) {
                Long obj = (Long)o;
                return obj >= this.first && obj <= this.last;
            }
            return false;
        }

        @Override
        public int count(Object object) {
            return this.contains(object) ? 1 : 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Long> iterator() {
            return new LazyCollection.LongRangeListIterator(this.first, this.last);
        }

        @Override
        public int size() {
            return (int)(this.last - this.first + 1L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NonCachingList<E>
    extends LazyList<E> {
        public NonCachingList(Iterable<E> dataSource) {
            super(dataSource);
            assert (dataSource != null);
        }

        @Override
        protected void createCache() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrependList<E>
    extends AppendList<E> {
        public PrependList(E object, LazyList<E> dataSource) {
            super(object, dataSource);
        }

        @Override
        public E first() {
            return (E)this.object;
        }

        @Override
        public E last() {
            if (!((LazyList)this.dataSource).isEmpty()) {
                return ((LazyList)this.dataSource).last();
            }
            return (E)this.object;
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return (E)this.object;
            }
            return ((List)this.dataSource).get(index - 1);
        }

        @Override
        public int indexOf(Object o) {
            if (this.object == null ? o == null : this.object.equals(o)) {
                return 0;
            }
            int index = ((List)this.dataSource).indexOf(o);
            return index > -1 ? index + 1 : index;
        }

        @Override
        public int lastIndexOf(Object o) {
            int lastIndex = ((List)this.dataSource).lastIndexOf(o) + 1;
            if (lastIndex > 0) {
                return lastIndex;
            }
            return (this.object == null ? o == null : this.object.equals(o)) ? 0 : -1;
        }

        @Override
        public Iterator<E> iterator() {
            return new PrependIterator();
        }

        @Override
        public ListIterator<E> listIterator() {
            return new PrependListIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new PrependListIterator(index);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class PrependIterator
        extends LazyCollection.WrappedIterator {
            protected boolean beforeHead;

            public PrependIterator() {
                super(PrependList.this);
                this.beforeHead = true;
            }

            @Override
            public boolean hasNext() {
                return this.beforeHead || this.inner.hasNext();
            }

            @Override
            public E next() {
                if (this.beforeHead) {
                    this.beforeHead = false;
                    return PrependList.this.object;
                }
                return this.inner.next();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class PrependListIterator
        extends LazyCollection.WrappedListIterator {
            protected boolean beforeHead;

            public PrependListIterator() {
                super(PrependList.this);
                this.beforeHead = true;
            }

            public PrependListIterator(int index) {
                super(PrependList.this, index < 1 ? index : index - 1);
                this.beforeHead = true;
                this.beforeHead = index < 1;
            }

            @Override
            public boolean hasNext() {
                return this.beforeHead || this.inner.hasNext();
            }

            @Override
            public E next() {
                if (this.beforeHead) {
                    this.beforeHead = false;
                    return PrependList.this.object;
                }
                return this.inner.next();
            }

            @Override
            public int nextIndex() {
                if (this.beforeHead) {
                    return 0;
                }
                return this.inner.nextIndex() + 1;
            }

            @Override
            public boolean hasPrevious() {
                assert (this.beforeHead || !this.inner.hasPrevious());
                return !this.beforeHead;
            }

            @Override
            public E previous() {
                if (this.inner.hasPrevious()) {
                    return this.inner.previous();
                }
                if (!this.beforeHead) {
                    this.beforeHead = true;
                    return PrependList.this.object;
                }
                throw new NoSuchElementException();
            }

            @Override
            public int previousIndex() {
                if (this.beforeHead) {
                    return -1;
                }
                return this.inner.previousIndex() + 1;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReverseList<E>
    extends NonCachingList<E> {
        protected final int last;

        public ReverseList(LazyList<E> dataSource) {
            super(dataSource);
            this.last = dataSource.size() - 1;
        }

        @Override
        public E first() {
            return ((List)this.dataSource).get(this.last);
        }

        @Override
        public E last() {
            return ((List)this.dataSource).get(0);
        }

        @Override
        public E get(int index) {
            return ((List)this.dataSource).get(this.last - index);
        }

        @Override
        public int indexOf(Object o) {
            int index = ((List)this.dataSource).indexOf(o);
            if (index > -1) {
                return this.last - index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int index = ((List)this.dataSource).lastIndexOf(o);
            if (index > -1) {
                return this.last - index;
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return ((List)this.dataSource).contains(o);
        }

        @Override
        public boolean isEmpty() {
            return ((List)this.dataSource).isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.ReverseIterator(this, this.last);
        }

        @Override
        public int size() {
            return this.last + 1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new LazyCollection.ReverseListIterator(this, this.last);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new LazyCollection.ReverseListIterator(this, this.last, index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubList<E>
    extends NonCachingList<E> {
        protected final int fromIndex;
        protected final int toIndex;

        public SubList(int fromIndex, int toIndex, LazyList<E> dataSource) {
            super(dataSource);
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            if (fromIndex < 0 || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(fromIndex)) + " - " + String.valueOf(toIndex));
            }
        }

        @Override
        public E first() {
            return ((List)this.dataSource).get(this.fromIndex);
        }

        @Override
        public E last() {
            return ((List)this.dataSource).get(this.toIndex - 1);
        }

        @Override
        public E get(int index) {
            return ((List)this.dataSource).get(index + this.fromIndex);
        }

        @Override
        public int indexOf(Object o) {
            int index = ((List)this.dataSource).indexOf(o);
            if (index >= this.fromIndex && index < this.toIndex) {
                return index - this.fromIndex;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            int index = ((List)this.dataSource).lastIndexOf(o);
            if (index >= this.fromIndex && index < this.toIndex) {
                return index - this.fromIndex;
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            int index = ((List)this.dataSource).indexOf(o);
            return index >= this.fromIndex && index < this.toIndex;
        }

        @Override
        public boolean isEmpty() {
            return this.fromIndex >= this.toIndex;
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.SubListIterator(this, this.fromIndex, this.toIndex);
        }

        @Override
        public int size() {
            return this.toIndex - this.fromIndex;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new LazyCollection.SubListListIterator(this, this.fromIndex, this.toIndex);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new LazyCollection.SubListListIterator(this, this.fromIndex, this.toIndex, index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnionList<E>
    extends NonCachingList<E> {
        protected final LazyList<? extends E> s;

        public UnionList(LazyList<? extends E> s, LazyList<E> dataSource) {
            super(dataSource);
            this.s = s;
            assert (s != null);
        }

        @Override
        public E first() {
            return ((LazyList)this.dataSource).isEmpty() ? this.s.first() : ((LazyList)this.dataSource).first();
        }

        @Override
        public E get(int index) {
            int size = ((List)this.dataSource).size();
            return index < size ? ((List)this.dataSource).get(index) : this.s.get(index - size);
        }

        @Override
        public int indexOf(Object o) {
            int indexOf = ((List)this.dataSource).indexOf(o);
            if (indexOf > -1) {
                return indexOf;
            }
            return ((List)this.dataSource).size() + this.s.indexOf(o);
        }

        @Override
        public E last() {
            return this.s.isEmpty() ? ((LazyList)this.dataSource).last() : this.s.last();
        }

        @Override
        public int lastIndexOf(Object o) {
            int lastIndexOf = this.s.lastIndexOf(o);
            if (lastIndexOf > -1) {
                return ((List)this.dataSource).size() + lastIndexOf;
            }
            return ((List)this.dataSource).lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new UnionListIterator(this.s);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new UnionListIterator(this.s, index);
        }

        @Override
        public boolean contains(Object o) {
            return ((Collection)this.dataSource).contains(o) || this.s.contains(o);
        }

        @Override
        public int count(Object object) {
            return ((LazyCollection)this.dataSource).count(object) + this.s.count(object);
        }

        @Override
        public boolean isEmpty() {
            return ((Collection)this.dataSource).isEmpty() && this.s.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.UnionIterator(this, this.s);
        }

        @Override
        public int size() {
            return ((Collection)this.dataSource).size() + this.s.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UnionListIterator
    extends LazyCollection.WrappedListIterator {
        protected final List<? extends E> s;
        protected ListIterator<? extends E> added;
        protected boolean innerNext;
        protected boolean addedPrev;

        public UnionListIterator(List<? extends E> s) {
            super(LazyList.this);
            this.s = s;
        }

        public UnionListIterator(List<? extends E> s, int index) {
            super(LazyList.this, index);
            this.s = s;
        }

        @Override
        public boolean hasNext() {
            if (this.added == null) {
                this.innerNext = this.inner.hasNext();
                if (this.innerNext) {
                    return true;
                }
                this.added = this.s.listIterator();
            }
            return this.added.hasNext();
        }

        @Override
        public E next() {
            if (this.added == null) {
                if (this.innerNext || this.inner.hasNext()) {
                    this.innerNext = false;
                    return this.inner.next();
                }
                this.added = this.s.listIterator();
            }
            return this.added.next();
        }

        @Override
        public int nextIndex() {
            if (this.added == null) {
                if (this.innerNext || this.inner.hasNext()) {
                    return this.inner.nextIndex();
                }
                this.added = this.s.listIterator();
            }
            return ((Collection)LazyList.this.dataSource).size() + this.added.nextIndex();
        }

        @Override
        public boolean hasPrevious() {
            if (this.added != null) {
                this.addedPrev = this.added.hasPrevious();
                if (this.addedPrev) {
                    return true;
                }
                this.added = null;
            }
            return this.inner.hasPrevious();
        }

        @Override
        public E previous() {
            if (this.added != null) {
                if (this.addedPrev || this.added.hasPrevious()) {
                    this.addedPrev = false;
                    return this.added.previous();
                }
                this.added = null;
            }
            return this.inner.previous();
        }

        @Override
        public int previousIndex() {
            if (this.added != null) {
                if (this.addedPrev || this.added.hasPrevious()) {
                    return ((Collection)LazyList.this.dataSource).size() + this.added.previousIndex();
                }
                this.added = null;
            }
            return this.inner.previousIndex();
        }
    }
}

