/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.common.ConsoleStreamHandler;
import org.eclipse.m2m.atl.core.ui.ATLConsole;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ATLCoreUIPlugin
extends AbstractUIPlugin {
    private static ATLCoreUIPlugin plugin;
    private static Handler[] handlers;
    private static Map<String, Image> path2image;

    static {
        handlers = new Handler[3];
        path2image = new HashMap<String, Image>();
    }

    public ATLCoreUIPlugin() {
        plugin = this;
    }

    public static ATLCoreUIPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(String path) {
        ImageDescriptor descriptor;
        Image result = path2image.get(path);
        if (result == null && !path2image.containsKey(path) && (descriptor = ATLCoreUIPlugin.getImageDescriptor(path)) != null) {
            result = descriptor.createImage();
            path2image.put(path, result);
        }
        if (result != null && result.isDisposed()) {
            result = null;
        }
        return result;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ATLCoreUIPlugin.startConsole();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        ATLCoreUIPlugin.stopConsole();
    }

    public static void startConsole() {
        ATLConsole console = ATLConsole.findConsole();
        IOConsoleOutputStream infoStream = console.newOutputStream();
        IOConsoleOutputStream warningStream = console.newOutputStream();
        IOConsoleOutputStream errorStream = console.newOutputStream();
        infoStream.setColor(new Color((Device)Display.getCurrent(), new RGB(0, 0, 255)));
        warningStream.setColor(new Color((Device)Display.getCurrent(), new RGB(250, 100, 0)));
        errorStream.setColor(new Color((Device)Display.getCurrent(), new RGB(255, 0, 0)));
        ATLCoreUIPlugin.handlers[0] = new ConsoleStreamHandler((OutputStream)infoStream);
        handlers[0].setFilter(new Filter(){

            public boolean isLoggable(LogRecord record) {
                return record.getLevel().equals(Level.INFO);
            }
        });
        ATLCoreUIPlugin.handlers[1] = new ConsoleStreamHandler((OutputStream)warningStream);
        handlers[1].setFilter(new Filter(){

            public boolean isLoggable(LogRecord record) {
                return record.getLevel().equals(Level.WARNING);
            }
        });
        ATLCoreUIPlugin.handlers[2] = new ConsoleStreamHandler((OutputStream)errorStream);
        handlers[2].setFilter(new Filter(){

            public boolean isLoggable(LogRecord record) {
                return record.getLevel().equals(Level.SEVERE);
            }
        });
        int i = 0;
        while (i < handlers.length) {
            ATLLogger.getLogger().addHandler(handlers[i]);
            ++i;
        }
    }

    public static void stopConsole() {
        int i = 0;
        while (i < handlers.length) {
            ATLLogger.getLogger().removeHandler(handlers[i]);
            ++i;
        }
    }

    public static void clearConsole() {
        ATLConsole console = ATLConsole.findConsole();
        if (console != null) {
            console.clearConsole();
        }
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        String pluginDir = plugin.getBundle().getEntry("/").toString();
        try {
            return ImageDescriptor.createFromURL((URL)new URL(String.valueOf(pluginDir) + "icons/" + name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public Shell getShell() {
        return this.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

