/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Opcode implements Enumerator
{
    PUSH(0, "PUSH", "PUSH"),
    PUSHT(1, "PUSHT", "PUSHT"),
    PUSHF(2, "PUSHF", "PUSHF"),
    POP(3, "POP", "POP"),
    LOAD(4, "LOAD", "LOAD"),
    STORE(5, "STORE", "STORE"),
    SET(6, "SET", "SET"),
    GET(7, "GET", "GET"),
    GET_TRANS(8, "GET_TRANS", "GET_TRANS"),
    SET_STATIC(9, "SET_STATIC", "SET_STATIC"),
    GET_STATIC(10, "GET_STATIC", "GET_STATIC"),
    FINDTYPE(11, "FINDTYPE", "FINDTYPE"),
    FINDTYPE_S(12, "FINDTYPE_S", "FINDTYPE_S"),
    NEW(13, "NEW", "NEW"),
    NEW_S(14, "NEW_S", "NEW_S"),
    DELETE(15, "DELETE", "DELETE"),
    DUP(16, "DUP", "DUP"),
    DUP_X1(17, "DUP_X1", "DUP_X1"),
    SWAP(18, "SWAP", "SWAP"),
    SWAP_X1(19, "SWAP_X1", "SWAP_X1"),
    IF(20, "IF", "IF"),
    IFN(21, "IFN", "IFN"),
    GOTO(22, "GOTO", "GOTO"),
    ITERATE(23, "ITERATE", "ITERATE"),
    ENDITERATE(24, "ENDITERATE", "ENDITERATE"),
    INVOKE(25, "INVOKE", "INVOKE"),
    INVOKE_SUPER(26, "INVOKE_SUPER", "INVOKE_SUPER"),
    INVOKE_STATIC(27, "INVOKE_STATIC", "INVOKE_STATIC"),
    ALLINST(28, "ALLINST", "ALLINST"),
    ALLINST_IN(29, "ALLINST_IN", "ALLINST_IN"),
    ISNULL(30, "ISNULL", "ISNULL"),
    GETENVTYPE(31, "GETENVTYPE", "GETENVTYPE"),
    NOT(32, "NOT", "NOT"),
    AND(33, "AND", "AND"),
    OR(34, "OR", "OR"),
    XOR(35, "XOR", "XOR"),
    IMPLIES(36, "IMPLIES", "IMPLIES"),
    IFTE(37, "IFTE", "IFTE"),
    RETURN(38, "RETURN", "RETURN"),
    GETCB(39, "GETCB", "GETCB"),
    INVOKE_ALL_CBS(40, "INVOKE_ALL_CBS", "INVOKE_ALL_CBS"),
    INVOKE_CB(41, "INVOKE_CB", "INVOKE_CB"),
    INVOKE_CB_S(42, "INVOKE_CB_S", "INVOKE_CB_S"),
    MATCH(43, "MATCH", "MATCH"),
    MATCH_S(44, "MATCH_S", "MATCH_S"),
    ADD(45, "ADD", "ADD"),
    REMOVE(46, "REMOVE", "REMOVE"),
    INSERT(47, "INSERT", "INSERT");

    public static final int PUSH_VALUE = 0;
    public static final int PUSHT_VALUE = 1;
    public static final int PUSHF_VALUE = 2;
    public static final int POP_VALUE = 3;
    public static final int LOAD_VALUE = 4;
    public static final int STORE_VALUE = 5;
    public static final int SET_VALUE = 6;
    public static final int GET_VALUE = 7;
    public static final int GET_TRANS_VALUE = 8;
    public static final int SET_STATIC_VALUE = 9;
    public static final int GET_STATIC_VALUE = 10;
    public static final int FINDTYPE_VALUE = 11;
    public static final int FINDTYPE_S_VALUE = 12;
    public static final int NEW_VALUE = 13;
    public static final int NEW_S_VALUE = 14;
    public static final int DELETE_VALUE = 15;
    public static final int DUP_VALUE = 16;
    public static final int DUP_X1_VALUE = 17;
    public static final int SWAP_VALUE = 18;
    public static final int SWAP_X1_VALUE = 19;
    public static final int IF_VALUE = 20;
    public static final int IFN_VALUE = 21;
    public static final int GOTO_VALUE = 22;
    public static final int ITERATE_VALUE = 23;
    public static final int ENDITERATE_VALUE = 24;
    public static final int INVOKE_VALUE = 25;
    public static final int INVOKE_SUPER_VALUE = 26;
    public static final int INVOKE_STATIC_VALUE = 27;
    public static final int ALLINST_VALUE = 28;
    public static final int ALLINST_IN_VALUE = 29;
    public static final int ISNULL_VALUE = 30;
    public static final int GETENVTYPE_VALUE = 31;
    public static final int NOT_VALUE = 32;
    public static final int AND_VALUE = 33;
    public static final int OR_VALUE = 34;
    public static final int XOR_VALUE = 35;
    public static final int IMPLIES_VALUE = 36;
    public static final int IFTE_VALUE = 37;
    public static final int RETURN_VALUE = 38;
    public static final int GETCB_VALUE = 39;
    public static final int INVOKE_ALL_CBS_VALUE = 40;
    public static final int INVOKE_CB_VALUE = 41;
    public static final int INVOKE_CB_S_VALUE = 42;
    public static final int MATCH_VALUE = 43;
    public static final int MATCH_S_VALUE = 44;
    public static final int ADD_VALUE = 45;
    public static final int REMOVE_VALUE = 46;
    public static final int INSERT_VALUE = 47;
    private static final Opcode[] VALUES_ARRAY;
    public static final List<Opcode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Opcode[]{PUSH, PUSHT, PUSHF, POP, LOAD, STORE, SET, GET, GET_TRANS, SET_STATIC, GET_STATIC, FINDTYPE, FINDTYPE_S, NEW, NEW_S, DELETE, DUP, DUP_X1, SWAP, SWAP_X1, IF, IFN, GOTO, ITERATE, ENDITERATE, INVOKE, INVOKE_SUPER, INVOKE_STATIC, ALLINST, ALLINST_IN, ISNULL, GETENVTYPE, NOT, AND, OR, XOR, IMPLIES, IFTE, RETURN, GETCB, INVOKE_ALL_CBS, INVOKE_CB, INVOKE_CB_S, MATCH, MATCH_S, ADD, REMOVE, INSERT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Opcode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Opcode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Opcode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Opcode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Opcode get(int value) {
        switch (value) {
            case 0: {
                return PUSH;
            }
            case 1: {
                return PUSHT;
            }
            case 2: {
                return PUSHF;
            }
            case 3: {
                return POP;
            }
            case 4: {
                return LOAD;
            }
            case 5: {
                return STORE;
            }
            case 6: {
                return SET;
            }
            case 7: {
                return GET;
            }
            case 8: {
                return GET_TRANS;
            }
            case 9: {
                return SET_STATIC;
            }
            case 10: {
                return GET_STATIC;
            }
            case 11: {
                return FINDTYPE;
            }
            case 12: {
                return FINDTYPE_S;
            }
            case 13: {
                return NEW;
            }
            case 14: {
                return NEW_S;
            }
            case 15: {
                return DELETE;
            }
            case 16: {
                return DUP;
            }
            case 17: {
                return DUP_X1;
            }
            case 18: {
                return SWAP;
            }
            case 19: {
                return SWAP_X1;
            }
            case 20: {
                return IF;
            }
            case 21: {
                return IFN;
            }
            case 22: {
                return GOTO;
            }
            case 23: {
                return ITERATE;
            }
            case 24: {
                return ENDITERATE;
            }
            case 25: {
                return INVOKE;
            }
            case 26: {
                return INVOKE_SUPER;
            }
            case 27: {
                return INVOKE_STATIC;
            }
            case 28: {
                return ALLINST;
            }
            case 29: {
                return ALLINST_IN;
            }
            case 30: {
                return ISNULL;
            }
            case 31: {
                return GETENVTYPE;
            }
            case 32: {
                return NOT;
            }
            case 33: {
                return AND;
            }
            case 34: {
                return OR;
            }
            case 35: {
                return XOR;
            }
            case 36: {
                return IMPLIES;
            }
            case 37: {
                return IFTE;
            }
            case 38: {
                return RETURN;
            }
            case 39: {
                return GETCB;
            }
            case 40: {
                return INVOKE_ALL_CBS;
            }
            case 41: {
                return INVOKE_CB;
            }
            case 42: {
                return INVOKE_CB_S;
            }
            case 43: {
                return MATCH;
            }
            case 44: {
                return MATCH_S;
            }
            case 45: {
                return ADD;
            }
            case 46: {
                return REMOVE;
            }
            case 47: {
                return INSERT;
            }
        }
        return null;
    }

    private Opcode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

