/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.trace.tests;

import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.m2m.atl.emftvm.trace.SourceElement;
import org.eclipse.m2m.atl.emftvm.trace.SourceElementList;
import org.eclipse.m2m.atl.emftvm.trace.TraceFactory;
import org.eclipse.m2m.atl.emftvm.trace.TraceLink;
import org.eclipse.m2m.atl.emftvm.trace.TraceLinkSet;
import org.eclipse.m2m.atl.emftvm.trace.TracedRule;

public class TraceLinkSetTest
extends TestCase {
    protected TraceLinkSet fixture = null;

    public static void main(String[] args) {
        TestRunner.run(TraceLinkSetTest.class);
    }

    public TraceLinkSetTest(String name) {
        super(name);
    }

    protected void setFixture(TraceLinkSet fixture) {
        this.fixture = fixture;
    }

    protected TraceLinkSet getFixture() {
        return this.fixture;
    }

    protected void setUp() throws Exception {
        this.setFixture(TraceFactory.eINSTANCE.createTraceLinkSet());
    }

    protected void tearDown() throws Exception {
        this.setFixture(null);
    }

    public void testGetDefaultSourceElement__EObject() {
        EObject se1Object = EcoreFactory.eINSTANCE.createEObject();
        TraceLink link = TraceFactory.eINSTANCE.createTraceLink();
        SourceElement se1 = link.getSourceElement("se1", true);
        TraceLinkSetTest.assertEquals((String)"se1", (String)se1.getName());
        se1.setObject(se1Object);
        TracedRule tr = this.fixture.getLinksByRule("tr", true);
        TraceLinkSetTest.assertEquals((String)"tr", (String)tr.getRule());
        tr.getLinks().add((Object)link);
        this.fixture.getDefaultSourceElements().add((Object)se1);
        TraceLinkSetTest.assertEquals((Object)se1, (Object)this.fixture.getDefaultSourceElement(se1Object));
        SourceElement se2 = link.getSourceElement("se2", true);
        TraceLinkSetTest.assertEquals((String)"se2", (String)se2.getName());
        se2.setObject(se1Object);
        try {
            this.fixture.getDefaultSourceElements().add((Object)se2);
            TraceLinkSetTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetDefaultSourceElements__List() {
        EObject se1Object = EcoreFactory.eINSTANCE.createEObject();
        EObject se2Object = EcoreFactory.eINSTANCE.createEObject();
        TraceLink link = TraceFactory.eINSTANCE.createTraceLink();
        SourceElement se1 = link.getSourceElement("se1", true);
        TraceLinkSetTest.assertEquals((String)"se1", (String)se1.getName());
        se1.setObject(se1Object);
        SourceElement se2 = link.getSourceElement("se2", true);
        TraceLinkSetTest.assertEquals((String)"se2", (String)se2.getName());
        se2.setObject(se2Object);
        SourceElementList sel = TraceFactory.eINSTANCE.createSourceElementList();
        sel.getSourceElements().add((Object)se1);
        TraceLinkSetTest.assertTrue((boolean)sel.getSourceObjects().contains((Object)se1Object));
        sel.getSourceElements().add((Object)se2);
        TraceLinkSetTest.assertTrue((boolean)sel.getSourceObjects().contains((Object)se2Object));
        TracedRule tr = this.fixture.getLinksByRule("tr", true);
        TraceLinkSetTest.assertEquals((String)"tr", (String)tr.getRule());
        tr.getLinks().add((Object)link);
        this.fixture.getDefaultSourceElementLists().add((Object)sel);
        BasicEList sourceObjects = new BasicEList();
        sourceObjects.add((Object)se1Object);
        sourceObjects.add((Object)se2Object);
        TraceLinkSetTest.assertEquals((Object)sel, (Object)this.fixture.getDefaultSourceElements((List)sourceObjects));
        SourceElementList sel2 = TraceFactory.eINSTANCE.createSourceElementList();
        sel2.getSourceElements().add((Object)se1);
        TraceLinkSetTest.assertTrue((boolean)sel2.getSourceObjects().contains((Object)se1Object));
        sel2.getSourceElements().add((Object)se2);
        TraceLinkSetTest.assertTrue((boolean)sel2.getSourceObjects().contains((Object)se2Object));
        try {
            this.fixture.getDefaultSourceElementLists().add((Object)sel2);
            TraceLinkSetTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetLinksByRule__String_boolean() {
        TracedRule tr = this.fixture.getLinksByRule("tr", true);
        TraceLinkSetTest.assertEquals((String)"tr", (String)tr.getRule());
        TracedRule tr2 = this.fixture.getLinksByRule("tr2", false);
        TraceLinkSetTest.assertNull((Object)tr2);
    }

    public void testClear() {
        this.fixture.clear();
        TraceLinkSetTest.assertTrue((boolean)this.fixture.getDefaultSourceElements().isEmpty());
        TraceLinkSetTest.assertTrue((boolean)this.fixture.getRules().isEmpty());
    }
}

