/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.rest;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.TraceStateBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TestPropagator
implements TextMapPropagator {
    public static final String BAGGAGE_KEY = "TEST-BAGGAGE";
    public static final String TRACE_KEY = "TEST-SPAN";
    private static final List<String> FIELDS = Collections.unmodifiableList(Arrays.asList("TEST-BAGGAGE", "TEST-SPAN"));

    public Collection<String> fields() {
        return FIELDS;
    }

    public <C> Context extract(Context context, C carrier, TextMapGetter<C> getter) {
        String traceString;
        String baggageString = getter.get(carrier, BAGGAGE_KEY);
        if (baggageString != null && !baggageString.isEmpty()) {
            Baggage baggage = this.deserializeBaggage(baggageString);
            context = context.with((ImplicitContextKeyed)baggage);
        }
        if ((traceString = getter.get(carrier, TRACE_KEY)) != null && !traceString.isEmpty()) {
            Span span = this.deserializeSpan(traceString);
            context = context.with((ImplicitContextKeyed)span);
        }
        return context;
    }

    public <C> void inject(Context context, C carrier, TextMapSetter<C> setter) {
        Span span;
        Baggage baggage = Baggage.fromContextOrNull((Context)context);
        if (baggage != null && !baggage.isEmpty()) {
            setter.set(carrier, BAGGAGE_KEY, this.serializeBaggage(baggage));
        }
        if ((span = Span.fromContextOrNull((Context)context)) != null && span.getSpanContext().isValid()) {
            setter.set(carrier, TRACE_KEY, this.serializeSpan(span.getSpanContext()));
        }
    }

    private String serializeBaggage(Baggage baggage) {
        StringBuffer baggageString = new StringBuffer();
        boolean first = true;
        for (Map.Entry entry : baggage.asMap().entrySet()) {
            if (!first) {
                baggageString.append(';');
                first = false;
            }
            baggageString.append(this.encode((String)entry.getKey())).append(',').append(this.encode(((BaggageEntry)entry.getValue()).getValue())).append(',').append(this.encode(((BaggageEntry)entry.getValue()).getMetadata().getValue()));
        }
        return baggageString.toString();
    }

    private Baggage deserializeBaggage(String string) {
        BaggageBuilder builder = Baggage.empty().toBuilder();
        for (String entry : string.split(";")) {
            if (entry.isEmpty()) continue;
            String[] parts = entry.split(",", -1);
            builder.put(this.decode(parts[0]), this.decode(parts[1]), BaggageEntryMetadata.create((String)this.decode(parts[2])));
        }
        return builder.build();
    }

    private String serializeSpan(SpanContext span) {
        StringBuffer spanString = new StringBuffer();
        spanString.append(span.getTraceId()).append(';').append(span.getSpanId()).append(';').append(span.getTraceFlags().asHex()).append(';');
        boolean first = true;
        for (Map.Entry entry : span.getTraceState().asMap().entrySet()) {
            if (first) {
                spanString.append(',');
                first = false;
            }
            spanString.append(this.encode((String)entry.getKey())).append('=').append(this.encode((String)entry.getValue()));
        }
        return spanString.toString();
    }

    private Span deserializeSpan(String string) {
        String[] parts = string.split(";", -1);
        String traceId = this.decode(parts[0]);
        String spanId = this.decode(parts[1]);
        TraceFlags flags = TraceFlags.fromHex((CharSequence)this.decode(parts[2]), (int)0);
        TraceStateBuilder stateBuilder = TraceState.builder();
        for (String entry : parts[3].split(",")) {
            if (entry.isEmpty()) continue;
            String[] entryParts = entry.split("=");
            stateBuilder.put(this.decode(entryParts[0]), this.decode(entryParts[1]));
        }
        SpanContext spanContext = SpanContext.create((String)traceId, (String)spanId, (TraceFlags)flags, (TraceState)stateBuilder.build());
        return Span.wrap((SpanContext)spanContext);
    }

    private String encode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    private String decode(String s) {
        return URLDecoder.decode(s, StandardCharsets.UTF_8);
    }
}

