/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

class TestApplication
extends Arquillian {
    @ArquillianResource
    private URL url;

    TestApplication() {
    }

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.create(WebArchive.class);
    }

    @Test
    @RunAsClient
    public void rest() {
        String uri = this.url.toExternalForm() + "rest";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    @ApplicationScoped
    public static class HelloBean {
        public String hello() {
            return "hello";
        }
    }

    @Path(value="/rest")
    public static class TestEndpoint {
        @Inject
        private HelloBean helloBean;

        @GET
        public String hello() {
            return this.helloBean.hello();
        }
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }
}

