/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.metrics.tck.application.http;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.semconv.ErrorAttributes;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.telemetry.metrics.tck.application.BasicHttpClient;
import org.eclipse.microprofile.telemetry.metrics.tck.application.TestLibraries;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporter;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HttpHistogramTest
extends Arquillian {
    @Inject
    OpenTelemetry openTelemetry;
    @ArquillianResource
    private URL url;
    @Inject
    private InMemoryMetricExporter metricExporter;
    private BasicHttpClient basicClient;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemoryMetricExporter.class, InMemoryMetricExporterProvider.class, BasicHttpClient.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableMetricExporterProvider.class, new Class[]{InMemoryMetricExporterProvider.class})).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.metrics.exporter=in-memory\notel.logs.exporter=none\notel.traces.exporter=none\notel.metric.export.interval=3000"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.metricExporter != null) {
            this.metricExporter.reset();
            this.basicClient = new BasicHttpClient(this.url);
        }
    }

    @Test
    void collectsHttpRouteFromEndAttributes() {
        this.basicClient.get("/span");
        this.basicClient.get("/fail");
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail((String)"The test thread was interrupted");
        }
        List<MetricData> items = this.metricExporter.getFinishedMetricItems();
        HashMap successfulHTTPMethod = new HashMap();
        successfulHTTPMethod.put(HttpAttributes.HTTP_REQUEST_METHOD, "GET");
        successfulHTTPMethod.put(UrlAttributes.URL_SCHEME, "http");
        successfulHTTPMethod.put(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, 200L);
        successfulHTTPMethod.put(HttpAttributes.HTTP_ROUTE, this.url.getPath() + "span");
        HashMap failingHTTPMethod = new HashMap();
        failingHTTPMethod.put(HttpAttributes.HTTP_REQUEST_METHOD, "GET");
        failingHTTPMethod.put(UrlAttributes.URL_SCHEME, "http");
        failingHTTPMethod.put(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, 500L);
        failingHTTPMethod.put(HttpAttributes.HTTP_ROUTE, this.url.getPath() + "fail");
        failingHTTPMethod.put(ErrorAttributes.ERROR_TYPE, "500");
        this.testMetricItem(successfulHTTPMethod, items);
        this.testMetricItem(failingHTTPMethod, items);
    }

    private void testMetricItem(Map<AttributeKey<?>, Object> keyAndExpectedValue, List<MetricData> items) {
        Assert.assertTrue((boolean)items.stream().flatMap(md -> md.getHistogramData().getPoints().stream()).anyMatch(point -> keyAndExpectedValue.entrySet().stream().allMatch(entry -> {
            Object attribute = point.getAttributes().get((AttributeKey)entry.getKey());
            return attribute != null && attribute.equals(entry.getValue());
        })), (String)("failed to find a metric with all items in this attribute map: " + this.dumpTestedMap(keyAndExpectedValue) + "\n Dumping all attributes: " + this.dumpMetricItems(items)));
    }

    private String dumpTestedMap(Map<AttributeKey<?>, Object> keyAndExpectedValue) {
        return keyAndExpectedValue.entrySet().stream().map(entry -> ((AttributeKey)entry.getKey()).toString() + "=" + entry.getValue()).collect(Collectors.joining(", "));
    }

    private String dumpMetricItems(List<MetricData> items) {
        return items.stream().flatMap(md -> md.getHistogramData().getPoints().stream()).map(point -> point.getAttributes().toString()).collect(Collectors.joining(", "));
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }

    @Path(value="/")
    public static class SpanResource {
        @GET
        @Path(value="/span")
        public Response span() {
            return Response.ok().build();
        }

        @GET
        @Path(value="/fail")
        public Response fail() {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

