/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.metrics.tck.jvm;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import jakarta.inject.Inject;
import java.io.IOException;
import org.eclipse.microprofile.telemetry.metrics.tck.jvm.MetricsReader;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JvmClassesTest
extends Arquillian {
    @Inject
    OpenTelemetry openTelemetry;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{MetricsReader.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    void testClassLoadedMetrics() throws IOException {
        Assert.assertTrue((boolean)MetricsReader.checkMessage("jvm.class.loaded", "Number of classes loaded since JVM start.", "{class}", MetricDataType.LONG_SUM.toString()));
    }

    @Test
    void testClassUnloadedMetrics() throws IOException {
        Assert.assertTrue((boolean)MetricsReader.checkMessage("jvm.class.unloaded", "Number of classes unloaded since JVM start.", "{class}", MetricDataType.LONG_SUM.toString()));
    }

    @Test
    void testClassCountMetrics() throws IOException {
        Assert.assertTrue((boolean)MetricsReader.checkMessage("jvm.class.count", "Number of classes currently loaded.", "{class}", MetricDataType.LONG_SUM.toString()));
    }
}

