/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.asynctests;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.WiremockArquillianTest;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApiAsync;
import org.eclipse.microprofile.rest.client.tck.interfaces.StringResponseClientAsync;
import org.eclipse.microprofile.rest.client.tck.providers.TLAddPathClientRequestFilter;
import org.eclipse.microprofile.rest.client.tck.providers.TLAsyncInvocationInterceptor;
import org.eclipse.microprofile.rest.client.tck.providers.TLAsyncInvocationInterceptorFactory;
import org.eclipse.microprofile.rest.client.tck.providers.TLClientResponseFilter;
import org.eclipse.microprofile.rest.client.tck.providers.ThreadedClientResponseFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AsyncMethodTest
extends WiremockArquillianTest {
    @Deployment
    public static WebArchive createDeployment() {
        String simpleName = AsyncMethodTest.class.getSimpleName();
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addClasses(new Class[]{WiremockArquillianTest.class, SimpleGetApiAsync.class, StringResponseClientAsync.class, ThreadedClientResponseFilter.class, TLAsyncInvocationInterceptorFactory.class, TLAsyncInvocationInterceptor.class, TLAddPathClientRequestFilter.class, TLClientResponseFilter.class});
    }

    public void testInterfaceMethodWithCompletionStageResponseReturnIsInvokedAsynchronously() throws Exception {
        String expectedBody = "Hello, Async Client!";
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withBody("Hello, Async Client!")));
        String mainThreadId = "" + Thread.currentThread().getId();
        SimpleGetApiAsync api = (SimpleGetApiAsync)((RestClientBuilder)RestClientBuilder.newBuilder().baseUrl(AsyncMethodTest.getServerURL()).register(ThreadedClientResponseFilter.class)).build(SimpleGetApiAsync.class);
        CompletionStage<Response> future = api.executeGet();
        Response response = future.toCompletableFuture().get();
        String body = (String)response.readEntity(String.class);
        response.close();
        String responseThreadId = response.getHeaderString("Response-Thread-ID");
        Assert.assertNotNull((Object)responseThreadId);
        Assert.assertNotEquals((Object)responseThreadId, (Object)mainThreadId);
        Assert.assertEquals((String)body, (String)"Hello, Async Client!");
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/")));
    }

    @Test
    public void testInterfaceMethodWithCompletionStageObjectReturnIsInvokedAsynchronously() throws Exception {
        String expectedBody = "Hello, Future Async Client!!";
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/string")).willReturn(WireMock.aResponse().withBody("Hello, Future Async Client!!")));
        String mainThreadId = "" + Thread.currentThread().getId();
        ThreadedClientResponseFilter filter = new ThreadedClientResponseFilter();
        StringResponseClientAsync client = (StringResponseClientAsync)((RestClientBuilder)RestClientBuilder.newBuilder().baseUrl(AsyncMethodTest.getServerURL()).register((Object)filter)).build(StringResponseClientAsync.class);
        CompletionStage<String> future = client.get();
        String body = future.toCompletableFuture().get();
        String responseThreadId = filter.getResponseThreadId();
        Assert.assertNotNull((Object)responseThreadId);
        Assert.assertNotEquals((Object)responseThreadId, (Object)mainThreadId);
        Assert.assertEquals((String)body, (String)"Hello, Future Async Client!!");
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/string")));
    }

    @Test
    public void testExecutorService() throws Exception {
        String expectedBody = "Hello, InvocationCallback Async Client!!!";
        String expectedThreadName = "MPRestClientTCKThread";
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/execSvc")).willReturn(WireMock.aResponse().withBody("Hello, InvocationCallback Async Client!!!")));
        long mainThreadId = Thread.currentThread().getId();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "MPRestClientTCKThread");
            }
        };
        ExecutorService testExecutorService = Executors.newSingleThreadExecutor(threadFactory);
        SimpleGetApiAsync client = (SimpleGetApiAsync)((RestClientBuilder)RestClientBuilder.newBuilder().baseUrl(AsyncMethodTest.getServerURL()).register(ThreadedClientResponseFilter.class)).executorService(testExecutorService).build(SimpleGetApiAsync.class);
        CompletionStage<Response> future = client.executeGetExecSvc();
        Response r = future.toCompletableFuture().get();
        Assert.assertEquals((String)((String)r.readEntity(String.class)), (String)"Hello, InvocationCallback Async Client!!!");
        Assert.assertNotEquals((Object)r.getHeaderString("Response-Thread-ID"), (Object)mainThreadId);
        Assert.assertEquals((String)r.getHeaderString("Response-Thread-Name"), (String)"MPRestClientTCKThread");
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/execSvc")));
    }

    @Test
    public void testAsyncInvocationInterceptorProvider() throws Exception {
        String expectedBody = "Hello, Async Intercepted Client!!";
        Integer threadLocalInt = 808;
        long mainThreadId = Thread.currentThread().getId();
        WireMock.stubFor((MappingBuilder)WireMock.get((UrlPattern)WireMock.urlEqualTo((String)("/" + threadLocalInt))).willReturn(WireMock.aResponse().withBody("Hello, Async Intercepted Client!!")));
        final AtomicBoolean isThreadLocalCleared = new AtomicBoolean(true);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable r) {
                return new Thread(new Runnable(){

                    @Override
                    public void run() {
                        isThreadLocalCleared.set(TLAsyncInvocationInterceptorFactory.getTlInt() == 0);
                        r.run();
                    }
                });
            }
        };
        ExecutorService testExecutorService = Executors.newSingleThreadExecutor(threadFactory);
        TLAsyncInvocationInterceptorFactory aiiFactory = new TLAsyncInvocationInterceptorFactory(threadLocalInt);
        TLClientResponseFilter responseFilter = new TLClientResponseFilter();
        SimpleGetApiAsync api = (SimpleGetApiAsync)((RestClientBuilder)((RestClientBuilder)((RestClientBuilder)RestClientBuilder.newBuilder().baseUrl(AsyncMethodTest.getServerURL()).register(TLAddPathClientRequestFilter.class)).register((Object)aiiFactory)).register((Object)responseFilter)).executorService(testExecutorService).build(SimpleGetApiAsync.class);
        CompletionStage<Response> future = api.executeGet();
        Response response = future.toCompletableFuture().get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String sentUri = response.getHeaderString("Sent-URI");
        Assert.assertTrue((boolean)sentUri.endsWith("/" + threadLocalInt));
        Assert.assertEquals((long)TLAsyncInvocationInterceptorFactory.getTlInt().intValue(), (long)808L);
        Assert.assertEquals((long)responseFilter.getThreadLocalIntDuringResponse(), (long)threadLocalInt.intValue());
        String body = (String)response.readEntity(String.class);
        response.close();
        Future<?> f = testExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                System.out.println("Reusing single thread pool thread");
            }
        });
        f.get(30L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)isThreadLocalCleared.get());
        Assert.assertEquals((String)body, (String)"Hello, Async Intercepted Client!!");
        Map<String, Object> data = aiiFactory.getData();
        Assert.assertEquals((Object)data.get("preThreadId"), (Object)mainThreadId);
        Assert.assertNotEquals((Object)data.get("postThreadId"), (Object)mainThreadId);
        Assert.assertEquals((Object)data.get("removeThreadId"), (Object)data.get("postThreadId"));
        Assert.assertEquals((Object)data.get("AsyncThreadLocalPre"), (Object)808);
        Assert.assertEquals((Object)data.get("AsyncThreadLocalPost"), (Object)0);
        WireMock.verify((int)1, (RequestPatternBuilder)WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)("/" + threadLocalInt))));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullExecutorServiceThrowsIllegalArgumentException() {
        RestClientBuilder.newBuilder().executorService(null);
        Assert.fail((String)"Passing a null ExecutorService should result in an IllegalArgumentException");
    }
}

