/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.sse;

import java.util.function.Consumer;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.microprofile.rest.client.tck.sse.MyEventSource;
import org.eclipse.microprofile.rest.client.tck.sse.MyEventSourceServlet;
import org.testng.log4testng.Logger;

public class HttpSseServer
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(HttpSseServer.class);
    private Server server;

    public HttpSseServer start(int port, Consumer<MyEventSource> consumer) {
        this.server = new Server(port);
        ServletHandler handler = new ServletHandler();
        ServletHolder holder = new ServletHolder((Servlet)new MyEventSourceServlet(consumer));
        handler.addServletWithMapping(holder, "/*");
        this.server.setHandler((Handler)handler);
        try {
            this.server.start();
            LOG.debug((Object)"started");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start SSE HTTP server", e);
        }
        return this;
    }

    public void stop() {
        try {
            this.server.stop();
            LOG.debug((Object)"stopped");
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to stop", (Throwable)e);
            throw new RuntimeException("Failed to stop SSE HTTP server", e);
        }
    }

    @Override
    public void close() throws Exception {
        LOG.debug((Object)"close");
        this.stop();
    }
}

