/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.eclipse.microprofile.rest.client.tck.providers.InjectedSimpleFeature;
import org.eclipse.microprofile.rest.client.tck.providers.MultiTypedProvider;
import org.eclipse.microprofile.rest.client.tck.providers.TestClientRequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdditionalRegistrationTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(AdditionalRegistrationTest.class.getSimpleName() + ".war"))).addPackage(InjectedSimpleFeature.class.getPackage());
    }

    @Test
    public void shouldRegisterInstance() {
        TestClientRequestFilter instance = new TestClientRequestFilter();
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register((Object)instance);
        Configuration configuration = builder.getConfiguration();
        Assert.assertTrue((boolean)configuration.isRegistered(TestClientRequestFilter.class), (String)(TestClientRequestFilter.class + " should be registered"));
        Assert.assertTrue((boolean)configuration.isRegistered((Object)instance), (String)(TestClientRequestFilter.class + " should be registered"));
    }

    @Test
    public void shouldRegisterInstanceWithPriority() {
        Integer priority = 1000;
        TestClientRequestFilter instance = new TestClientRequestFilter();
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register((Object)instance, priority.intValue());
        Configuration configuration = builder.getConfiguration();
        Assert.assertTrue((boolean)configuration.isRegistered(TestClientRequestFilter.class), (String)(TestClientRequestFilter.class + " should be registered"));
        Assert.assertTrue((boolean)configuration.isRegistered((Object)instance), (String)(TestClientRequestFilter.class + " should be registered"));
        Map contracts = configuration.getContracts(TestClientRequestFilter.class);
        Assert.assertEquals((int)contracts.size(), (int)1, (String)("There should be a registered contract for " + TestClientRequestFilter.class));
        Assert.assertEquals(contracts.get(ClientRequestFilter.class), (Object)priority, (String)("The priority for " + TestClientRequestFilter.class + " should be 1000"));
    }

    @Test
    public void shouldRegisterAMultiTypedProviderInstance() {
        MultiTypedProvider provider = new MultiTypedProvider();
        Class[] providerTypes = new Class[]{ClientRequestFilter.class, ClientResponseFilter.class, MessageBodyReader.class, MessageBodyWriter.class, ReaderInterceptor.class, WriterInterceptor.class, ResponseExceptionMapper.class, ParamConverterProvider.class};
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register((Object)provider, providerTypes);
        Configuration configuration = builder.getConfiguration();
        Assert.assertTrue((boolean)configuration.isRegistered(MultiTypedProvider.class), (String)(MultiTypedProvider.class + " should be registered"));
        Assert.assertTrue((boolean)configuration.isRegistered((Object)provider), (String)(MultiTypedProvider.class + " should be registered"));
        Assert.assertEquals((int)configuration.getContracts(MultiTypedProvider.class).size(), (int)providerTypes.length, (String)("There should be " + providerTypes.length + " provider types registered"));
    }

    @Test
    public void shouldRegisterAMultiTypedProviderInstanceWithPriorities() {
        MultiTypedProvider provider = new MultiTypedProvider();
        HashMap<Class, Integer> priorities = new HashMap<Class, Integer>();
        priorities.put(ClientRequestFilter.class, 500);
        priorities.put(ClientResponseFilter.class, 501);
        priorities.put(MessageBodyReader.class, 502);
        priorities.put(MessageBodyWriter.class, 503);
        priorities.put(ReaderInterceptor.class, 504);
        priorities.put(WriterInterceptor.class, 505);
        priorities.put(ResponseExceptionMapper.class, 506);
        priorities.put(ParamConverterProvider.class, 507);
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register((Object)provider, priorities);
        Configuration configuration = builder.getConfiguration();
        Assert.assertTrue((boolean)configuration.isRegistered(MultiTypedProvider.class), (String)(MultiTypedProvider.class + " should be registered"));
        Assert.assertTrue((boolean)configuration.isRegistered((Object)provider), (String)(MultiTypedProvider.class + " should be registered"));
        Map contracts = configuration.getContracts(MultiTypedProvider.class);
        Assert.assertEquals((int)contracts.size(), (int)priorities.size(), (String)("There should be " + priorities.size() + " provider types registered"));
        for (Map.Entry priority : priorities.entrySet()) {
            Integer contractPriority = (Integer)contracts.get(priority.getKey());
            Assert.assertEquals((Object)contractPriority, priority.getValue(), (String)("The priority for " + priority.getKey() + " should be " + priority.getValue()));
        }
    }

    @Test
    public void shouldRegisterProvidersWithPriority() {
        Integer priority = 1000;
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register(TestClientRequestFilter.class, priority.intValue());
        Configuration configuration = builder.getConfiguration();
        Assert.assertTrue((boolean)configuration.isRegistered(TestClientRequestFilter.class), (String)(TestClientRequestFilter.class + " should be registered"));
        Map contracts = configuration.getContracts(TestClientRequestFilter.class);
        Assert.assertEquals((int)contracts.size(), (int)1, (String)("There should be a registered contract for " + TestClientRequestFilter.class));
        Assert.assertEquals(contracts.get(ClientRequestFilter.class), (Object)priority, (String)("The priority for " + TestClientRequestFilter.class + " should be 1000"));
    }

    @Test
    public void shouldRegisterAMultiTypedProviderClass() {
        Class[] providerTypes = new Class[]{ClientRequestFilter.class, ClientResponseFilter.class, MessageBodyReader.class, MessageBodyWriter.class, ReaderInterceptor.class, WriterInterceptor.class, ResponseExceptionMapper.class, ParamConverterProvider.class};
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register(MultiTypedProvider.class, providerTypes);
        Configuration configuration = builder.getConfiguration();
        Assert.assertTrue((boolean)configuration.isRegistered(MultiTypedProvider.class), (String)(MultiTypedProvider.class + " should be registered"));
        Assert.assertEquals((int)configuration.getContracts(MultiTypedProvider.class).size(), (int)providerTypes.length, (String)("There should be " + providerTypes.length + " provider types registered"));
    }

    @Test
    public void shouldRegisterAMultiTypedProviderClassWithPriorities() {
        HashMap<Class, Integer> priorities = new HashMap<Class, Integer>();
        priorities.put(ClientRequestFilter.class, 500);
        priorities.put(ClientResponseFilter.class, 501);
        priorities.put(MessageBodyReader.class, 502);
        priorities.put(MessageBodyWriter.class, 503);
        priorities.put(ReaderInterceptor.class, 504);
        priorities.put(WriterInterceptor.class, 505);
        priorities.put(ResponseExceptionMapper.class, 506);
        priorities.put(ParamConverterProvider.class, 507);
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register(MultiTypedProvider.class, priorities);
        Configuration configuration = builder.getConfiguration();
        Assert.assertTrue((boolean)configuration.isRegistered(MultiTypedProvider.class), (String)(MultiTypedProvider.class + " should be registered"));
        Map contracts = configuration.getContracts(MultiTypedProvider.class);
        Assert.assertEquals((int)contracts.size(), (int)priorities.size(), (String)("There should be " + priorities.size() + " provider types registered"));
        for (Map.Entry priority : priorities.entrySet()) {
            Integer contractPriority = (Integer)contracts.get(priority.getKey());
            Assert.assertEquals((Object)contractPriority, priority.getValue(), (String)("The priority for " + priority.getKey() + " should be " + priority.getValue()));
        }
    }

    @Test
    public void testPropertiesRegistered() {
        String key = "key";
        Object value = new Object();
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().property(key, value);
        Configuration configuration = builder.getConfiguration();
        Assert.assertTrue((boolean)configuration.getPropertyNames().contains(key), (String)("The key " + key + " should be a property"));
        Assert.assertEquals((Object)configuration.getProperty(key), (Object)value, (String)("The value of " + key + " should be " + value));
    }
}

