/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck;

import jakarta.inject.Inject;
import java.util.ServiceLoader;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.tck.ArchiveExtender;
import org.eclipse.microprofile.reactive.messaging.tck.SimpleIncomingBean;
import org.eclipse.microprofile.reactive.messaging.tck.StringSource;
import org.eclipse.microprofile.reactive.messaging.tck.ValueCollector;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SimpleIncomingTest {
    @Inject
    private SimpleIncomingBean simple;

    @Deployment
    public static Archive<JavaArchive> deployment() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{SimpleIncomingBean.class, ValueCollector.class, StringSource.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void testReceptionWithValues() {
        Awaitility.await().until(() -> this.simple.getValues().size() == StringSource.VALUES.size());
        Assertions.assertThat(this.simple.getValues()).containsExactlyElementsOf(StringSource.VALUES);
    }
}

