/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.metrics;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;

@ApplicationScoped
public class MetricsTestBean {
    public static final String CONNECTOR_IN = "channel-connector-in";
    public static final String CONNECTOR_PROCESS = "channel-connector-process";
    public static final String CONNECTOR_OUT = "channel-connector-out";
    public static final String CHANNEL_APP_A = "channel-app-a";
    public static final String CHANNEL_APP_B = "channel-app-b";
    private AtomicInteger inAppMessagesReceived = new AtomicInteger(0);

    @Incoming(value="channel-connector-in")
    @Outgoing(value="channel-connector-process")
    public String simpleMapping(String a) {
        return a + "-test";
    }

    @Incoming(value="channel-connector-process")
    @Outgoing(value="channel-connector-out")
    @Acknowledgment(value=Acknowledgment.Strategy.PRE_PROCESSING)
    public PublisherBuilder<Message<String>> split(Message<String> a) {
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = 1; i <= 2; ++i) {
            messages.add(Message.of((Object)((String)a.getPayload() + "-" + i)));
        }
        return ReactiveStreams.fromIterable(messages);
    }

    @Outgoing(value="channel-app-a")
    public PublisherBuilder<String> produce() {
        return ReactiveStreams.of((Object[])new String[]{"test-a", "test-b", "test-c"});
    }

    @Incoming(value="channel-app-a")
    @Outgoing(value="channel-app-b")
    public PublisherBuilder<String> split(String input) {
        ArrayList<String> messages = new ArrayList<String>();
        for (int i = 1; i <= 2; ++i) {
            messages.add(input + "-" + i);
        }
        return ReactiveStreams.fromIterable(messages);
    }

    @Incoming(value="channel-app-b")
    public void receive(String input) {
        this.inAppMessagesReceived.incrementAndGet();
    }

    public int getInAppMessagesReceived() {
        return this.inAppMessagesReceived.get();
    }
}

