/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.channel.overflow;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@ApplicationScoped
public class BeanUsingBufferOverflowWithoutBufferSizeStrategy {
    @Inject
    @Channel(value="hello")
    @OnOverflow(value=OnOverflow.Strategy.BUFFER)
    private Emitter<String> emitter;
    private final List<String> accepted = new CopyOnWriteArrayList<String>();
    private final List<String> rejected = new CopyOnWriteArrayList<String>();
    private volatile Throwable downstreamFailure;

    public Throwable failure() {
        return this.downstreamFailure;
    }

    public List<String> accepted() {
        return this.accepted;
    }

    public List<String> rejected() {
        return this.rejected;
    }

    public void tryEmitThree() {
        for (int i = 0; i < 3; ++i) {
            this.tryEmit(Integer.toString(i));
        }
    }

    public void tryEmitThousand() {
        for (int i = 0; i < 1000; ++i) {
            this.tryEmit(Integer.toString(i));
        }
    }

    private void tryEmit(String item) {
        try {
            this.emitter.send((Object)item);
            this.accepted.add(item);
        }
        catch (IllegalStateException e) {
            this.rejected.add(item);
        }
    }

    @Incoming(value="hello")
    public Subscriber<String> consume() {
        return new Subscriber<String>(){

            public void onSubscribe(Subscription s) {
            }

            public void onNext(String t) {
            }

            public void onError(Throwable t) {
                BeanUsingBufferOverflowWithoutBufferSizeStrategy.this.downstreamFailure = t;
            }

            public void onComplete() {
            }
        };
    }
}

