/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.acknowledgement;

import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.tck.ArchiveExtender;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.messaging.tck.acknowledgement.EmitterBean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

public class EmitterOfMessageAcknowledgementTest
extends TckBase {
    @Inject
    private EmitterBean bean;
    @Inject
    private MessageConsumer processor;

    @Deployment
    public static Archive<JavaArchive> deployment() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{EmitterBean.class, MessageConsumer.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void testThatEmitterReceiveAcksAfterSuccessfulProcessingOfPayload() {
        this.processor.disableFailureMode();
        Emitter<String> emitter = this.bean.getEmitter();
        CompletableFuture<Object> completed = CompletableFuture.completedFuture(null);
        AtomicInteger acks = new AtomicInteger();
        AtomicInteger nacks = new AtomicInteger();
        emitter.send(Message.of((Object)"a", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        emitter.send(Message.of((Object)"b", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        emitter.send(Message.of((Object)"c", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        emitter.send(Message.of((Object)"d", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        emitter.send(Message.of((Object)"e", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        Awaitility.await().until(() -> acks.get() == 5);
        Assertions.assertThat((AtomicInteger)nacks).hasValue(0);
    }

    @Test
    public void testThatEmitterReceiveNacksAfterFailingProcessingOfPayload() {
        Emitter<String> emitter = this.bean.getEmitter();
        this.processor.enableFailureMode();
        CompletableFuture<Object> completed = CompletableFuture.completedFuture(null);
        AtomicInteger acks = new AtomicInteger();
        AtomicInteger nacks = new AtomicInteger();
        emitter.send(Message.of((Object)"a", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        emitter.send(Message.of((Object)"b", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        emitter.send(Message.of((Object)"c", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        emitter.send(Message.of((Object)"d", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        emitter.send(Message.of((Object)"e", () -> {
            acks.incrementAndGet();
            return completed;
        }, r -> {
            nacks.incrementAndGet();
            return completed;
        }));
        Awaitility.await().until(() -> acks.get() == 3);
        Awaitility.await().until(() -> nacks.get() == 2);
    }

    @ApplicationScoped
    public static class MessageConsumer {
        private boolean failureModeEnabled = false;

        public void enableFailureMode() {
            this.failureModeEnabled = true;
        }

        public void disableFailureMode() {
            this.failureModeEnabled = false;
        }

        @Incoming(value="data")
        public CompletionStage<Void> process(String s) {
            if (this.failureModeEnabled) {
                if (s.equalsIgnoreCase("b")) {
                    throw new IllegalArgumentException("b");
                }
                if (s.equalsIgnoreCase("c")) {
                    CompletableFuture<Void> cf = new CompletableFuture<Void>();
                    cf.completeExceptionally(new IllegalArgumentException("c"));
                    return cf;
                }
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

