/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.opentracing.tck.OpenTracingBaseTests;
import org.eclipse.microprofile.opentracing.tck.OpenTracingClientBaseTests;
import org.eclipse.microprofile.opentracing.tck.application.WildcardClassService;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpan;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpanTree;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class OpenTracingHTTPPathNameTests
extends OpenTracingClientBaseTests {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)OpenTracingBaseTests.createDeployment().addAsServiceProvider(ConfigSource.class, new Class[]{TestConfiguration.class});
    }

    @Override
    protected String getOperationName(String spanKind, String httpMethod, Class<?> clazz, Method method) {
        if (spanKind.equals("server")) {
            Path methodPath;
            String methodPathStr;
            StringBuilder operationName = new StringBuilder(httpMethod.toUpperCase() + ":");
            Path classPath = clazz.getAnnotation(Path.class);
            if (classPath == null) {
                throw new IllegalArgumentException("Supplied clazz is not JAX-RS resource");
            }
            if (!classPath.value().startsWith("/")) {
                operationName.append("/");
            }
            operationName.append(classPath.value());
            if (!classPath.value().endsWith("/")) {
                operationName.append("/");
            }
            if ((methodPathStr = (methodPath = method.getAnnotation(Path.class)).value()).startsWith("/")) {
                methodPathStr = methodPathStr.replaceFirst("/", "");
            }
            operationName.append(methodPathStr);
            return operationName.toString();
        }
        return super.getOperationName(spanKind, httpMethod, clazz, method);
    }

    @Test
    @RunAsClient
    private void testWildcard() {
        Response response = this.executeRemoteWebServiceRaw("wildcard/10/foo", "getFoo/ten", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", WildcardClassService.class, this.getEndpointMethod(WildcardClassService.class, "/getFoo/{name}")), this.getExpectedSpanTags("server", "GET", "wildcard/10/foo", "getFoo/ten", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode[0]));
        this.assertEqualTrees(spans, expectedTree);
    }

    @Test
    @RunAsClient
    private void testTwoSameParams() {
        Response response = this.executeRemoteWebServiceRaw("wildcard/1/foo", "twoIds/1/1", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(new TestSpanTree.TreeNode<TestSpan>(new TestSpan(this.getOperationName("server", "GET", WildcardClassService.class, this.getEndpointMethod(WildcardClassService.class, "/twoIds/{aaa: \\d+}/{bbb: \\w+}")), this.getExpectedSpanTags("server", "GET", "wildcard/1/foo", "twoIds/1/1", null, Response.Status.OK.getStatusCode(), "jaxrs"), Collections.emptyList()), new TestSpanTree.TreeNode[0]));
        this.assertEqualTrees(spans, expectedTree);
    }

    public static class TestConfiguration
    implements ConfigSource {
        private Map<String, String> propMap = new HashMap<String, String>();

        public TestConfiguration() {
            this.propMap.put("mp.opentracing.server.operation-name-provider", "http-path");
        }

        public Map<String, String> getProperties() {
            return this.propMap;
        }

        public String getValue(String s) {
            return this.propMap.get(s);
        }

        public String getName() {
            return this.getClass().getName();
        }

        public Set<String> getPropertyNames() {
            return this.getProperties().keySet();
        }
    }
}

