/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck.application;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class ApplicationUtils {
    public static final String TEST_WEB_SERVICES_CONTEXT_ROOT = "rest";

    private ApplicationUtils() {
    }

    public static String getWebServiceURL(URL baseUri, String service, String relativePath) {
        try {
            return new URL(baseUri, "rest/" + service + "/" + relativePath).toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getQueryString(Map<String, Object> queryParameters) {
        if (queryParameters.isEmpty()) {
            return "";
        }
        String result = "?";
        String prefix = null;
        for (Map.Entry<String, Object> parmEntry : queryParameters.entrySet()) {
            String parmName = parmEntry.getKey();
            Object parmValue = parmEntry.getValue();
            if (prefix != null) {
                result = result + prefix;
            } else {
                prefix = "&";
            }
            result = result + ApplicationUtils.urlEncode(parmName);
            if (parmValue == null) continue;
            result = result + "=";
            result = result + ApplicationUtils.urlEncode(parmValue.toString());
        }
        return result;
    }

    public static String urlEncode(String text) {
        try {
            return URLEncoder.encode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static RuntimeException createExampleRuntimeException() {
        return new RuntimeException("Example runtime exception");
    }
}

