/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck;

import io.opentracing.tag.Tags;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.Path;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.opentracing.tck.OpenTracingClientBaseTests;
import org.eclipse.microprofile.opentracing.tck.application.ApplicationUtils;
import org.eclipse.microprofile.opentracing.tck.application.TestServerWebServices;
import org.eclipse.microprofile.opentracing.tck.tracer.ConsumableTree;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpan;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpanTree;
import org.eclipse.microprofile.opentracing.tck.tracer.TestTracer;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeMethod;

public abstract class OpenTracingBaseTests
extends Arquillian {
    public static final String JAXRS_COMPONENT = "jaxrs";
    private final AtomicInteger idCounter = new AtomicInteger(0);
    @ArquillianResource
    protected URL deploymentURL;

    public static WebArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"opentracing.war")).addPackages(true, new Package[]{OpenTracingClientBaseTests.class.getPackage()})).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return war;
    }

    @BeforeMethod
    protected void beforeEachTest() {
        OpenTracingBaseTests.debug("beforeEachTest calling clearTracer");
        this.clearTracer();
        OpenTracingBaseTests.debug("beforeEachTest clearTracer completed");
    }

    protected String getWebServiceURL(String service, String relativePath) {
        return this.getWebServiceURL(service, relativePath, null);
    }

    protected String getWebServiceURL(String service, String relativePath, Map<String, Object> queryParameters) {
        String url = ApplicationUtils.getWebServiceURL(this.deploymentURL, service, relativePath);
        if (queryParameters != null) {
            url = url + ApplicationUtils.getQueryString(queryParameters);
        }
        return url;
    }

    protected Response executeRemoteWebServiceRaw(String service, String relativePath, Response.Status expectedStatus) {
        return this.executeRemoteWebServiceRaw(service, relativePath, null, expectedStatus);
    }

    protected Response executeRemoteWebServiceRaw(String service, String relativePath, Map<String, Object> queryParameters, Response.Status expectedStatus) {
        Client client = ClientBuilder.newClient();
        String url = this.getWebServiceURL(service, relativePath, queryParameters);
        OpenTracingBaseTests.debug("Executing " + url);
        WebTarget target = client.target(url);
        Response response = target.request().get();
        if (response.getStatus() != expectedStatus.getStatusCode()) {
            String unexpectedResponse = (String)response.readEntity(String.class);
            Assert.fail((String)("Expected HTTP response code " + expectedStatus.getStatusCode() + " but received " + response.getStatus() + "; Response: " + unexpectedResponse));
        }
        return response;
    }

    protected TestSpanTree executeRemoteWebServiceTracerTree() {
        TestSpanTree testSpanTree = ((TestTracer)this.executeRemoteWebServiceRaw("tracer", "getTracer", Response.Status.OK).readEntity(TestTracer.class)).spanTree();
        OpenTracingBaseTests.debug("Tracer returned " + testSpanTree);
        return testSpanTree;
    }

    private void clearTracer() {
        Client client = ClientBuilder.newClient();
        String url = this.getWebServiceURL("tracer", "clearTracer");
        Response delete = client.target(url).request().delete();
        delete.close();
    }

    protected void assertEqualTrees(ConsumableTree<TestSpan> returnedTree, ConsumableTree<TestSpan> expectedTree) {
        returnedTree.visitTree(span -> span.getTags().keySet().removeIf(key -> !key.equals(Tags.SPAN_KIND.getKey()) && !key.equals(Tags.HTTP_METHOD.getKey()) && !key.equals(Tags.HTTP_URL.getKey()) && !key.equals(Tags.HTTP_STATUS.getKey()) && !key.equals(Tags.COMPONENT.getKey()) && !key.equals("localSpanKey")));
        returnedTree.visitTree(span -> span.getLogEntries().removeIf(logEntry -> true));
        Assert.assertEquals(returnedTree, expectedTree);
    }

    protected void assertEqualErrorTrees(ConsumableTree<TestSpan> returnedTree, ConsumableTree<TestSpan> expectedTree) {
        returnedTree.visitTree(span -> span.getTags().keySet().removeIf(key -> !key.equals(Tags.SPAN_KIND.getKey()) && !key.equals(Tags.HTTP_METHOD.getKey()) && !key.equals(Tags.HTTP_URL.getKey()) && !key.equals(Tags.HTTP_STATUS.getKey()) && !key.equals(Tags.COMPONENT.getKey()) && !key.equals("localSpanKey") && !key.equals(Tags.ERROR.getKey())));
        returnedTree.visitTree(span -> {
            if (!"server".equals(span.getTags().get(Tags.SPAN_KIND.getKey()))) {
                span.getLogEntries().forEach(stringMap -> stringMap.keySet().removeIf(key -> !key.equals("event") && !key.equals("error.object")));
            }
        });
        Assert.assertEquals(returnedTree, expectedTree);
    }

    static void debug(String message) {
        Reporter.log((String)message);
    }

    protected int getRandomNumber() {
        return this.idCounter.incrementAndGet();
    }

    protected Method getEndpointMethod(Class<?> clazz, String mapping) {
        for (Method method : clazz.getMethods()) {
            Path methodPath = method.getAnnotation(Path.class);
            if (methodPath == null || !mapping.equals(methodPath.value())) continue;
            return method;
        }
        return null;
    }

    protected String getOperationName(String spanKind, String httpMethod, Class<?> clazz, Method method) {
        if (spanKind.equals("server")) {
            return String.format("%s:%s.%s", httpMethod, clazz.getName(), method.getName());
        }
        if (spanKind.equals("client")) {
            return httpMethod;
        }
        throw new RuntimeException("Span kind " + spanKind + " not implemented");
    }

    protected Map<String, Object> getExpectedSpanTags(String spanKind, String httpMethod, String service, String relativePath, Map<String, Object> queryParameters, int httpStatus, String component) {
        HashMap<String, Object> tags = new HashMap<String, Object>();
        tags.put(Tags.SPAN_KIND.getKey(), spanKind);
        tags.put(Tags.HTTP_METHOD.getKey(), httpMethod);
        tags.put(Tags.HTTP_URL.getKey(), this.getWebServiceURL(service, relativePath, queryParameters));
        tags.put(Tags.HTTP_STATUS.getKey(), new BigDecimal(httpStatus));
        tags.put(Tags.COMPONENT.getKey(), component);
        return tags;
    }

    protected Map<String, Object> getExpectedSpanTagsForError(String service, String spanKind) {
        Map<String, Object> expectedTags = this.getExpectedSpanTags(spanKind, "GET", "testServices", service, null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), JAXRS_COMPONENT);
        return expectedTags;
    }

    protected void testNestedSpans(String path, int nestDepth, int nestBreadth, int uniqueId, boolean failNest, boolean async) {
        this.executeNested(path, uniqueId, nestDepth, nestBreadth, failNest, async);
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        TestSpanTree expectedTree = new TestSpanTree(this.createExpectedNestTree(path, uniqueId, nestBreadth, failNest, async));
        this.assertEqualTrees(spans, expectedTree);
    }

    protected void testMultithreadedNestedSpans(final String path, int numberOfCalls, final int nestDepth, final int nestBreadth, final boolean failNest, final boolean async) throws InterruptedException, ExecutionException {
        int processors = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(processors);
        ArrayList futures = new ArrayList(numberOfCalls);
        final ConcurrentHashMap.KeySetView uniqueIds = ConcurrentHashMap.newKeySet();
        for (int i = 0; i < numberOfCalls; ++i) {
            futures.add(executorService.submit(new Runnable(){

                @Override
                public void run() {
                    int uniqueId = OpenTracingBaseTests.this.getRandomNumber();
                    uniqueIds.add(uniqueId);
                    OpenTracingBaseTests.this.executeNested(path, uniqueId, nestDepth, nestBreadth, failNest, async);
                }
            }));
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.awaitTermination(1L, TimeUnit.SECONDS);
        executorService.shutdown();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        List<TestSpanTree.TreeNode<TestSpan>> list = spans.getRootSpans();
        Assert.assertEquals((int)list.size(), (int)numberOfCalls);
        for (TestSpanTree.TreeNode<TestSpan> rootSpan : list) {
            int uniqueId;
            boolean removeResult;
            String url = (String)rootSpan.getData().getTags().get(Tags.HTTP_URL.getKey());
            int i = url.indexOf("data");
            Assert.assertNotEquals((Object)i, (Object)-1);
            String uniqueIdStr = url.substring(i + "data".length() + 1);
            i = uniqueIdStr.indexOf(38);
            if (i != -1) {
                uniqueIdStr = uniqueIdStr.substring(0, i);
            }
            if (!(removeResult = uniqueIds.remove(uniqueId = Integer.parseInt(uniqueIdStr)))) {
                OpenTracingBaseTests.debug("Unique ID " + uniqueId + " not found in request list. Span: " + rootSpan);
            }
            Assert.assertTrue((boolean)removeResult);
            TestSpanTree.TreeNode<TestSpan> expectedTree = this.createExpectedNestTree(path, uniqueId, nestBreadth, failNest, async);
            this.assertEqualTrees(rootSpan, expectedTree);
        }
    }

    protected void executeNested(String path, int uniqueId, int nestDepth, int nestBreadth, boolean failNest, boolean async) {
        Map<String, Object> queryParameters = this.getNestedQueryParameters(uniqueId, nestDepth, nestBreadth, failNest, async);
        Response response = this.executeRemoteWebServiceRaw("testServices", path, queryParameters, Response.Status.OK);
        response.close();
    }

    protected Map<String, Object> getNestedQueryParameters(int uniqueId, int nestDepth, int nestBreadth, boolean failNest, boolean async) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("data", uniqueId);
        queryParameters.put("nestDepth", nestDepth);
        queryParameters.put("nestBreadth", nestBreadth);
        queryParameters.put("failNest", failNest);
        queryParameters.put("async", async);
        return queryParameters;
    }

    private TestSpanTree.TreeNode<TestSpan> createExpectedNestTree(String path, int uniqueId, int nestBreadth, boolean failNest, boolean async) {
        TestSpanTree.TreeNode[] children = new TestSpanTree.TreeNode[nestBreadth];
        for (int i = 0; i < nestBreadth; ++i) {
            children[i] = new TestSpanTree.TreeNode<TestSpan>(this.getExpectedNestedServerSpan(path, "client", uniqueId, 0, 1, false, failNest, async), new TestSpanTree.TreeNode<TestSpan>(this.getExpectedNestedServerSpan(path, "server", uniqueId, 0, 1, false, failNest, async), new TestSpanTree.TreeNode[0]));
        }
        return new TestSpanTree.TreeNode<TestSpan>(this.getExpectedNestedServerSpan(path, "server", uniqueId, 1, nestBreadth, failNest, false, async), children);
    }

    protected TestSpan getExpectedNestedServerSpan(String path, String spanKind, int uniqueId, int nestDepth, int nestBreadth, boolean failNest, boolean isFailed, boolean async) {
        Map<String, Object> expectedTags;
        String operationName;
        if (isFailed) {
            operationName = this.getOperationName(spanKind, "GET", TestServerWebServices.class, this.getEndpointMethod(TestServerWebServices.class, "error"));
            expectedTags = this.getExpectedSpanTagsForError("error", spanKind);
        } else {
            HashMap<String, Object> queryParameters = new HashMap<String, Object>();
            queryParameters.put("data", uniqueId);
            queryParameters.put("nestDepth", nestDepth);
            queryParameters.put("nestBreadth", nestBreadth);
            queryParameters.put("failNest", failNest);
            queryParameters.put("async", async);
            operationName = this.getOperationName(spanKind, "GET", TestServerWebServices.class, this.getEndpointMethod(TestServerWebServices.class, path));
            expectedTags = this.getExpectedSpanTags(spanKind, "GET", "testServices", path, queryParameters, Response.Status.OK.getStatusCode(), JAXRS_COMPONENT);
        }
        return new TestSpan(operationName, expectedTags, Collections.emptyList());
    }
}

