/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.restassured.builder.ResponseBuilder;
import io.restassured.filter.FilterContext;
import io.restassured.filter.OrderedFilter;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class YamlToJsonFilter
implements OrderedFilter {
    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        if (ContentType.JSON.matches(requestSpec.getContentType())) {
            return ctx.next(requestSpec, responseSpec);
        }
        try {
            Response response = ctx.next(requestSpec, responseSpec);
            ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
            Object obj = yamlReader.readValue(response.getBody().asString(), Object.class);
            ObjectMapper jsonWriter = new ObjectMapper();
            String json = jsonWriter.writeValueAsString(obj);
            ResponseBuilder builder = new ResponseBuilder();
            builder.clone(response);
            builder.setBody(json);
            builder.setContentType(ContentType.JSON);
            return builder.build();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert the request: " + ExceptionUtils.getMessage((Throwable)e), e);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

