/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import io.restassured.RestAssured;
import io.restassured.builder.ResponseBuilder;
import io.restassured.http.Header;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.microprofile.metrics.test.HistogramTimerConfigBean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HistogramTimerConfigurationTest {
    private static final String TEXT_PLAIN = "text/plain";
    private static final String PROM_APP_LABEL_REGEX = "mp_app=\"[-/A-Za-z0-9]+\"";
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 8080;
    @Inject
    private HistogramTimerConfigBean histogramTimerConfigBean;

    private static String filterOutAppLabelPromMetrics(String responseBody) {
        return responseBody.replaceAll(PROM_APP_LABEL_REGEX, "").replaceAll("\\{,", "{").replaceAll(",\\}", "}");
    }

    @BeforeClass
    public static void setup() throws MalformedURLException {
        String serverUrl = System.getProperty("test.url");
        String protocol = DEFAULT_PROTOCOL;
        String host = DEFAULT_HOST;
        int port = 8080;
        if (serverUrl != null) {
            URL url = new URL(serverUrl);
            protocol = url.getProtocol();
            host = url.getHost();
            port = url.getPort() == -1 ? 8080 : url.getPort();
        }
        RestAssured.baseURI = protocol + "://" + host;
        RestAssured.port = port;
        String userName = System.getProperty("test.user");
        String password = System.getProperty("test.pwd");
        if (userName != null && password != null) {
            RestAssured.authentication = RestAssured.basic((String)userName, (String)password);
            RestAssured.useRelaxedHTTPSValidation();
        }
    }

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive jar = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(HistogramTimerConfigBean.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml")).addAsManifestResource("META-INF/microprofile-config.properties", "microprofile-config.properties");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    @RunAsClient
    @InSequence(value=1)
    public void testAnnotatedTimerCustomPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP annotatedTimerCustomPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerCustomPercentile_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.3\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.6\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP annotatedTimerCustomPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerCustomPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=2)
    public void testAnnotatedTimerNoPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP annotatedTimerNoPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerNoPercentile_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerNoPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerNoPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP annotatedTimerNoPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerNoPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerNoPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerNoPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=3)
    public void testAnnotatedTimerCustomBucketsDefaultPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP annotatedTimerCustomBucketsDefaultPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerCustomBucketsDefaultPercentile_seconds histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.1\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.2\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"2.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"60.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"3600.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP annotatedTimerNoPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerNoPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerNoPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=4)
    public void testAnnotatedTimerCustomBucketsCustomPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP annotatedTimerCustomBucketsCustomPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerCustomBucketsCustomPercentile_seconds histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.12\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"3.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.4\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.7\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP annotatedTimerCustomBucketsCustomPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerCustomBucketsCustomPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=5)
    public void testAnnotatedTimerCustomBucketsNoPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP annotatedTimerCustomBucketsNoPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerCustomBucketsNoPercentile_seconds histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsNoPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsNoPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsNoPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.789\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsNoPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"2.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsNoPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP annotatedTimerCustomBucketsNoPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE annotatedTimerCustomBucketsNoPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"annotatedTimerCustomBucketsNoPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"annotatedTimerCustomBucketsNoPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile")), new Matcher[0]);
    }

    @Test
    @InSequence(value=6)
    public void testSetupApplicationMetrics() {
        this.histogramTimerConfigBean.programmaticTimers();
        this.histogramTimerConfigBean.programmaticHistograms();
        this.histogramTimerConfigBean.programmaticBadConfigs();
        this.histogramTimerConfigBean.precedence();
    }

    @Test
    @RunAsClient
    @InSequence(value=7)
    public void testTimerCustomPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP timerCustomPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerCustomPercentile_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.3\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.6\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP timerCustomPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerCustomPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=8)
    public void testTimerNoPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP timerNoPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerNoPercentile_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerNoPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerNoPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP timerNoPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerNoPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerNoPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerNoPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=9)
    public void testTimerCustomBucketsDefaultPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP timerCustomBucketsDefaultPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerCustomBucketsDefaultPercentile_seconds histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.1\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.2\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"2.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"60.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"3600.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsDefaultPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP timerNoPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerNoPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerNoPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=10)
    public void testTimerCustomBucketsCustomPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP timerCustomBucketsCustomPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerCustomBucketsCustomPercentile_seconds histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.12\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"3.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.4\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.7\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP timerCustomBucketsCustomPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerCustomBucketsCustomPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomBucketsCustomPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=11)
    public void testTimerCustomBucketsNoPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP timerCustomBucketsNoPercentile_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerCustomBucketsNoPercentile_seconds histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsNoPercentile_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsNoPercentile_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsNoPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.789\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsNoPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"2.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsNoPercentile_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP timerCustomBucketsNoPercentile_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerCustomBucketsNoPercentile_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerCustomBucketsNoPercentile_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerCustomBucketsNoPercentile_seconds{mp_scope=\"application\",tier=\"integration\",quantile")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=12)
    public void testHistogramCustomPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP histogramCustomPercentile"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramCustomPercentile summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.3\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.6\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomPercentile_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomPercentile_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP histogramCustomPercentile_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramCustomPercentile_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomPercentile_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=13)
    public void testHistogramNoPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP histogramNoPercentile"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramNoPercentile summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramNoPercentile_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramNoPercentile_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP histogramNoPercentile_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramNoPercentile_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramNoPercentile_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramNoPercentile{mp_scope=\"application\",tier=\"integration\",quantile")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=14)
    public void testHistogramCustomBucketsDefaultPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP histogramCustomBucketsDefaultPercentile"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramCustomBucketsDefaultPercentile histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"100.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"200.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"345.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsDefaultPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP histogramNoPercentile_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramNoPercentile_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramNoPercentile_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=15)
    public void testHistogramCustomBucketsCustomPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP histogramCustomBucketsCustomPercentile"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramCustomBucketsCustomPercentile histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"3.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"120.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.4\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.7\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP histogramCustomBucketsCustomPercentile_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramCustomBucketsCustomPercentile_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomBucketsCustomPercentile{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=16)
    public void testHistogramCustomBucketsNoPercentile() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP histogramCustomBucketsNoPercentile"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramCustomBucketsNoPercentile histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsNoPercentile_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsNoPercentile_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsNoPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"67.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsNoPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"789.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsNoPercentile_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP histogramCustomBucketsNoPercentile_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramCustomBucketsNoPercentile_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramCustomBucketsNoPercentile_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramCustomBucketsNoPercentile{mp_scope=\"application\",tier=\"integration\",quantile")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=17)
    public void testTimerBadPercentiles() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP timerBadPercentiles_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerBadPercentiles_seconds summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadPercentiles_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadPercentiles_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadPercentiles_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.1\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP timerBadPercentiles_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerBadPercentiles_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadPercentiles_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerBadPercentiles_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerBadPercentiles_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerBadPercentiles_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerBadPercentiles_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerBadPercentiles_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"timerBadPercentiles_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=18)
    public void testHistogramBadPercentiles() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP histogramBadPercentiles"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramBadPercentiles summary"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadPercentiles_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadPercentiles_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadPercentiles{mp_scope=\"application\",tier=\"integration\",quantile=\"0.1\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadPercentiles{mp_scope=\"application\",tier=\"integration\",quantile=\"0.3\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadPercentiles{mp_scope=\"application\",tier=\"integration\",quantile=\"0.4\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP histogramBadPercentiles_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramBadPercentiles_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadPercentiles_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramBadPercentiles{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramBadPercentiles{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramBadPercentiles{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramBadPercentiles{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramBadPercentiles{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}")), new Matcher[0])).body(CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"histogramBadPercentiles{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}")), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=19)
    public void testTimerBadBuckets() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP timerBadBuckets_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerBadBuckets_seconds histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.01\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.03\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP timerBadBuckets_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE timerBadBuckets_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"timerBadBuckets_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=20)
    public void testHistogramBadBuckets() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP histogramBadBuckets"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramBadBuckets histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets_bucket{mp_scope=\"application\",tier=\"integration\",le=\"10.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets_bucket{mp_scope=\"application\",tier=\"integration\",le=\"12.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets_bucket{mp_scope=\"application\",tier=\"integration\",le=\"90.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP histogramBadBuckets_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE histogramBadBuckets_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets{mp_scope=\"application\",tier=\"integration\",quantile=\"0.5\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets{mp_scope=\"application\",tier=\"integration\",quantile=\"0.75\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets{mp_scope=\"application\",tier=\"integration\",quantile=\"0.95\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets{mp_scope=\"application\",tier=\"integration\",quantile=\"0.98\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets{mp_scope=\"application\",tier=\"integration\",quantile=\"0.99\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"histogramBadBuckets{mp_scope=\"application\",tier=\"integration\",quantile=\"0.999\"}"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=21)
    public void testHistogramPrecedence() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP precedence_histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE precedence_histogram histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_histogram_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_histogram_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_histogram{mp_scope=\"application\",tier=\"integration\",quantile=\"0.8\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_histogram{mp_scope=\"application\",tier=\"integration\",quantile=\"0.9\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_histogram_bucket{mp_scope=\"application\",tier=\"integration\",le=\"23.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_histogram_bucket{mp_scope=\"application\",tier=\"integration\",le=\"45.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_histogram_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP precedence_histogram_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE precedence_histogram_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_histogram_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP precedence_override_histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE precedence_override_histogram histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_histogram_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_histogram_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_histogram{mp_scope=\"application\",tier=\"integration\",quantile=\"0.2\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_histogram_bucket{mp_scope=\"application\",tier=\"integration\",le=\"32.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_histogram_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP precedence_override_histogram_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE precedence_override_histogram_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_histogram_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0]);
    }

    @Test
    @RunAsClient
    @InSequence(value=22)
    public void testTimerPrecedence() {
        Header acceptHeader = new Header("Accept", TEXT_PLAIN);
        Response resp = (Response)RestAssured.given().header(acceptHeader).get("/metrics?scope=application", new Object[0]);
        ResponseBuilder responseBuilder = new ResponseBuilder();
        responseBuilder.clone(resp);
        responseBuilder.setBody(HistogramTimerConfigurationTest.filterOutAppLabelPromMetrics(resp.getBody().asString()));
        resp = responseBuilder.build();
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)resp.then()).statusCode(200)).body(CoreMatchers.containsString((String)"# HELP precedence_timer_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE precedence_timer_seconds histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_timer_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_timer_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_timer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.8\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_timer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.9\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_timer_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.023\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_timer_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"0.455\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_timer_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP precedence_timer_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE precedence_timer_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_timer_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP precedence_override_timer_seconds"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE precedence_override_timer_seconds histogram"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_timer_seconds_count{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_timer_seconds_sum{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_timer_seconds{mp_scope=\"application\",tier=\"integration\",quantile=\"0.3\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_timer_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"32.0\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_timer_seconds_bucket{mp_scope=\"application\",tier=\"integration\",le=\"+Inf\"}"), new Matcher[0])).body(CoreMatchers.containsString((String)"# HELP precedence_override_timer_seconds_max"), new Matcher[0])).body(CoreMatchers.containsString((String)"# TYPE precedence_override_timer_seconds_max gauge"), new Matcher[0])).body(CoreMatchers.containsString((String)"precedence_override_timer_seconds_max{mp_scope=\"application\",tier=\"integration\"}"), new Matcher[0]);
    }
}

