/*
 **********************************************************************
 * Copyright (c) 2017 Contributors to the Eclipse Foundation
 *               2010-2013 Coda Hale, Yammer.com
 *
 * See the NOTICES file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0
 **********************************************************************/
package org.eclipse.microprofile.metrics;

/**
 * A metric which calculates the distribution of a value.
 *
 * @see <a href="http://www.johndcook.com/standard_deviation.html">Accurately computing running variance</a>
 */
public interface Histogram extends Metric, Sampling, Counting {

    /**
     * Adds a recorded value.
     *
     * @param value
     *            the length of the value
     */
    void update(int value);

    /**
     * Adds a recorded value.
     *
     * @param value
     *            the length of the value
     */
    void update(long value);

    /**
     * Returns the number of values recorded.
     *
     * @return the number of values recorded
     */
    @Override
    long getCount();

    /**
     * Returns the sum of values recorded.
     *
     * @return the sum of values recorded
     */
    long getSum();

    @Override
    Snapshot getSnapshot();
}
