/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.tags;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.tck.tags.HistogramTagFieldBean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HistogramTagFieldBeanTest {
    private static final String HISTOGRAM_NAME = MetricRegistry.name(HistogramTagFieldBean.class, (String[])new String[]{"histogramName"});
    private static final Tag NUMBER_ONE_TAG = new Tag("number", "one");
    private static final Tag NUMBER_TWO_TAG = new Tag("number", "two");
    private static MetricID histogramOneMID;
    private static MetricID histogramTwoMID;
    @Inject
    private MetricRegistry registry;
    @Inject
    private HistogramTagFieldBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(HistogramTagFieldBean.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml");
    }

    @Before
    public void instantiateTest() {
        histogramOneMID = new MetricID(HISTOGRAM_NAME, new Tag[]{NUMBER_ONE_TAG});
        histogramTwoMID = new MetricID(HISTOGRAM_NAME, new Tag[]{NUMBER_TWO_TAG});
    }

    @Test
    @InSequence(value=1)
    public void histogramTagFieldRegistered() {
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistogram(histogramOneMID), (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)this.registry.getHistogram(histogramTwoMID), (Matcher)Matchers.notNullValue());
    }

    @Test
    @InSequence(value=2)
    public void updateHistogramTagField() {
        Histogram histogramOne = this.registry.getHistogram(histogramOneMID);
        Histogram histogramTwo = this.registry.getHistogram(histogramTwoMID);
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)histogramOne, (Matcher)Matchers.notNullValue());
        Assert.assertThat((String)"Histogram is not registered correctly", (Object)histogramTwo, (Matcher)Matchers.notNullValue());
        long value = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.updateOne(value);
        long valueTwo = Math.round(Math.random() * 9.223372036854776E18);
        this.bean.updateTwo(valueTwo);
        Assert.assertThat((String)"Histogram count is incorrect", (Object)histogramOne.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Histogram size is incorrect", (Object)histogramOne.getSnapshot().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Histogram max value is incorrect", (Object)histogramOne.getSnapshot().getMax(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)value)));
        Assert.assertThat((String)"Histogram count is incorrect", (Object)histogramTwo.getCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Histogram size is incorrect", (Object)histogramTwo.getSnapshot().size(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        Assert.assertThat((String)"Histogram max value is incorrect", (Object)histogramTwo.getSnapshot().getMax(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)valueTwo)));
    }
}

