/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.util;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.tck.util.SignatureAlgorithm;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TokenUtilsTest {
    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of alg")
    public void testFailAlgorithm() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.ALG);
        String token = TokenUtils.signClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.RS256, invalidFields);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Deprecated: Illustrate validation of alg")
    public void testFailAlgorithmDeprecated() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.ALG);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", invalidFields);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, description="Illustrate validation of a JWT")
    public void testValidToken() throws Exception {
        String token = TokenUtils.signClaims((String)"/Token1.json");
        this.validateToken(token);
    }

    @Test(groups={"utils"}, description="Illustrate validation of a JWT")
    public void testValidToken1024BitKeyLength() throws Exception {
        KeyPair pair = TokenUtils.generateKeyPair((int)1024);
        String token = TokenUtils.signClaims((PrivateKey)pair.getPrivate(), (String)"kid", (String)"/Token1.json", null, null);
        this.validateToken(token, pair.getPublic(), SignatureAlgorithm.RS256, null);
    }

    @Test(groups={"utils"}, description="Illustrate validation of a JWT")
    public void testValidTokenEC256() throws Exception {
        String token = TokenUtils.signClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.ES256);
        this.validateToken(token, SignatureAlgorithm.ES256, null);
    }

    @Test(groups={"utils"}, description="Illustrate validation of a JWT", expectedExceptions={InvalidJwtException.class})
    public void testSignedByRSKeyVerifiedByECKey() throws Exception {
        String token = TokenUtils.signClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.RS256);
        this.validateToken(token, SignatureAlgorithm.ES256, null);
    }

    @Test(groups={"utils"}, description="Illustrate validation of a JWT", expectedExceptions={InvalidJwtException.class})
    public void testSignedByECKeyVerifiedByRSKey() throws Exception {
        String token = TokenUtils.signClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.ES256);
        this.validateToken(token, SignatureAlgorithm.RS256, null);
    }

    @Test(groups={"utils"}, description="Deprecated: Illustrate validation of a JWT")
    public void testValidTokenDeprecated() throws Exception {
        String token = TokenUtils.generateTokenString((String)"/Token1.json");
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of issuer")
    public void testFailIssuer() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.ISSUER);
        String token = TokenUtils.signClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.RS256, invalidFields);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Deprecated: Illustrate validation of issuer")
    public void testFailIssuerDeprecated() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.ISSUER);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", invalidFields);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of signer")
    public void testFailSignature() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.SIGNER);
        String token = TokenUtils.signClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.RS256, invalidFields);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Deprecated: Illustrate validation of signer")
    public void testFailSignatureDeprecated() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.SIGNER);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", invalidFields);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of exp")
    public void testFailExpired() throws Exception {
        HashMap timeClaims = new HashMap();
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.EXP);
        String token = TokenUtils.signClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.RS256, invalidFields, timeClaims);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Deprecated: Illustrate validation of exp")
    public void testFailExpiredDeprecated() throws Exception {
        HashMap timeClaims = new HashMap();
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.EXP);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", invalidFields, timeClaims);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Illustrate validation of exp that has just expired")
    public void testFailJustExpired() throws Exception {
        HashMap<String, Long> timeClaims = new HashMap<String, Long>();
        long exp = TokenUtils.currentTimeInSecs() - 61;
        timeClaims.put(Claims.exp.name(), exp);
        String token = TokenUtils.signClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.RS256, null, timeClaims);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, expectedExceptions={InvalidJwtException.class}, description="Deprecated: Illustrate validation of exp that has just expired")
    public void testFailJustExpiredDeprecated() throws Exception {
        HashMap<String, Long> timeClaims = new HashMap<String, Long>();
        long exp = TokenUtils.currentTimeInSecs() - 61;
        timeClaims.put(Claims.exp.name(), exp);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", null, timeClaims);
        this.validateToken(token);
    }

    @Test(groups={"utils"}, description="Illustrate validation of exp that is in grace period")
    public void testExpGrace() throws Exception {
        HashMap<String, Long> timeClaims = new HashMap<String, Long>();
        long exp = TokenUtils.currentTimeInSecs() - 45;
        timeClaims.put(Claims.exp.name(), exp);
        String token = TokenUtils.signClaims((String)"/Token1.json", (SignatureAlgorithm)SignatureAlgorithm.RS256, null, timeClaims);
        this.validateToken(token, exp);
    }

    @Test(groups={"utils"}, description="Deprecated: Illustrate validation of exp that is in grace period")
    public void testExpGraceDeprecated() throws Exception {
        HashMap<String, Long> timeClaims = new HashMap<String, Long>();
        long exp = TokenUtils.currentTimeInSecs() - 45;
        timeClaims.put(Claims.exp.name(), exp);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", null, timeClaims);
        this.validateToken(token, SignatureAlgorithm.RS256, exp);
    }

    private void validateToken(String token) throws Exception {
        this.validateToken(token, SignatureAlgorithm.RS256, null);
    }

    private void validateToken(String token, Long expectedExpValue) throws Exception {
        this.validateToken(token, SignatureAlgorithm.RS256, expectedExpValue);
    }

    private void validateToken(String token, SignatureAlgorithm algorithm, Long expectedExpValue) throws Exception {
        PublicKey publicKey = algorithm == SignatureAlgorithm.RS256 ? TokenUtils.readPublicKey((String)"/publicKey.pem") : TokenUtils.readECPublicKey((String)"/ecPublicKey.pem");
        this.validateToken(token, publicKey, algorithm, expectedExpValue);
    }

    private void validateToken(String token, PublicKey publicKey, SignatureAlgorithm algorithm, Long expectedExpValue) throws Exception {
        int expGracePeriodSecs = 60;
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setRequireExpirationTime();
        builder.setSkipDefaultAudienceValidation();
        builder.setRequireIssuedAt();
        builder.setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{algorithm.getAlgorithm()}));
        builder.setExpectedIssuer(true, "https://server.example.com");
        builder.setVerificationKey((Key)publicKey);
        builder.setAllowedClockSkewInSeconds(expGracePeriodSecs);
        builder.setRelaxVerificationKeyValidation();
        JwtClaims claimsSet = builder.build().processToClaims(token);
        Assert.assertEquals((int)claimsSet.getClaimsMap().size(), (int)19);
        Assert.assertEquals((String)claimsSet.getIssuer(), (String)"https://server.example.com");
        Assert.assertEquals((String)claimsSet.getJwtId(), (String)"a-123");
        Assert.assertEquals((String)claimsSet.getSubject(), (String)"24400320");
        Assert.assertEquals((String)claimsSet.getClaimValueAsString("upn"), (String)"jdoe@example.com");
        Assert.assertEquals((String)claimsSet.getClaimValueAsString("preferred_username"), (String)"jdoe");
        Assert.assertEquals((int)claimsSet.getAudience().size(), (int)1);
        Assert.assertEquals((String)((String)claimsSet.getAudience().get(0)), (String)"s6BhdRkqt3");
        if (expectedExpValue != null) {
            Assert.assertEquals((long)claimsSet.getExpirationTime().getValue(), (long)expectedExpValue);
            Assert.assertEquals((long)claimsSet.getIssuedAt().getValue(), (long)(expectedExpValue - 5L));
            Assert.assertEquals((long)NumericDate.fromSeconds((long)((Long)claimsSet.getClaimValue("auth_time", Long.class))).getValue(), (long)(expectedExpValue - 5L));
        } else {
            Assert.assertNotNull((Object)claimsSet.getExpirationTime());
            long exp = claimsSet.getExpirationTime().getValue();
            Assert.assertEquals((long)claimsSet.getIssuedAt().getValue(), (long)(exp - 300L));
            Assert.assertEquals((long)NumericDate.fromSeconds((long)((Long)claimsSet.getClaimValue("auth_time", Long.class))).getValue(), (long)(exp - 300L));
        }
        Assert.assertEquals((String)claimsSet.getClaimValueAsString("customString"), (String)"customStringValue");
        Assert.assertEquals((Object)claimsSet.getClaimValue("customInteger", Long.class), (Object)123456789L);
        Assert.assertEquals((Object)claimsSet.getClaimValue("customDouble", Double.class), (Object)Math.PI);
        Assert.assertTrue((boolean)((Boolean)claimsSet.getClaimValue("customBoolean", Boolean.class)));
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("roles")).size(), (int)1);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("groups")).size(), (int)4);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("customStringArray")).size(), (int)3);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("customIntegerArray")).size(), (int)4);
        Assert.assertEquals((int)((List)claimsSet.getClaimsMap().get("customDoubleArray")).size(), (int)5);
        Assert.assertEquals((int)((Map)claimsSet.getClaimsMap().get("customObject")).size(), (int)3);
    }
}

