/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs.jwe;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.RolesEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.KeyManagementAlgorithm;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public class RolesAllowedSignEncryptRsaOaep256Test
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = RolesAllowedSignEncryptRsaOaep256Test.class.getResource("/META-INF/microprofile-config-verify-decrypt-rsa-oaep-256.properties");
        URL verifyKey = RolesAllowedSignEncryptRsaOaep256Test.class.getResource("/publicKey4k.pem");
        URL decryptKey = RolesAllowedSignEncryptRsaOaep256Test.class.getResource("/privateKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"RolesAllowedSignEncryptRsaOaep256Test.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_2_1.name()), "MPJWTTESTVERSION")).addAsResource(decryptKey, "/privateKey.pem")).addAsResource(verifyKey, "/publicKey4k.pem")).addClass(RolesEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with RSA-OAEP-256 encrypted token succeeds")
    public void callEchoRsaOaep256() throws Exception {
        Reporter.log((String)"callEcho with RSA-OAEP-256 encrypted token, expect HTTP_OK");
        RSAPrivateKey signingKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        RSAPublicKey encryptionKey = TokenUtils.readPublicKey((String)"/publicKey.pem");
        String token = TokenUtils.signEncryptClaims((PrivateKey)signingKey, null, (PublicKey)encryptionKey, (KeyManagementAlgorithm)KeyManagementAlgorithm.RSA_OAEP_256, null, (String)"/Token1.json", (boolean)true);
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"hello, user=jdoe@example.com");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with RSA-OAEP encrypted token fails with HTTP_UNAUTHORIZED")
    public void callEchoRsaOaep() throws Exception {
        Reporter.log((String)"callEcho with RSA-OAEP encrypted token, expect HTTP_UNAUTHORIZED");
        String token = TokenUtils.signEncryptClaims((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }
}

