/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.ProviderInjectionEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ProviderInjectionTest
extends Arquillian {
    private static String token;
    private static Long iatClaim;
    private static Long authTimeClaim;
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = ProviderInjectionTest.class.getResource("/META-INF/microprofile-config-publickey-location.properties");
        URL publicKey = ProviderInjectionTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ProviderInjectionTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(ProviderInjectionEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @BeforeClass(alwaysRun=true)
    public static void generateToken() throws Exception {
        HashMap timeClaims = new HashMap();
        token = TokenUtils.generateTokenString((String)"/Token1.json", null, timeClaims);
        iatClaim = (Long)timeClaims.get(Claims.iat.name());
        authTimeClaim = (Long)timeClaims.get(Claims.auth_time.name());
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected token issuer claim is as expected")
    public void verifyIssuerClaim() throws Exception {
        Reporter.log((String)"Begin verifyIssuerClaim");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuer";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iss.name(), new Object[]{"https://server.example.com"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected raw token claim is as expected")
    public void verifyInjectedRawToken() throws Exception {
        Reporter.log((String)"Begin verifyInjectedRawToken\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedRawToken";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.raw_token.name(), new Object[]{token}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected jti claim is as expected")
    public void verifyInjectedJTI() throws Exception {
        Reporter.log((String)"Begin verifyInjectedJTI\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedJTI";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.jti.name(), new Object[]{"a-123"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected aud claim is as expected")
    public void verifyInjectedAudience() throws Exception {
        Reporter.log((String)"Begin verifyInjectedAudience\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedAudience";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.aud.name(), new Object[]{"s6BhdRkqt3"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected iat claim is as expected")
    public void verifyInjectedIssuedAt() throws Exception {
        Reporter.log((String)"Begin verifyInjectedIssuedAt\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuedAt";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iat.name(), new Object[]{iatClaim}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected sub claim is as expected")
    public void verifyInjectedOptionalSubject() throws Exception {
        Reporter.log((String)"Begin verifyInjectedOptionalSubject\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedOptionalSubject";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.sub.name(), new Object[]{"24400320"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected raw token claim is as expected")
    public void verifyInjectedOptionalAuthTime() throws Exception {
        Reporter.log((String)"Begin verifyInjectedOptionalAuthTime\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedOptionalAuthTime";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected custom claim is missing as expected")
    public void verifyInjectedOptionalCustomMissing() throws Exception {
        Reporter.log((String)"Begin verifyInjectedOptionalCustomMissing\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedOptionalCustomMissing";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected customString claim is as expected")
    public void verifyInjectedCustomString() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomString\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomString";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{"customStringValue"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected customInteger claim is as expected")
    public void verifyInjectedCustomInteger() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomInteger\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomInteger";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{123456789}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected customDouble claim is as expected")
    public void verifyInjectedCustomDouble() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomDouble\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomDouble";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{Math.PI}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected token issuer claim is as expected")
    public void verifyIssuerClaim2() throws Exception {
        Reporter.log((String)"Begin verifyIssuerClaim");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuer";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iss.name(), new Object[]{"https://server.example.com"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected raw token claim is as expected")
    public void verifyInjectedRawToken2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedRawToken\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedRawToken";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.raw_token.name(), new Object[]{token}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected jti claim is as expected")
    public void verifyInjectedJTI2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedJTI\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedJTI";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.jti.name(), new Object[]{"a-123"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected aud claim is as expected")
    public void verifyInjectedAudience2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedAudience\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedAudience";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.aud.name(), new Object[]{"s6BhdRkqt3"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected iat claim is as expected")
    public void verifyInjectedIssuedAt2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedIssuedAt\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedIssuedAt";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iat.name(), new Object[]{iatClaim}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected sub claim is as expected")
    public void verifyInjectedOptionalSubject2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedOptionalSubject\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedOptionalSubject";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.sub.name(), new Object[]{"24400320"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected raw token claim is as expected")
    public void verifyInjectedOptionalAuthTime2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedOptionalAuthTime\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedOptionalAuthTime";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected customString claim is as expected")
    public void verifyInjectedCustomString2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomString\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomString";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{"customStringValue"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected customInteger claim is as expected")
    public void verifyInjectedCustomInteger2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomInteger\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomInteger";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{123456789}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"cdi-provider"}, description="Verify that the injected customDouble claim is as expected")
    public void verifyInjectedCustomDouble2() throws Exception {
        Reporter.log((String)"Begin verifyInjectedCustomDouble\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyInjectedCustomDouble";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("value", new Object[]{Math.PI}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

