/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.InvalidTokenTest;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.RolesEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CookieTokenTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment
    public static WebArchive createDeployment() {
        URL config = InvalidTokenTest.class.getResource("/META-INF/microprofile-config-cookie.properties");
        URL publicKey = InvalidTokenTest.class.getResource("/publicKey.pem");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"CookieTokenTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_2.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(TCKApplication.class)).addClass(RolesEndpoint.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with a valid JWT in a Cookie")
    public void validCookieJwt() throws Exception {
        String token = TokenUtils.generateTokenString((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).cookie("jwt", token).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"hello, user=jdoe@example.com");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with a different Cookie name from the one configured fais with HTTP_UNAUTHORIZED")
    public void wrongCookieName() throws Exception {
        String token = TokenUtils.generateTokenString((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).cookie("Bearer", token).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request without empty token in a Cookie fails with HTTP_UNAUTHORIZED")
    public void emptyCookie() {
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).cookie("jwt", "").get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with valid token in Header but endpoints expects Cookie fails with HTTP_UNAUTHORIZED")
    public void ignoreHeaderIfCookieSet() throws Exception {
        String token = TokenUtils.generateTokenString((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with expired token in a Cookie fails with HTTP_UNAUTHORIZED")
    public void expiredCookie() throws Exception {
        HashSet<TokenUtils.InvalidClaims> invalidFields = new HashSet<TokenUtils.InvalidClaims>();
        invalidFields.add(TokenUtils.InvalidClaims.EXP);
        String token = TokenUtils.generateTokenString((String)"/Token1.json", invalidFields);
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).cookie("jwt", token).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }
}

