/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.tck.config.SimpleTokenUtils;

@RequestScoped
@Path(value="/endp")
public class PublicKeyEndpoint {
    private static Logger log = Logger.getLogger("PublicKeyEndpoint");
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey")
    private Optional<String> key;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.location")
    private Optional<String> location;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.algorithm", defaultValue="RS256")
    private String algorithm;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.issuer")
    private Optional<String> issuer;
    @Inject
    @Claim(standard=Claims.iss)
    private ClaimValue<Optional<String>> iss;

    @PostConstruct
    private void init() {
        log.info(String.format("PublicKeyEndpoint.init, key: %s, location: %s, issuer: %s\n", this.key.orElse("Missing"), this.location.orElse("missing"), this.issuer.orElse("missing")));
    }

    @GET
    @Path(value="/verifyKeyAsPEM")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyKeyAsPEM() {
        String msg;
        boolean pass = false;
        String issValue = this.issuer.orElse("missing-issuer");
        if (issValue == null || issValue.length() == 0) {
            msg = Claims.iss.name() + " value is null or empty, FAIL";
        } else if (issValue.equals(this.iss)) {
            msg = Claims.iss.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iss.name(), issValue, this.iss);
        }
        try {
            PublicKey publicKey;
            if ("RS256".equals(this.algorithm)) {
                publicKey = SimpleTokenUtils.decodePublicKey(this.key.orElse("bad-key"));
                if (publicKey instanceof RSAPublicKey) {
                    msg = msg + " | key as PEM PASS";
                    pass = true;
                } else {
                    pass = false;
                }
            } else if ("ES256".equals(this.algorithm)) {
                publicKey = SimpleTokenUtils.decodeECPublicKey(this.key.orElse("bad-key"));
                if (publicKey instanceof ECPublicKey) {
                    msg = msg + " | key as PEM PASS";
                    pass = true;
                } else {
                    pass = false;
                }
            } else {
                pass = false;
            }
        }
        catch (Exception e) {
            msg = String.format("Failed to read key with exception: %s", e.getMessage());
            pass = false;
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyKeyLocationAsPEMResource")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyKeyLocationAsPEMResource() {
        String msg;
        boolean pass;
        block10: {
            pass = false;
            msg = null;
            if (this.location.isPresent()) {
                String locationValue = this.location.get();
                log.info(String.format("verifyKeyLocationAsPEMResource, location=%s", locationValue));
                try {
                    String pemValue = SimpleTokenUtils.readResource(locationValue);
                    log.info(String.format("verifyKeyLocationAsPEMResource, locationValue=%s", pemValue));
                    if ("RS256".equals(this.algorithm)) {
                        RSAPublicKey publicKey = SimpleTokenUtils.decodePublicKey(pemValue);
                        if (publicKey instanceof RSAPublicKey) {
                            log.info(String.format("verifyKeyLocationAsPEMResource, publicKey=%s", publicKey));
                            msg = "key location as resource to PEM PASS";
                            pass = true;
                        } else {
                            pass = false;
                        }
                        break block10;
                    }
                    if ("ES256".equals(this.algorithm)) {
                        ECPublicKey publicKey = SimpleTokenUtils.decodeECPublicKey(pemValue);
                        if (publicKey instanceof ECPublicKey) {
                            log.info(String.format("verifyKeyLocationAsPEMResource, publicKey=%s", publicKey));
                            msg = "key location as resource to PEM PASS";
                            pass = true;
                        } else {
                            pass = false;
                        }
                        break block10;
                    }
                    pass = false;
                }
                catch (Exception e) {
                    msg = String.format("Failed to read key with exception: %s", e.getMessage());
                }
            } else {
                msg = "no location property injected";
            }
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyKeyLocationAsPEMUrl")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyKeyLocationAsPEMUrl() {
        String msg;
        boolean pass = false;
        if (this.location.isPresent()) {
            String locationValue = this.location.get();
            log.info(String.format("verifyKeyLocationAsPEMUrl, location=%s", locationValue));
            try {
                URL locationURL = new URL(locationValue);
                StringWriter pemContents = new StringWriter();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(locationURL.openStream()));){
                    String line = reader.readLine();
                    while (line != null) {
                        pemContents.write(line);
                        pemContents.write(10);
                        line = reader.readLine();
                    }
                }
                log.info(String.format("verifyKeyLocationAsPEMUrl, locationValue=%s", pemContents.toString()));
                RSAPublicKey publicKey = SimpleTokenUtils.decodePublicKey(pemContents.toString());
                log.info(String.format("verifyKeyLocationAsPEMUrl, publicKey=%s", publicKey));
                msg = "key location as URL to PEM PASS";
                pass = true;
            }
            catch (MalformedURLException e) {
                msg = String.format("Failed to read location contents: %s", e.getMessage());
            }
            catch (IOException e) {
                msg = String.format("Failed to parse location as URL: %s", e.getMessage());
            }
            catch (Exception e) {
                msg = String.format("Failed to read key with exception: %s", e.getMessage());
            }
        } else {
            msg = "no location property injected";
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyKeyAsJWK")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyKeyAsJWK(@QueryParam(value="kid") String kid) {
        String msg;
        boolean pass = false;
        try {
            String jsonJwk = this.key.get();
            StringBuilder msgBuilder = new StringBuilder();
            JsonObject jwk = Json.createReader((Reader)new StringReader(jsonJwk)).readObject();
            pass = this.verifyJWK(jwk, kid, msgBuilder);
            msg = msgBuilder.toString();
        }
        catch (Exception e) {
            msg = String.format("Failed to read key with exception: %s", e.getMessage());
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyKeyAsBase64JWK")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyKeyAsBase64JWK(@QueryParam(value="kid") String kid) {
        String msg;
        boolean pass = false;
        try {
            String base64Jwk = this.key.get();
            log.info("verifyKeyAsBase64JWK, base64Jwk=" + base64Jwk);
            byte[] data = Base64.getDecoder().decode(base64Jwk);
            String jsonJwk = new String(data);
            log.info("verifyKeyAsBase64JWK, jsonJwk=" + jsonJwk);
            StringBuilder msgBuilder = new StringBuilder();
            JsonObject jwk = Json.createReader((Reader)new StringReader(jsonJwk)).readObject();
            pass = this.verifyJWK(jwk, kid, msgBuilder);
            msg = msgBuilder.toString();
        }
        catch (Exception e) {
            msg = String.format("Failed to read key with exception: %s", e.getMessage());
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyKeyAsJWKS")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyKeyAsJWKS(@QueryParam(value="kid") String kid) {
        String msg;
        boolean pass = false;
        try {
            String jsonJwk = this.key.get();
            StringBuilder msgBuilder = new StringBuilder();
            pass = this.verifyJWKS(jsonJwk, kid, msgBuilder);
            msg = msgBuilder.toString();
        }
        catch (Exception e) {
            msg = String.format("Failed to read key with exception: %s", e.getMessage());
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyKeyLocationAsJWKResource")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyKeyLocationAsJWKResource(@QueryParam(value="kid") String kid) {
        String msg;
        boolean pass;
        block6: {
            pass = false;
            if (this.location.isPresent()) {
                String locationValue = this.location.get();
                log.info(String.format("verifyKeyLocationAsJWKResource, location=%s", locationValue));
                try {
                    String jwkValue = SimpleTokenUtils.readResource(locationValue);
                    log.info(String.format("verifyKeyLocationAsJWKResource, locationValue=%s", jwkValue));
                    StringBuilder msgBuilder = new StringBuilder();
                    JsonObject jwk = Json.createReader((Reader)new StringReader(jwkValue)).readObject();
                    if (this.verifyJWK(jwk, kid, msgBuilder)) {
                        if ("RS256".equals(this.algorithm)) {
                            RSAPublicKey publicKey = SimpleTokenUtils.decodeJWKSPublicKey(jwkValue);
                            log.info(String.format("verifyKeyLocationAsJWKResource, publicKey=%s", publicKey));
                        }
                        msg = "key location as resource to JWK PASS";
                        pass = true;
                        break block6;
                    }
                    msg = msgBuilder.toString();
                }
                catch (Exception e) {
                    msg = String.format("Failed to read key with exception: %s", e.getMessage());
                }
            } else {
                msg = "no location property injected";
            }
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyKeyLocationAsJWKSResource")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyKeyLocationAsJWKSResource(@QueryParam(value="kid") String kid) {
        String msg;
        boolean pass;
        block5: {
            pass = false;
            if (this.location.isPresent()) {
                String locationValue = this.location.get();
                log.info(String.format("verifyKeyLocationAsJWKSResource, location=%s", locationValue));
                try {
                    String jwksValue = SimpleTokenUtils.readResource(locationValue);
                    log.info(String.format("verifyKeyLocationAsJWKSResource, locationValue=%s", jwksValue));
                    StringBuilder msgBuilder = new StringBuilder();
                    if (this.verifyJWKS(jwksValue, kid, msgBuilder)) {
                        RSAPublicKey publicKey = SimpleTokenUtils.decodeJWKSPublicKey(jwksValue);
                        log.info(String.format("verifyKeyLocationAsJWKSResource, publicKey=%s", publicKey));
                        msg = "key location as resource to JWKS PASS";
                        pass = true;
                        break block5;
                    }
                    msg = msgBuilder.toString();
                }
                catch (Exception e) {
                    msg = String.format("Failed to read key with exception: %s", e.getMessage());
                }
            } else {
                msg = "no location property injected";
            }
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyKeyLocationAsJWKSUrl")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyKeyLocationAsJWKSUrl(@QueryParam(value="kid") String kid) {
        String msg;
        boolean pass;
        block22: {
            pass = false;
            if (this.location.isPresent()) {
                String locationValue = this.location.get();
                log.info(String.format("verifyKeyLocationAsJWKSUrl, location=%s", locationValue));
                try {
                    URL locationURL = new URL(locationValue);
                    StringWriter jwksContents = new StringWriter();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(locationURL.openStream()));){
                        String line = reader.readLine();
                        while (line != null) {
                            jwksContents.write(line);
                            jwksContents.write(10);
                            line = reader.readLine();
                        }
                    }
                    log.info(String.format("verifyKeyLocationAsJWKSUrl, locationValue=%s", jwksContents.toString()));
                    StringBuilder msgBuilder = new StringBuilder();
                    if (this.verifyJWKS(jwksContents.toString(), kid, msgBuilder)) {
                        if ("RS256".equals(this.algorithm)) {
                            RSAPublicKey publicKey = SimpleTokenUtils.decodeJWKSPublicKey(jwksContents.toString());
                            log.info(String.format("verifyKeyLocationAsJWKSResource, publicKey=%s", publicKey));
                        }
                        msg = "key location as URL to JWKS PASS";
                        pass = true;
                        break block22;
                    }
                    msg = msgBuilder.toString();
                }
                catch (MalformedURLException e) {
                    msg = String.format("Failed to read location contents: %s", e.getMessage());
                }
                catch (IOException e) {
                    msg = String.format("Failed to parse location as URL: %s", e.getMessage());
                }
                catch (Exception e) {
                    msg = String.format("Failed to read key with exception: %s", e.getMessage());
                }
            } else {
                msg = "no location property injected";
            }
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyIssIsOk")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"Tester"})
    public JsonObject verifyIssIsOk() {
        String msg;
        boolean pass = false;
        if (!((Optional)this.iss.getValue()).isPresent()) {
            msg = String.format("MP-JWT missing iss claim", new Object[0]);
        } else if (this.issuer.isPresent()) {
            String claimIss = (String)((Optional)this.iss.getValue()).get();
            String configIss = this.issuer.get();
            if (configIss.equals(claimIss)) {
                msg = String.format("endpoint accessed with iss(%s) = config.iss(%s) as expected PASS", claimIss, configIss);
                pass = true;
            } else {
                msg = String.format("mp.jwt.verify.issuer(%s) != jwt.iss(%s)", configIss, claimIss);
            }
        } else {
            msg = "No mp.jwt.verify.issuer provided";
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/publicKey4k")
    @Produces(value={"text/plain"})
    @PermitAll
    public String publicKey4k() throws IOException {
        return SimpleTokenUtils.readResource("/publicKey4k.pem");
    }

    @GET
    @Path(value="/publicKey4kAsJWKS")
    @Produces(value={"application/json"})
    @PermitAll
    public JsonObject publicKey4kAsJWKS(@QueryParam(value="kid") String kid) throws Exception {
        String pem = SimpleTokenUtils.readResource("/publicKey4k.pem");
        RSAPublicKey publicKey = SimpleTokenUtils.decodePublicKey(pem);
        JsonObjectBuilder jwksBuilder = Json.createObjectBuilder();
        JsonObjectBuilder keyBuilder = Json.createObjectBuilder();
        BigInteger nBI = publicKey.getModulus();
        byte[] nbytes = nBI.toByteArray();
        if (nBI.bitLength() % 8 == 0 && nbytes[0] == 0 && nbytes.length > 1) {
            byte[] tmp = new byte[nbytes.length - 1];
            System.arraycopy(nbytes, 1, tmp, 0, tmp.length);
            nbytes = tmp;
        }
        String n = new String(Base64.getUrlEncoder().withoutPadding().encode(nbytes));
        BigInteger eBI = publicKey.getPublicExponent();
        byte[] ebytes = eBI.toByteArray();
        if (eBI.bitLength() % 8 == 0 && ebytes[0] == 0 && ebytes.length > 1) {
            byte[] tmp = new byte[nbytes.length - 1];
            System.arraycopy(nbytes, 1, tmp, 0, tmp.length);
            ebytes = tmp;
        }
        String e = new String(Base64.getUrlEncoder().withoutPadding().encode(ebytes));
        keyBuilder.add("kty", "RSA").add("use", "sig").add("alg", "RS256").add("kid", kid).add("e", e).add("n", n);
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        arrayBuilder.add(keyBuilder);
        jwksBuilder.add("keys", arrayBuilder);
        JsonObject jwks = jwksBuilder.build();
        return jwks;
    }

    private boolean verifyJWKS(String jwksJson, String kid, StringBuilder msg) {
        boolean pass;
        JsonObject jwks = Json.createReader((Reader)new StringReader(jwksJson)).readObject();
        JsonArray keys = jwks.getJsonArray("keys");
        if (keys != null) {
            JsonObject key = keys.getJsonObject(0);
            StringBuilder msgBuilder = new StringBuilder();
            pass = this.verifyJWK(key, kid, msgBuilder);
        } else {
            msg.append("No keys member found in: " + jwks);
            pass = false;
        }
        return pass;
    }

    private boolean verifyJWK(JsonObject key, String kid, StringBuilder msg) {
        String expectedKty;
        boolean pass = true;
        String string = expectedKty = "RS256".equals(this.algorithm) ? "RSA" : "EC";
        if (!key.getJsonString("kty").getString().equals(expectedKty)) {
            msg.append("key != " + expectedKty);
            pass = false;
        }
        if (!key.getJsonString("use").getString().equals("sig")) {
            msg.append("use != sig");
            pass = false;
        }
        if (!key.getJsonString("kid").getString().equals(kid)) {
            log.info(String.format("kid != %s, was: %s", kid, key.getJsonString("kid").getString()));
            msg.append(String.format("kid != %s, was: %s", kid, key.getJsonString("kid").getString()));
            pass = false;
        }
        if (!key.getJsonString("alg").getString().equals(this.algorithm)) {
            msg.append("alg != " + this.algorithm);
            pass = false;
        }
        if ("RS256".equals(this.algorithm)) {
            if (!key.getJsonString("e").getString().equals("AQAB")) {
                msg.append("e != AQAB");
                pass = false;
            }
            if (!key.getJsonString("n").getString().startsWith("tL6HShqY5H4y56rsCo7VdhT9")) {
                msg.append("n != tL6HShqY5H4y56rsCo7VdhT9...");
                pass = false;
            }
        } else if ("ES256".equals(this.algorithm)) {
            if (!key.getJsonString("crv").getString().equals("P-256")) {
                msg.append("crv != P-256");
                pass = false;
            }
            if (!key.getJsonString("x").getString().startsWith("w4HohvwOj21FBQE1Pr")) {
                msg.append("x != w4HohvwOj21FBQE1Pr...");
                pass = false;
            }
            if (!key.getJsonString("y").getString().startsWith("osZEjUhZa79-kClcGm")) {
                msg.append("y != osZEjUhZa79-kClcGm...");
                pass = false;
            }
        } else {
            pass = false;
        }
        if (pass) {
            msg.append("key as JWKS PASS");
        }
        return pass;
    }
}

