/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.health.tck;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import org.eclipse.microprofile.health.tck.DeploymentUtils;
import org.eclipse.microprofile.health.tck.TCKBase;
import org.eclipse.microprofile.health.tck.deployment.FailedStartup;
import org.eclipse.microprofile.health.tck.deployment.SuccessfulLiveness;
import org.eclipse.microprofile.health.tck.deployment.SuccessfulReadiness;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MultipleStartupFailedTest
extends TCKBase {
    @Deployment
    public static Archive getDeployment() {
        return DeploymentUtils.createWarFileWithClasses(MultipleStartupFailedTest.class.getSimpleName(), SuccessfulLiveness.class, SuccessfulReadiness.class, FailedStartup.class);
    }

    @Test
    @RunAsClient
    public void testFailingStartupResponsePayload() {
        TCKBase.Response response = this.getUrlStartedContents();
        Assert.assertEquals((int)response.getStatus(), (int)503);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        Assert.assertEquals((int)checks.size(), (int)1, (String)"Expected a single check response");
        this.assertFailureCheck(checks.getJsonObject(0), "failed-check");
        this.assertOverallFailure(json);
    }

    @Test
    @RunAsClient
    public void testSuccessfulLivenessResponsePayload() {
        TCKBase.Response response = this.getUrlLiveContents();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        Assert.assertEquals((int)checks.size(), (int)1, (String)"Expected a single check response");
        this.assertSuccessfulCheck(checks.getJsonObject(0), "successful-check");
        this.assertOverallSuccess(json);
    }

    @Test
    @RunAsClient
    public void testSuccessfulReadinessResponsePayload() {
        TCKBase.Response response = this.getUrlReadyContents();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        Assert.assertEquals((int)checks.size(), (int)1, (String)"Expected a single check response");
        this.assertSuccessfulCheck(checks.getJsonObject(0), "successful-check");
        this.assertOverallSuccess(json);
    }

    @Test
    @RunAsClient
    public void testFailingHealthResponsePayload() {
        TCKBase.Response response = this.getUrlHealthContents();
        Assert.assertEquals((int)response.getStatus(), (int)503);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        Assert.assertEquals((int)checks.size(), (int)3, (String)"Expected three check responses");
        block8: for (JsonObject check : checks.getValuesAs(JsonObject.class)) {
            String id;
            switch (id = check.getString("name")) {
                case "successful-check": {
                    this.verifySuccessStatus(check);
                    continue block8;
                }
                case "failed-check": {
                    this.verifyFailureStatus(check);
                    continue block8;
                }
            }
            Assert.fail((String)"Unexpected response payload structure");
        }
        this.assertOverallFailure(json);
    }
}

