/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.apps.superhero.model;

import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.List;
import javax.json.bind.annotation.JsonbDateFormat;
import org.eclipse.microprofile.graphql.NonNull;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.SuperHero;

public class Team {
    private String name;
    private List<SuperHero> members;
    private Team rivalTeam;
    @JsonbDateFormat(value="HH:mm 'offset' Z", locale="en-ZA")
    private OffsetTime dailyStandupMeeting;

    public Team() {
    }

    public Team(String name, List<SuperHero> members) {
        this.name = name;
        this.members = members;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public List<@NonNull SuperHero> getMembers() {
        return this.members;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMembers(List<SuperHero> members) {
        this.members = members;
    }

    public Team addMembers(SuperHero ... heroes) {
        if (this.members == null) {
            this.members = new ArrayList<SuperHero>();
        }
        for (SuperHero hero : heroes) {
            this.members.add(hero);
        }
        return this;
    }

    public Team removeMembers(SuperHero ... heroes) {
        if (this.members != null) {
            for (SuperHero hero : heroes) {
                this.members.remove(hero);
            }
        }
        return this;
    }

    public Team getRivalTeam() {
        return this.rivalTeam;
    }

    public void setRivalTeam(Team rivalTeam) {
        this.rivalTeam = rivalTeam;
    }

    public OffsetTime getDailyStandupMeeting() {
        return this.dailyStandupMeeting;
    }

    public void setDailyStandupMeeting(OffsetTime dailyStandupMeeting) {
        this.dailyStandupMeeting = dailyStandupMeeting;
    }

    public String toString() {
        return "Team{name=" + this.name + ", members=" + this.members;
    }
}

