/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.graphql.tck.apps.superhero.model;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.json.bind.annotation.JsonbDateFormat;
import javax.json.bind.annotation.JsonbNumberFormat;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbTransient;
import org.eclipse.microprofile.graphql.DateFormat;
import org.eclipse.microprofile.graphql.Description;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NonNull;
import org.eclipse.microprofile.graphql.NumberFormat;
import org.eclipse.microprofile.graphql.Query;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.Character;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.Item;
import org.eclipse.microprofile.graphql.tck.apps.superhero.model.Team;

public class SuperHero
implements Character {
    private List<Team> teamAffiliations;
    private List<@NonNull String> superPowers;
    private String primaryLocation;
    @Description(value="Super hero name/nickname")
    private String name;
    private String realName;
    private List<Item> equipment = new ArrayList<Item>();
    @JsonbDateFormat(value="MM/dd/yyyy")
    private LocalDate dateOfLastCheckin;
    @JsonbDateFormat(value="HH:mm")
    private LocalTime patrolStartTime = LocalTime.NOON;
    @JsonbDateFormat(value="HH:mm:ss dd-MM-yyyy")
    private LocalDateTime timeOfLastBattle;
    @JsonbProperty(value="colorOfCostume")
    private String costumeColor;
    private List<String> namesOfKnownEnemies;
    @JsonbNumberFormat(value="ID-########")
    private Long idNumber;
    @JsonbNumberFormat(value="\u00a4 ###,###.##", locale="en-US")
    private Double bankBalance;
    @JsonbNumberFormat(value="\u00a4 000.00", locale="en-US")
    private BigDecimal netWorth;
    @JsonbNumberFormat(value="###.## 'ml'", locale="en-GB")
    private Float favouriteDrinkSize;
    private List<BigDecimal> lastKnownCoordinates;
    private List<List<BigDecimal>> track;
    private Set<String> beenThere;
    private ShirtSize sizeOfTShirt;
    private List<LocalDate> importantDates;
    private List<Integer> kidsAges;
    @DateFormat(value="dd MMMM yyyy")
    private @DateFormat(value="dd MMMM yyyy") LocalDate birthday;

    public SuperHero() {
    }

    public SuperHero(List<Team> teamAffiliations, List<String> superPowers, String primaryLocation, String name, String realName) {
        this.teamAffiliations = teamAffiliations;
        this.superPowers = superPowers;
        this.primaryLocation = primaryLocation;
        this.name = name;
        this.realName = realName;
    }

    public List<Team> getTeamAffiliations() {
        return this.teamAffiliations;
    }

    public List<String> getSuperPowers() {
        return this.superPowers;
    }

    @Description(value="Location where you are most likely to find this hero")
    public String getPrimaryLocation() {
        return this.primaryLocation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setTeamAffiliations(List<Team> teamAffiliations) {
        this.teamAffiliations = teamAffiliations;
    }

    @Description(value="Powers that make this hero super")
    public void setSuperPowers(List<String> superPowers) {
        this.superPowers = superPowers;
    }

    public void setPrimaryLocation(String primaryLocation) {
        this.primaryLocation = primaryLocation;
    }

    @Override
    @NonNull
    public void setName(String name) {
        this.name = name;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public List<Item> getEquipment() {
        return this.equipment;
    }

    public void setEquipment(List<@NonNull Item> equipment) {
        this.equipment = equipment;
    }

    public String getCostumeColor() {
        return this.costumeColor;
    }

    public void setCostumeColor(String costumeColor) {
        this.costumeColor = costumeColor;
    }

    @Query(value="knownEnemies")
    public List<String> getNamesOfKnownEnemies() {
        return this.namesOfKnownEnemies;
    }

    @JsonbTransient
    public void setNamesOfKnownEnemies(List<String> namesOfKnownEnemies) {
        this.namesOfKnownEnemies = namesOfKnownEnemies;
    }

    public LocalDate getDateOfLastCheckin() {
        return this.dateOfLastCheckin;
    }

    public void setDateOfLastCheckin(LocalDate dateOfLastCheckin) {
        this.dateOfLastCheckin = dateOfLastCheckin;
    }

    public Long getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(Long idNumber) {
        this.idNumber = idNumber;
    }

    public LocalTime getPatrolStartTime() {
        return this.patrolStartTime;
    }

    public void setPatrolStartTime(LocalTime patrolStartTime) {
        this.patrolStartTime = patrolStartTime;
    }

    public LocalDateTime getTimeOfLastBattle() {
        return this.timeOfLastBattle;
    }

    public void setTimeOfLastBattle(LocalDateTime timeOfLastBattle) {
        this.timeOfLastBattle = timeOfLastBattle;
    }

    public ShirtSize getSizeOfTShirt() {
        return this.sizeOfTShirt;
    }

    @Name(value="tshirtSize")
    public void setSizeOfTShirt(ShirtSize sizeOfTShirt) {
        this.sizeOfTShirt = sizeOfTShirt;
    }

    public Double getBankBalance() {
        return this.bankBalance;
    }

    public void setBankBalance(Double bankBalance) {
        this.bankBalance = bankBalance;
    }

    public BigDecimal getNetWorth() {
        return this.netWorth;
    }

    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }

    public Float getFavouriteDrinkSize() {
        return this.favouriteDrinkSize;
    }

    public void setFavouriteDrinkSize(Float favouriteDrinkSize) {
        this.favouriteDrinkSize = favouriteDrinkSize;
    }

    public List<BigDecimal> getLastKnownCoordinates() {
        return this.lastKnownCoordinates;
    }

    public void setLastKnownCoordinates(List<BigDecimal> lastKnownCoordinates) {
        this.lastKnownCoordinates = lastKnownCoordinates;
    }

    public List<List<BigDecimal>> getTrack() {
        return this.track;
    }

    public void setTrack(List<List<BigDecimal>> track) {
        this.track = track;
    }

    public Set<String> getBeenThere() {
        return this.beenThere;
    }

    public void setBeenThere(Set<String> beenThere) {
        this.beenThere = beenThere;
    }

    public List<@DateFormat(value="dd/MM") LocalDate> getImportantDates() {
        return this.importantDates;
    }

    @Name(value="calendarEntries")
    public void setImportantDates(List<@DateFormat(value="dd/MM/yy") LocalDate> importantDates) {
        this.importantDates = importantDates;
    }

    @Name(value="agesOfKids")
    public List<@NumberFormat(value="0 'years'") Integer> getKidsAges() {
        return this.kidsAges;
    }

    public void setKidsAges(List<@NumberFormat(value="0 'years old'") Integer> kidsAges) {
        this.kidsAges = kidsAges;
    }

    public LocalDate getBirthday() {
        return this.birthday;
    }

    @Name(value="dateOfBirth")
    public void setBirthday(LocalDate birthday) {
        this.birthday = birthday;
    }

    public String toString() {
        return "SuperHero{, superPowers=" + this.superPowers + ", primaryLocation=" + this.primaryLocation + ", name=" + this.name + ", realName=" + this.realName + ", dateOfLastCheckin=" + this.dateOfLastCheckin + ", patrolStartTime=" + this.patrolStartTime + ", timeOfLastBattle=" + this.timeOfLastBattle + ", costumeColor=" + this.costumeColor + ", namesOfKnownEnemies=" + this.namesOfKnownEnemies + ", idNumber=" + this.idNumber + ", sizeOfTShirt=" + (Object)((Object)this.sizeOfTShirt) + '}';
    }

    public static enum ShirtSize {
        S,
        M,
        L,
        XL,
        XXL,
        HULK;

    }
}

