/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead.lifecycle;

import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.lifecycle.BulkheadLifecycleService1;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.lifecycle.BulkheadLifecycleService2;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.lifecycle.BulkheadLifecycleServiceSubclass1;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.lifecycle.BulkheadLifecycleServiceSubclass2;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.lifecycle.MutlipleMethodsBulkheadLifecycleService;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class BulkheadLifecycleTest
extends Arquillian {
    @Inject
    private AsyncCaller async;
    @Inject
    private Instance<BulkheadLifecycleService1> service1;
    @Inject
    private Instance<BulkheadLifecycleService2> service2;
    @Inject
    private Instance<BulkheadLifecycleServiceSubclass1> subclassService1;
    @Inject
    private Instance<BulkheadLifecycleServiceSubclass2> subclassService2;
    @Inject
    private Instance<MutlipleMethodsBulkheadLifecycleService> multipleMethodsService;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadLifecycle.jar")).addPackage(BulkheadLifecycleService1.class.getPackage())).addPackage(AsyncCaller.class.getPackage())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadLifecycle.war")).addAsLibrary((Archive)testJar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noSharingBetweenClasses() throws InterruptedException, ExecutionException, TimeoutException {
        Barrier barrier = new Barrier();
        BulkheadLifecycleService1 service1a = (BulkheadLifecycleService1)this.service1.get();
        BulkheadLifecycleService1 service1b = (BulkheadLifecycleService1)this.service1.get();
        BulkheadLifecycleService2 service2a = (BulkheadLifecycleService2)this.service2.get();
        BulkheadLifecycleService2 service2b = (BulkheadLifecycleService2)this.service2.get();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        try {
            for (int i = 0; i < 4; ++i) {
                futures.add(this.async.run(() -> service1a.service(barrier)));
                futures.add(this.async.run(() -> service2a.service(barrier)));
                futures.add(this.async.run(() -> service1b.service(barrier)));
                futures.add(this.async.run(() -> service2b.service(barrier)));
            }
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> barrier.countWaiting() == 16);
            Exceptions.expect(BulkheadException.class, this.async.run(() -> service1a.service(barrier)));
            Exceptions.expect(BulkheadException.class, this.async.run(() -> service2a.service(barrier)));
            Exceptions.expect(BulkheadException.class, this.async.run(() -> service1b.service(barrier)));
            Exceptions.expect(BulkheadException.class, this.async.run(() -> service2b.service(barrier)));
        }
        finally {
            try {
                barrier.open();
                for (Future future : futures) {
                    future.get(1L, TimeUnit.MINUTES);
                }
            }
            finally {
                this.service1.destroy((Object)service1a);
                this.service1.destroy((Object)service1b);
                this.service2.destroy((Object)service2a);
                this.service2.destroy((Object)service2b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noSharingBetweenClassesWithCommonSuperclass() throws InterruptedException, ExecutionException, TimeoutException {
        Barrier barrier = new Barrier();
        BulkheadLifecycleServiceSubclass1 service1a = (BulkheadLifecycleServiceSubclass1)this.subclassService1.get();
        BulkheadLifecycleServiceSubclass1 service1b = (BulkheadLifecycleServiceSubclass1)this.subclassService1.get();
        BulkheadLifecycleServiceSubclass2 service2a = (BulkheadLifecycleServiceSubclass2)this.subclassService2.get();
        BulkheadLifecycleServiceSubclass2 service2b = (BulkheadLifecycleServiceSubclass2)this.subclassService2.get();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        try {
            for (int i = 0; i < 4; ++i) {
                futures.add(this.async.run(() -> service1a.service(barrier)));
                futures.add(this.async.run(() -> service2a.service(barrier)));
                futures.add(this.async.run(() -> service1b.service(barrier)));
                futures.add(this.async.run(() -> service2b.service(barrier)));
            }
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> barrier.countWaiting() == 16);
            Exceptions.expect(BulkheadException.class, this.async.run(() -> service1a.service(barrier)));
            Exceptions.expect(BulkheadException.class, this.async.run(() -> service2a.service(barrier)));
            Exceptions.expect(BulkheadException.class, this.async.run(() -> service1b.service(barrier)));
            Exceptions.expect(BulkheadException.class, this.async.run(() -> service2b.service(barrier)));
        }
        finally {
            try {
                barrier.open();
                for (Future future : futures) {
                    future.get(1L, TimeUnit.MINUTES);
                }
            }
            finally {
                this.subclassService1.destroy((Object)service1a);
                this.subclassService1.destroy((Object)service1b);
                this.subclassService2.destroy((Object)service2a);
                this.subclassService2.destroy((Object)service2b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void noSharingBetweenMethodsOfOneClass() throws InterruptedException, ExecutionException, TimeoutException {
        Barrier barrier = new Barrier();
        MutlipleMethodsBulkheadLifecycleService multipleMethodsService1 = (MutlipleMethodsBulkheadLifecycleService)this.multipleMethodsService.get();
        MutlipleMethodsBulkheadLifecycleService multipleMethodsService2 = (MutlipleMethodsBulkheadLifecycleService)this.multipleMethodsService.get();
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        try {
            for (int i = 0; i < 4; ++i) {
                futures.add(this.async.run(() -> multipleMethodsService1.service1(barrier)));
                futures.add(this.async.run(() -> multipleMethodsService1.service2(barrier)));
                futures.add(this.async.run(() -> multipleMethodsService2.service1(barrier)));
                futures.add(this.async.run(() -> multipleMethodsService2.service2(barrier)));
            }
            Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> barrier.countWaiting() == 16);
            Exceptions.expect(BulkheadException.class, this.async.run(() -> multipleMethodsService1.service1(barrier)));
            Exceptions.expect(BulkheadException.class, this.async.run(() -> multipleMethodsService1.service2(barrier)));
            Exceptions.expect(BulkheadException.class, this.async.run(() -> multipleMethodsService2.service1(barrier)));
            Exceptions.expect(BulkheadException.class, this.async.run(() -> multipleMethodsService2.service2(barrier)));
        }
        finally {
            try {
                barrier.open();
                for (Future future : futures) {
                    future.get(1L, TimeUnit.MINUTES);
                }
            }
            finally {
                this.multipleMethodsService.destroy((Object)multipleMethodsService1);
                this.multipleMethodsService.destroy((Object)multipleMethodsService2);
            }
        }
    }
}

