/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.retrytimeout.clientserver.RetryTimeoutClient;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RetryTimeoutTest
extends Arquillian {
    @Inject
    private RetryTimeoutClient clientForRetryTimeout;
    private TCKConfig config = TCKConfig.getConfig();

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().setValue(RetryTimeoutClient.class, "serviceA", Timeout.class, TCKConfig.getConfig().getTimeoutInStr(500L)).setValue(RetryTimeoutClient.class, "serviceWithoutRetryOn", Timeout.class, TCKConfig.getConfig().getTimeoutInStr(500L)).setValue(RetryTimeoutClient.class, "serviceWithAbortOn", Timeout.class, TCKConfig.getConfig().getTimeoutInStr(500L));
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftRetryTimeout.jar")).addClasses(new Class[]{RetryTimeoutClient.class, TestException.class})).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftRetryTimeout.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testRetryTimeout() {
        try {
            String string = this.clientForRetryTimeout.serviceA(this.config.getTimeoutInMillis(1000L));
        }
        catch (TimeoutException timeoutException) {
        }
        catch (TestException ex) {
            Assert.fail((String)"serviceA should not throw a RuntimeException in testRetryTimeout", (Throwable)ex);
        }
        Assert.assertEquals((int)this.clientForRetryTimeout.getCounterForInvokingServiceA(), (int)2, (String)"The execution count should be 2 (1 retry + 1)");
    }

    @Test
    public void testRetryNoTimeout() {
        try {
            String string = this.clientForRetryTimeout.serviceA(this.config.getTimeoutInMillis(10L));
        }
        catch (TimeoutException ex) {
            Assert.fail((String)"serviceA should not throw a TimeoutException in testRetrytNoTimeout");
        }
        catch (TestException testException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForRetryTimeout.getCounterForInvokingServiceA(), (int)2, (String)"The execution count should be 2 (1 retry + 1)");
    }

    @Test
    public void testRetryWithoutRetryOn() {
        try {
            this.clientForRetryTimeout.serviceWithoutRetryOn();
            Assert.fail((String)"Timeout exception not thrown");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForRetryTimeout.getCounterForInvokingServiceWithoutRetryOn(), (int)1, (String)"The execution count should be 1 (no retries)");
    }

    @Test
    public void testRetryWithAbortOn() {
        try {
            this.clientForRetryTimeout.serviceWithAbortOn();
            Assert.fail((String)"Timeout exception not thrown");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.clientForRetryTimeout.getCounterForInvokingServiceWithAbortOn(), (int)1, (String)"The execution count should be 1 (no retries)");
    }
}

