/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics;

import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import jakarta.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.ClassLevelMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.PullExporterAutoConfigurationCustomizerProvider;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class ClassLevelTelemetryTest
extends Arquillian {
    @Inject
    private ClassLevelMetricBean classLevelRetryBean;

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricClassLevel.war")).addClasses(new Class[]{ClassLevelMetricBean.class})).addPackage(Packages.UTILS)).addPackage(Packages.TELEMETRY_METRIC_UTILS)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.traces.exporter=none"), "META-INF/microprofile-config.properties")).addAsServiceProvider(AutoConfigurationCustomizerProvider.class, new Class[]{PullExporterAutoConfigurationCustomizerProvider.class});
        return war;
    }

    @Test
    public void testRetryMetricSuccessfulImmediately() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(ClassLevelMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        this.classLevelRetryBean.failSeveralTimes(0);
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.FALSE, TelemetryMetricDefinition.RetryResult.VALUE_RETURNED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricSuccessfulAfterRetry() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(ClassLevelMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        this.classLevelRetryBean.failSeveralTimes(3);
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.VALUE_RETURNED, 1L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)3L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
    }

    @Test
    public void testRetryMetricUnsuccessful() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(ClassLevelMetricBean.class, "failSeveralTimes");
        m.baselineMetrics();
        Exceptions.expectTestException(() -> this.classLevelRetryBean.failSeveralTimes(20));
        Exceptions.expectTestException(() -> this.classLevelRetryBean.failSeveralTimes(20));
        this.assertRetryCallsIncremented(m, TelemetryMetricDefinition.RetryRetried.TRUE, TelemetryMetricDefinition.RetryResult.MAX_RETRIES_REACHED, 2L);
        MatcherAssert.assertThat((String)"retries", (Object)m.getRetryRetries().delta(), (Matcher)Matchers.is((Object)10L));
        MatcherAssert.assertThat((String)"invocations returning value", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"invocations throwing exception", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_DEFINED).delta(), (Matcher)Matchers.is((Object)2L));
    }

    private void assertRetryCallsIncremented(TelemetryMetricGetter m, TelemetryMetricDefinition.RetryRetried retriedValue, TelemetryMetricDefinition.RetryResult resultValue, Long expectedDelta) {
        for (TelemetryMetricDefinition.RetryRetried retried : TelemetryMetricDefinition.RetryRetried.values()) {
            for (TelemetryMetricDefinition.RetryResult result : TelemetryMetricDefinition.RetryResult.values()) {
                if (retried == retriedValue && result == resultValue) {
                    MatcherAssert.assertThat((String)("Retry calls (" + retried + ", " + result + ")"), (Object)m.getRetryCalls(retried, result).delta(), (Matcher)Matchers.is((Object)expectedDelta));
                    continue;
                }
                MatcherAssert.assertThat((String)("Retry calls (" + retried + ", " + result + ")"), (Object)m.getRetryCalls(retried, result).delta(), (Matcher)Matchers.is((Object)0L));
            }
        }
    }
}

