/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.disableEnv;

import jakarta.enterprise.context.RequestScoped;
import java.sql.Connection;
import org.eclipse.microprofile.fault.tolerance.tck.fallback.clientserver.StringFallbackHandler;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;

@RequestScoped
public class DisableClient {
    private int counterForInvokingConnenectionService = 0;
    private int counterForInvokingServiceB = 0;
    private int counterForInvokingServiceC = 0;

    @Retry(maxRetries=1)
    public Connection serviceA() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this.connectionService();
    }

    @Retry(maxRetries=1)
    @Fallback(value=StringFallbackHandler.class)
    public String serviceB() {
        ++this.counterForInvokingServiceB;
        return this.nameService();
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=4, failureRatio=0.75, delay=50000L)
    public Connection serviceC() {
        Connection conn = null;
        ++this.counterForInvokingServiceC;
        conn = this.connectionService();
        return conn;
    }

    @Timeout
    public Connection serviceD(long timeToSleep) {
        try {
            Thread.sleep(timeToSleep);
            throw new TestException("Timeout did not interrupt");
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    private String nameService() {
        throw new TestException("Connection failed");
    }

    private Connection connectionService() {
        ++this.counterForInvokingConnenectionService;
        throw new TestException("Connection failed");
    }

    public int getRetryCountForConnectionService() {
        return this.counterForInvokingConnenectionService;
    }

    public int getCounterForInvokingServiceB() {
        return this.counterForInvokingServiceB;
    }

    public int getCounterForInvokingServiceC() {
        return this.counterForInvokingServiceC;
    }
}

