/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.bulkhead;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead10ClassSemaphoreBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead10MethodSemaphoreBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead3ClassSemaphoreBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead3MethodSemaphoreBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.Bulkhead3TaskQueueSemaphoreBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadClassSemaphoreDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.bulkhead.clientserver.BulkheadMethodSemaphoreDefaultBean;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class BulkheadSynchTest
extends Arquillian {
    @Inject
    private BulkheadClassSemaphoreDefaultBean bhBeanClassSemaphoreDefault;
    @Inject
    private BulkheadMethodSemaphoreDefaultBean bhBeanMethodSemaphoreDefault;
    @Inject
    private Bulkhead3ClassSemaphoreBean bhBeanClassSemaphore3;
    @Inject
    private Bulkhead3MethodSemaphoreBean bhBeanMethodSemaphore3;
    @Inject
    private Bulkhead10ClassSemaphoreBean bhBeanClassSemaphore10;
    @Inject
    private Bulkhead10MethodSemaphoreBean bhBeanMethodSemaphore10;
    @Inject
    private Bulkhead3TaskQueueSemaphoreBean bhBeanTaskQueueSemaphore3;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftBulkheadSynchTest.jar")).addPackage(BulkheadClassSemaphoreDefaultBean.class.getPackage())).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftBulkheadSynchTest.war")).addAsLibrary((Archive)testJar);
    }

    @Test
    public void testBulkheadClassSemaphore3() {
        BulkheadSynchTest.testBulkhead(3, this.bhBeanClassSemaphore3::test);
    }

    @Test
    public void testBulkheadMethodSemaphore3() {
        BulkheadSynchTest.testBulkhead(3, this.bhBeanMethodSemaphore3::test);
    }

    @Test
    public void testBulkheadClassSemaphore10() {
        BulkheadSynchTest.testBulkhead(10, this.bhBeanClassSemaphore10::test);
    }

    @Test
    public void testBulkheadMethodSemaphore10() {
        BulkheadSynchTest.testBulkhead(10, this.bhBeanMethodSemaphore10::test);
    }

    @Test
    public void testBulkheadClassSemaphoreDefault() {
        BulkheadSynchTest.testBulkhead(10, this.bhBeanClassSemaphoreDefault::test);
    }

    @Test
    public void testBulkheadMethodSemaphoreDefault() {
        BulkheadSynchTest.testBulkhead(10, this.bhBeanMethodSemaphoreDefault::test);
    }

    public void testSemaphoreWaitingTaskQueueIgnored() {
        BulkheadSynchTest.testBulkhead(3, this.bhBeanTaskQueueSemaphore3::test);
    }

    public static void testBulkhead(int maxRunning, Consumer<Barrier> bulkheadMethod) {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            int i;
            ArrayList<AsyncTaskManager.BarrierTask<Void>> runningTasks = new ArrayList<AsyncTaskManager.BarrierTask<Void>>();
            for (i = 0; i < maxRunning; ++i) {
                AsyncTaskManager.BarrierTask<Void> task = taskManager.runBarrierTask(bulkheadMethod);
                runningTasks.add(task);
            }
            for (i = 0; i < maxRunning; ++i) {
                ((AsyncTaskManager.BarrierTask)runningTasks.get(i)).assertAwaits();
            }
            AsyncTaskManager.BarrierTask<Void> overflowTask = taskManager.runBarrierTask(bulkheadMethod);
            overflowTask.assertThrows(BulkheadException.class);
            AsyncTaskManager.BarrierTask releasedTask = (AsyncTaskManager.BarrierTask)runningTasks.get(7 % maxRunning);
            releasedTask.openBarrier();
            releasedTask.assertSuccess();
            AsyncTaskManager.BarrierTask<Void> extraTask = taskManager.runBarrierTask(bulkheadMethod);
            extraTask.assertAwaits();
            AsyncTaskManager.BarrierTask<Void> overflowTask2 = taskManager.runBarrierTask(bulkheadMethod);
            overflowTask2.assertThrows(BulkheadException.class);
        }
    }
}

