/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import jakarta.inject.Inject;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.fault.tolerance.tck.asynchronous.AsyncCancellationClient;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.util.Barrier;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AsyncCancellationTest
extends Arquillian {
    @Inject
    private AsyncCancellationClient bean;

    @Deployment
    public static WebArchive deploy() {
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftAsyncCancellation.jar")).addClasses(new Class[]{AsyncCancellationClient.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftAsyncCancellation.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testCancel() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            Barrier barrier = taskManager.newBarrier();
            AtomicBoolean wasInterrupted = new AtomicBoolean(false);
            Future<?> result = this.bean.serviceAsync(barrier, wasInterrupted);
            barrier.assertAwaits();
            result.cancel(true);
            Awaitility.await((String)"wasInterrupted").untilAtomic(wasInterrupted, Matchers.is((Object)true));
            Assert.assertTrue((boolean)result.isCancelled(), (String)"Task is not cancelled");
            Assert.assertTrue((boolean)result.isDone(), (String)"Task is not done");
            Exceptions.expect(CancellationException.class, () -> result.get(2L, TimeUnit.SECONDS));
            Exceptions.expect(CancellationException.class, () -> result.get());
        }
    }

    @Test
    public void testCancelWithoutInterrupt() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            Barrier barrier = taskManager.newBarrier();
            AtomicBoolean wasInterrupted = new AtomicBoolean(false);
            Future<?> result = this.bean.serviceAsync(barrier, wasInterrupted);
            barrier.assertAwaits();
            result.cancel(false);
            Awaitility.await((String)"wasInterrupted").during(TCKConfig.getConfig().getTimeoutInDuration(500)).untilAtomic(wasInterrupted, Matchers.is((Object)false));
            Assert.assertTrue((boolean)result.isCancelled(), (String)"Task is not cancelled");
            Assert.assertTrue((boolean)result.isDone(), (String)"Task is not done");
            Exceptions.expect(CancellationException.class, () -> result.get(2L, TimeUnit.SECONDS));
            Exceptions.expect(CancellationException.class, () -> result.get());
            barrier.open();
            Awaitility.await((String)"cancellationException").during(TCKConfig.getConfig().getTimeoutInDuration(500)).untilAsserted(() -> Exceptions.expect(CancellationException.class, () -> result.get(2L, TimeUnit.SECONDS)));
            Assert.assertTrue((boolean)result.isCancelled(), (String)"Task is not cancelled");
            Assert.assertTrue((boolean)result.isDone(), (String)"Task is not done");
        }
    }

    @Test
    public void testCancelledButRemainsInBulkhead() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            Barrier barrier1 = taskManager.newBarrier();
            Future<?> result1 = this.bean.serviceAsyncBulkhead(barrier1);
            barrier1.assertAwaits();
            Barrier barrier2 = taskManager.newBarrier();
            Future<?> result2 = this.bean.serviceAsyncBulkhead(barrier2);
            barrier2.assertNotAwaiting();
            result1.cancel(false);
            barrier2.assertNotAwaiting();
            Assert.assertTrue((boolean)result1.isCancelled(), (String)"Task is not cancelled");
            Assert.assertTrue((boolean)result1.isDone(), (String)"Task is not done");
            Exceptions.expect(CancellationException.class, () -> result1.get(2L, TimeUnit.SECONDS));
            Exceptions.expect(CancellationException.class, () -> result1.get());
        }
    }

    @Test
    public void testCancelledWhileQueued() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            Barrier barrier1 = taskManager.newBarrier();
            Future<?> result1 = this.bean.serviceAsyncBulkhead(barrier1);
            barrier1.assertAwaits();
            Barrier barrier2 = taskManager.newBarrier();
            Future<?> result2 = this.bean.serviceAsyncBulkhead(barrier2);
            barrier2.assertNotAwaiting();
            result2.cancel(false);
            barrier1.open();
            barrier2.assertNotAwaiting();
        }
    }

    @Test
    public void testCancelledDoesNotRetry() throws InterruptedException {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            Barrier barrier = taskManager.newBarrier();
            Future<?> result = this.bean.serviceAsyncRetry(barrier);
            barrier.assertAwaits();
            result.cancel(true);
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(500L));
            Assert.assertEquals((int)this.bean.getServiceAsyncRetryAttempts(), (int)1, (String)"Method should not have been retried - too many retry attempts");
        }
    }
}

