/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.PointData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InMemoryMetricReaderTest {
    @Test
    public void testHasAllAttributes() {
        AttributeKey key1 = AttributeKey.longKey((String)"key1");
        AttributeKey key2 = AttributeKey.stringKey((String)"key2");
        AttributeKey key3 = AttributeKey.longArrayKey((String)"key3");
        AttributeKey key4 = AttributeKey.stringArrayKey((String)"key4");
        Attributes expected = Attributes.builder().put(key1, 1).put(key2, (Object)"value2").put(key3, Arrays.asList(1L, 2L, 3L)).build();
        Predicate hasExpectedAttributes = InMemoryMetricReader.hasAllAttributes((Attributes)expected);
        Attributes identical = Attributes.builder().put(key1, 1).put(key2, (Object)"value2").put(key3, Arrays.asList(1L, 2L, 3L)).build();
        Assert.assertTrue((boolean)hasExpectedAttributes.test(InMemoryMetricReaderTest.pointData(identical)), (String)"identical");
        Attributes differentLongValue = Attributes.builder().put(key1, 7).put(key2, (Object)"value2").put(key3, Arrays.asList(1L, 2L, 3L)).build();
        Assert.assertFalse((boolean)hasExpectedAttributes.test(InMemoryMetricReaderTest.pointData(differentLongValue)), (String)"differentLongValue");
        Attributes differentStringValue = Attributes.builder().put(key1, 1).put(key2, (Object)"value7").put(key3, Arrays.asList(1L, 2L, 3L)).build();
        Assert.assertFalse((boolean)hasExpectedAttributes.test(InMemoryMetricReaderTest.pointData(differentStringValue)), (String)"differentStringValue");
        Attributes differentListValue = Attributes.builder().put(key1, 1).put(key2, (Object)"value2").put(key3, Arrays.asList(1L, 2L, 3L, 7L)).build();
        Assert.assertFalse((boolean)hasExpectedAttributes.test(InMemoryMetricReaderTest.pointData(differentListValue)), (String)"differentListValue");
        Attributes extraKey = Attributes.builder().put(key1, 1).put(key2, (Object)"value2").put(key3, Arrays.asList(1L, 2L, 3L)).put(key4, Arrays.asList("value1", "value2")).build();
        Assert.assertTrue((boolean)hasExpectedAttributes.test(InMemoryMetricReaderTest.pointData(extraKey)), (String)"extraKey");
        Attributes missingKey = Attributes.builder().put(key1, 1).put(key2, (Object)"value2").build();
        Assert.assertFalse((boolean)hasExpectedAttributes.test(InMemoryMetricReaderTest.pointData(missingKey)), (String)"missingKey");
    }

    private static PointData pointData(final Attributes attributes) {
        return new PointData(){

            public long getStartEpochNanos() {
                return 0L;
            }

            public long getEpochNanos() {
                return 0L;
            }

            public List<? extends ExemplarData> getExemplars() {
                return Collections.emptyList();
            }

            public Attributes getAttributes() {
                return attributes;
            }
        };
    }
}

