/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.disableEnv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.jboss.shrinkwrap.api.asset.Asset;

public class DisableConfigAsset
implements Asset {
    private Properties props = new Properties();

    public Properties getProps() {
        return this.props;
    }

    public InputStream openStream() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.props.store(os, null);
            return new ByteArrayInputStream(os.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error saving properties", e);
        }
    }

    public DisableConfigAsset disableGlobally() {
        this.props.put("MP_Fault_Tolerance_NonFallback_Enabled", "false");
        return this;
    }

    public DisableConfigAsset disable(Class<?> clazz, String method, Class<? extends Annotation> annotation) {
        this.props.put(this.keyFor(clazz, method, annotation), "false");
        return this;
    }

    public DisableConfigAsset disable(Class<?> clazz, Class<? extends Annotation> annotation) {
        this.props.put(this.keyFor(clazz, null, annotation), "false");
        return this;
    }

    public DisableConfigAsset disable(Class<? extends Annotation> annotation) {
        this.props.put(this.keyFor(null, null, annotation), "false");
        return this;
    }

    public DisableConfigAsset enable(Class<?> clazz, String method, Class<? extends Annotation> annotation) {
        this.props.put(this.keyFor(clazz, method, annotation), "true");
        return this;
    }

    public DisableConfigAsset enable(Class<?> clazz, Class<? extends Annotation> annotation) {
        this.props.put(this.keyFor(clazz, null, annotation), "true");
        return this;
    }

    public DisableConfigAsset enable(Class<? extends Annotation> annotation) {
        this.props.put(this.keyFor(null, null, annotation), "true");
        return this;
    }

    private String keyFor(Class<?> clazz, String method, Class<? extends Annotation> annotation) {
        StringBuilder sb = new StringBuilder();
        if (clazz != null) {
            sb.append(clazz.getCanonicalName());
            sb.append("/");
        }
        if (method != null) {
            sb.append(method);
            sb.append("/");
        }
        sb.append(annotation.getSimpleName());
        sb.append("/");
        sb.append("enabled");
        return sb.toString();
    }
}

