/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck;

import java.sql.Connection;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClassLevelClientWithRetry;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithRetry;
import org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver.CircuitBreakerClientWithRetryAsync;
import org.eclipse.microprofile.fault.tolerance.tck.config.ConfigAnnotationAsset;
import org.eclipse.microprofile.fault.tolerance.tck.util.DurationMatcher;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CircuitBreakerRetryTest
extends Arquillian {
    @Inject
    private CircuitBreakerClientWithRetry clientForCBWithRetry;
    @Inject
    private CircuitBreakerClassLevelClientWithRetry clientForClassLevelCBWithRetry;
    @Inject
    private CircuitBreakerClientWithRetryAsync clientForCBWithRetryAsync;

    @Deployment
    public static WebArchive deploy() {
        ConfigAnnotationAsset config = new ConfigAnnotationAsset().autoscaleMethod(CircuitBreakerClientWithRetry.class, "serviceC").autoscaleMethod(CircuitBreakerClientWithRetry.class, "serviceWithRetryOnCbOpen").autoscaleMethod(CircuitBreakerClientWithRetry.class, "serviceWithRetryOnTimeout").autoscaleMethod(CircuitBreakerClientWithRetry.class, "serviceWithRetryFailOnCbOpen").autoscaleMethod(CircuitBreakerClientWithRetryAsync.class, "serviceC").autoscaleMethod(CircuitBreakerClientWithRetryAsync.class, "serviceWithRetryOnCbOpen").autoscaleMethod(CircuitBreakerClientWithRetryAsync.class, "serviceWithRetryOnTimeout").autoscaleMethod(CircuitBreakerClientWithRetryAsync.class, "serviceWithRetryFailOnCbOpen");
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftCircuitBreakerRetry.jar")).addClasses(new Class[]{CircuitBreakerClientWithRetry.class, CircuitBreakerClassLevelClientWithRetry.class, CircuitBreakerClientWithRetryAsync.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsManifestResource((Asset)config, "microprofile-config.properties")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftCircuitBreakerRetry.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testCircuitOpenWithMoreRetries() {
        int invokeCounter = 0;
        try {
            this.clientForCBWithRetry.serviceA();
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry in testCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceA();
            if (invokeCounter < 4) {
                Assert.fail((String)("serviceA should retry in testCircuitOpenWithMoreRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry or throw a CircuitBreakerOpenException in testCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceA();
        Assert.assertEquals((int)invokeCounter, (int)4, (String)"The number of executions should be 4");
    }

    @Test
    public void testCircuitOpenWithFewRetries() {
        int invokeCounter = 0;
        try {
            this.clientForCBWithRetry.serviceB();
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry or throw a RuntimeException (not a CBOE) in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        catch (RuntimeException ex) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
            if (invokeCounter < 3) {
                Assert.fail((String)("serviceB should retry in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry or throw a RuntimeException in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceB();
        Assert.assertEquals((int)invokeCounter, (int)3, (String)"The number of executions should be 3");
    }

    @Test
    public void testClassLevelCircuitOpenWithMoreRetries() {
        int invokeCounter = 0;
        try {
            this.clientForClassLevelCBWithRetry.serviceA();
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry in testClassLevelCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceA();
            if (invokeCounter < 4) {
                Assert.fail((String)("serviceA should retry in testClassLevelCircuitOpenWithMoreRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry or throw a CircuitBreakerOpenException in testClassLevelCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceA();
        Assert.assertEquals((int)invokeCounter, (int)4, (String)"The number of executions should be 4");
    }

    @Test
    public void testClassLevelCircuitOpenWithFewRetries() {
        int invokeCounter = 0;
        try {
            this.clientForClassLevelCBWithRetry.serviceB();
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry in testClassLevelCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry or throw a RuntimeException (not a CBOE) in testClassLevelCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        catch (RuntimeException ex) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
            if (invokeCounter < 3) {
                Assert.fail((String)("serviceB should retry in testClassLevelCircuitOpenWithFewRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry or throw a RuntimeException in testClassLevelCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForClassLevelCBWithRetry.getCounterForInvokingServiceB();
        Assert.assertEquals((int)invokeCounter, (int)3, (String)"The number of executions should be 3");
    }

    @Test
    public void testCircuitOpenWithMultiTimeouts() {
        int invokeCounter = 0;
        try {
            this.clientForCBWithRetry.serviceC();
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceC();
            Assert.fail((String)("serviceC should retry in testCircuitOpenWithMultiTimeouts on iteration " + invokeCounter));
        }
        catch (CircuitBreakerOpenException cboe) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceC();
            if (invokeCounter < 4) {
                Assert.fail((String)("serviceC should retry in testCircuitOpenWithMultiTimeouts on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceC();
            Assert.fail((String)("serviceC should retry or throw a CircuitBreakerOpenException in testCircuitOpenWithMultiTimeouts on iteration " + invokeCounter + ", caught exception: " + ex));
        }
        invokeCounter = this.clientForCBWithRetry.getCounterForInvokingServiceC();
        Assert.assertEquals((int)invokeCounter, (int)4, (String)"The number of executions should be 4");
    }

    @Test
    public void testRetriesSucceedWhenCircuitCloses() {
        for (int i = 0; i < 4; ++i) {
            try {
                this.clientForCBWithRetry.serviceWithRetryOnCbOpen(true);
                continue;
            }
            catch (TestException testException) {
                // empty catch block
            }
        }
        long startTime = System.nanoTime();
        this.clientForCBWithRetry.serviceWithRetryOnCbOpen(false);
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Call was successful but did not take the expected time", (Object)Duration.ofNanos(endTime - startTime), (Matcher)DurationMatcher.closeTo(TCKConfig.getConfig().getTimeoutInDuration(1000), TCKConfig.getConfig().getTimeoutInDuration(250)));
    }

    public void testNoRetriesIfNotRetryOn() {
        for (int i = 0; i < 4; ++i) {
            try {
                this.clientForCBWithRetry.serviceWithRetryOnTimeout(true);
                continue;
            }
            catch (TestException testException) {
                // empty catch block
            }
        }
        long startTime = System.nanoTime();
        Exceptions.expectCbOpen(() -> this.clientForCBWithRetry.serviceWithRetryOnTimeout(false));
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Call was successful but did not take the expected time", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)TCKConfig.getConfig().getTimeoutInDuration(200)));
    }

    public void testNoRetriesIfAbortOn() {
        for (int i = 0; i < 4; ++i) {
            try {
                this.clientForCBWithRetry.serviceWithRetryFailOnCbOpen(true);
                continue;
            }
            catch (TestException testException) {
                // empty catch block
            }
        }
        long startTime = System.nanoTime();
        Exceptions.expectCbOpen(() -> this.clientForCBWithRetry.serviceWithRetryFailOnCbOpen(false));
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Call was successful but did not take the expected time", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)TCKConfig.getConfig().getTimeoutInDuration(200)));
    }

    @Test
    public void testCircuitOpenWithMoreRetriesAsync() {
        int invokeCounter = 0;
        Future<Connection> result = this.clientForCBWithRetryAsync.serviceA();
        try {
            result.get(TCKConfig.getConfig().getTimeoutInMillis(5000L), TimeUnit.MILLISECONDS);
            invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry in testCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        catch (ExecutionException executionException) {
            MatcherAssert.assertThat((String)"Thrown exception is the wrong type", (Object)executionException.getCause(), (Matcher)Matchers.instanceOf(CircuitBreakerOpenException.class));
            invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceA();
            if (invokeCounter < 4) {
                Assert.fail((String)("serviceA should retry in testCircuitOpenWithMoreRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceA();
            Assert.fail((String)("serviceA should retry or throw a CircuitBreakerOpenException in testCircuitOpenWithMoreRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceA();
        Assert.assertEquals((int)invokeCounter, (int)4, (String)"The number of executions should be 4");
    }

    @Test
    public void testCircuitOpenWithFewRetriesAsync() {
        int invokeCounter = 0;
        Future<Connection> result = this.clientForCBWithRetryAsync.serviceB();
        try {
            result.get(TCKConfig.getConfig().getTimeoutInMillis(5000L), TimeUnit.MILLISECONDS);
            invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        catch (ExecutionException ex) {
            MatcherAssert.assertThat((String)"Thrown exception is the wrong type", (Object)ex.getCause(), (Matcher)Matchers.instanceOf(TestException.class));
            invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceB();
            if (invokeCounter < 3) {
                Assert.fail((String)("serviceB should retry in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceB();
            Assert.fail((String)("serviceB should retry or throw a RuntimeException in testCircuitOpenWithFewRetries on iteration " + invokeCounter));
        }
        invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceB();
        Assert.assertEquals((int)invokeCounter, (int)3, (String)"The number of executions should be 3");
    }

    @Test
    public void testCircuitOpenWithMultiTimeoutsAsync() {
        int invokeCounter = 0;
        Future<Connection> result = this.clientForCBWithRetryAsync.serviceC();
        try {
            result.get(TCKConfig.getConfig().getTimeoutInMillis(10000L), TimeUnit.MILLISECONDS);
            invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceC();
            Assert.fail((String)("serviceC should retry in testCircuitOpenWithMultiTimeouts on iteration " + invokeCounter));
        }
        catch (ExecutionException executionException) {
            MatcherAssert.assertThat((String)"Thrown exception is the wrong type", (Object)executionException.getCause(), (Matcher)Matchers.instanceOf(CircuitBreakerOpenException.class));
            invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceC();
            if (invokeCounter < 4) {
                Assert.fail((String)("serviceC should retry in testCircuitOpenWithMultiTimeouts on iteration " + invokeCounter));
            }
        }
        catch (Exception ex) {
            invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceC();
            Assert.fail((String)("serviceC should retry or throw a CircuitBreakerOpenException in testCircuitOpenWithMultiTimeouts on iteration " + invokeCounter + ", caught exception: " + ex));
        }
        invokeCounter = this.clientForCBWithRetryAsync.getCounterForInvokingServiceC();
        Assert.assertEquals((int)invokeCounter, (int)4, (String)"The number of executions should be 4");
    }

    @Test
    public void testRetriesSucceedWhenCircuitClosesAsync() {
        for (int i = 0; i < 4; ++i) {
            Future<String> result = this.clientForCBWithRetryAsync.serviceWithRetryOnCbOpen(true);
            Exceptions.expect(TestException.class, result);
        }
        long startTime = System.nanoTime();
        Future<String> result = this.clientForCBWithRetryAsync.serviceWithRetryOnCbOpen(false);
        try {
            result.get(TCKConfig.getConfig().getTimeoutInMillis(10000L), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"Call to serviceWithRetryOnCbOpen did not succeed within 10 seconds");
        }
        catch (ExecutionException e) {
            Assert.fail((String)"Call to serviceWithRetryOnCbOpen failed with exception", (Throwable)e);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Call to serviceWithRetryOnCbOpen was interrupted", (Throwable)e);
        }
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Call was successful but did not take the expected time", (Object)Duration.ofNanos(endTime - startTime), (Matcher)DurationMatcher.closeTo(TCKConfig.getConfig().getTimeoutInDuration(1000), TCKConfig.getConfig().getTimeoutInDuration(250)));
    }

    @Test
    public void testNoRetriesIfNotRetryOnAsync() {
        for (int i = 0; i < 4; ++i) {
            Future<String> result = this.clientForCBWithRetryAsync.serviceWithRetryOnTimeout(true);
            Exceptions.expect(TestException.class, result);
        }
        long startTime = System.nanoTime();
        Future<String> result = this.clientForCBWithRetryAsync.serviceWithRetryOnTimeout(false);
        Exceptions.expect(CircuitBreakerOpenException.class, result);
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Call was successful but did not take the expected time", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)TCKConfig.getConfig().getTimeoutInDuration(200)));
    }

    @Test
    public void testNoRetriesIfAbortOnAsync() {
        for (int i = 0; i < 4; ++i) {
            Future<String> result = this.clientForCBWithRetryAsync.serviceWithRetryFailOnCbOpen(true);
            Exceptions.expect(TestException.class, result);
        }
        long startTime = System.nanoTime();
        Future<String> result = this.clientForCBWithRetryAsync.serviceWithRetryFailOnCbOpen(false);
        Exceptions.expect(CircuitBreakerOpenException.class, result);
        long endTime = System.nanoTime();
        MatcherAssert.assertThat((String)"Call was successful but did not take the expected time", (Object)Duration.ofNanos(endTime - startTime), (Matcher)Matchers.lessThan((Comparable)TCKConfig.getConfig().getTimeoutInDuration(200)));
    }
}

