/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.context.tck.cdi;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.Transactional;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.tck.cdi.TransactionalBean;
import org.eclipse.microprofile.context.tck.cdi.TransactionalBeanImpl;
import org.eclipse.microprofile.context.tck.cdi.TransactionalService;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Ignore;
import org.testng.annotations.Test;

public class JTACDITest
extends Arquillian {
    public static final int UNSUPPORTED = -1000;
    @Inject
    private TransactionalService transactionalService;

    @AfterMethod
    public void afterMethod(Method m, ITestResult result) {
        System.out.printf("<<< END %s.%s%n", m.getName(), result.isSuccess() ? " SUCCESS" : " FAILED");
        Throwable failure = result.getThrowable();
        if (failure != null) {
            failure.printStackTrace(System.out);
        }
    }

    @BeforeMethod
    public void beforeMethod(Method m) {
        System.out.printf(">>> BEGIN %s.%s%n", m.getClass().getSimpleName(), m.getName());
    }

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(JTACDITest.class.getSimpleName() + ".war"))).addClasses(new Class[]{TransactionalBean.class, TransactionalBeanImpl.class, TransactionalService.class})).addClass(JTACDITest.class);
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testTransaction() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testAsyncTransaction() {
        ManagedExecutor executor = this.createExecutor("testAsyncTransaction");
        if (executor == null) {
            return;
        }
        try {
            int result = this.transactionalService.testAsync(executor);
            if (result != -1000) {
                Assert.assertEquals((int)1, (int)result, (String)"testAsyncTransaction failed%n");
            }
            this.verifyNoTransaction();
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionPropagation() throws Exception {
        ManagedExecutor executor = this.createExecutor("testTransactionPropagation");
        UserTransaction ut = this.getUserTransaction("testTransactionPropagation");
        if (executor == null || ut == null) {
            return;
        }
        try {
            try {
                CompletableFuture stage0;
                ut.begin();
                int currentValue = this.transactionalService.getValue();
                try {
                    stage0 = executor.runAsync(() -> {
                        this.transactionalService.required();
                        Assert.assertEquals((int)(currentValue + 1), (int)this.transactionalService.getValue());
                    });
                }
                catch (IllegalStateException x) {
                    System.out.println("Propagation of active transactions is not supported. Skipping test.");
                    ut.rollback();
                    executor.shutdownNow();
                    return;
                }
                CompletionStage stage1 = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)stage0.thenRunAsync(() -> {
                    this.transactionalService.requiresNew();
                    Assert.assertEquals((int)(currentValue + 1), (int)this.transactionalService.getValue());
                })).thenRunAsync(() -> {
                    this.transactionalService.supports();
                    Assert.assertEquals((int)(currentValue + 2), (int)this.transactionalService.getValue());
                })).thenRunAsync(() -> {
                    if (this.callServiceExpectFailure(Transactional.TxType.NEVER.name(), TransactionalService::never, this.transactionalService)) {
                        Assert.assertEquals((int)(currentValue + 2), (int)this.transactionalService.getValue());
                    }
                })).thenRunAsync(() -> {
                    if (this.callServiceExpectFailure(Transactional.TxType.NOT_SUPPORTED.name(), TransactionalService::notSupported, this.transactionalService)) {
                        Assert.assertEquals((int)(currentValue + 2), (int)this.transactionalService.getValue());
                    }
                })).thenRunAsync(() -> {
                    this.transactionalService.mandatory();
                    Assert.assertEquals((int)(currentValue + 3), (int)this.transactionalService.getValue());
                });
                try {
                    ((CompletableFuture)stage1).join();
                }
                catch (CompletionException x) {
                    if (x.getCause() instanceof IllegalStateException) {
                        System.out.println("Propagation of active transactions to multiple threads in parallel is not supported. Skipping test.");
                        ut.rollback();
                        executor.shutdownNow();
                        return;
                    }
                    throw x;
                }
                Assert.assertEquals((int)(currentValue + 3), (int)this.transactionalService.getValue());
            }
            finally {
                ut.rollback();
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testConcurrentTransactionPropagation() {
        ManagedExecutor executor = this.createExecutor("testConcurrentTransactionPropagation");
        UserTransaction ut = this.getUserTransaction("testConcurrentTransactionPropagation");
        if (executor == null || ut == null) {
            return;
        }
        try {
            int result = this.transactionalService.testConcurrentTransactionPropagation(executor);
            if (result != -1000) {
                Assert.assertEquals((int)2, (int)result, (String)"testTransactionPropagation failed%n");
            }
            this.verifyNoTransaction();
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRunWithTxnOfExecutingThread() throws SystemException, NotSupportedException {
        ThreadContext threadContext = ThreadContext.builder().propagated(new String[0]).unchanged(new String[]{"Transaction"}).cleared(new String[]{"Remaining"}).build();
        UserTransaction ut = this.getUserTransaction("testRunWithTxnOfExecutingThread");
        if (threadContext == null || ut == null) {
            return;
        }
        Callable isInTransaction = threadContext.contextualCallable(() -> ut.getStatus() == 0);
        ut.begin();
        try {
            Assert.assertTrue((boolean)((Boolean)isInTransaction.call()));
        }
        catch (Exception e) {
            Assert.fail((String)"testRunWithTxnOfExecutingThread: a transaction should have been active");
        }
        finally {
            ut.rollback();
        }
    }

    @Test
    public void testTransactionWithUT() throws Exception {
        CompletableFuture stage;
        ManagedExecutor executor = this.createExecutor("testTransactionWithUT");
        UserTransaction ut = this.getUserTransaction("testConcurrentTransactionPropagation");
        if (executor == null || ut == null) {
            return;
        }
        TransactionalService service = (TransactionalService)CDI.current().select(TransactionalService.class, new Annotation[0]).get();
        ut.begin();
        Assert.assertEquals((int)0, (int)service.getValue());
        try {
            stage = executor.runAsync(service::mandatory);
        }
        catch (IllegalStateException x) {
            System.out.println("Propagation of active transactions is not supported. Skipping test.");
            return;
        }
        try {
            stage.join();
        }
        catch (CompletionException x) {
            if (x.getCause() instanceof IllegalStateException) {
                System.out.println("Propagation of active transactions to multiple threads in parallel is not supported. Skipping test.");
                return;
            }
            throw x;
        }
        try {
            ut.rollback();
            Assert.assertEquals((int)ut.getStatus(), (int)6, (String)"transaction still active");
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
    }

    private boolean callServiceExpectFailure(String txType, TransactionalServiceCall<TransactionalService> op, TransactionalService ts) {
        try {
            ThreadContext.builder().propagated(new String[0]).cleared(new String[]{"Transaction"}).unchanged(new String[]{"Remaining"}).build().contextualRunnable(() -> this.callServiceWithoutContextExpectFailure(op, ts)).run();
            return true;
        }
        catch (IllegalStateException e) {
            System.out.printf("Skipping testTransactionPropagation for %s. Transaction context propagation is not supported.%n", txType);
            return false;
        }
    }

    private void callServiceWithoutContextExpectFailure(TransactionalServiceCall<TransactionalService> op, TransactionalService ts) {
        try {
            op.apply(ts);
            Assert.fail((String)"TransactionScoped bean should only be available from transaction scope");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void verifyNoTransaction() {
        try {
            TransactionManager transactionManager = (TransactionManager)CDI.current().select(TransactionManager.class, new Annotation[0]).get();
            try {
                if (transactionManager.getTransaction() != null) {
                    Assert.fail((String)"transaction still active");
                }
            }
            catch (SystemException e) {
                Assert.fail((String)"Could verify that no transaction is associated", (Throwable)e);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private UserTransaction getUserTransaction(String testName) {
        try {
            return (UserTransaction)CDI.current().select(UserTransaction.class, new Annotation[0]).get();
        }
        catch (IllegalStateException x) {
            System.out.printf("Skipping test %s. UserTransaction is not available.%n", testName);
            return null;
        }
    }

    private ManagedExecutor createExecutor(String testName) {
        try {
            return ManagedExecutor.builder().maxAsync(2).propagated(new String[]{"Transaction"}).cleared(new String[]{"Remaining"}).build();
        }
        catch (IllegalStateException x) {
            System.out.printf("Skipping test %s. Transaction context propagation is not supported.%n", testName);
            return null;
        }
    }

    private /* synthetic */ void lambda$testTransaction$0() {
        this.transactionalService.mandatory();
    }

    @FunctionalInterface
    static interface TransactionalServiceCall<TransactionalService> {
        public void apply(TransactionalService var1);
    }
}

