/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.provider;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.mdht.uml.validation.internal.ValidationPlugin;
import org.eclipse.uml2.common.util.UML2Util;

public abstract class AbstractMultiConstraint
extends AbstractModelConstraint {
    private final String validationMethodPrefix;
    private final Map<String, Method> validationMethods = new HashMap<String, Method>();

    public AbstractMultiConstraint() {
        this("validate");
    }

    public AbstractMultiConstraint(String validationMethodPrefix) {
        this.validationMethodPrefix = validationMethodPrefix;
    }

    public IStatus validate(IValidationContext ctx) {
        IStatus result;
        try {
            result = (IStatus)this.getValidationMethod(ctx).invoke((Object)this, ctx);
        }
        catch (Exception e) {
            String id = ctx.getCurrentConstraintId();
            ValidationPlugin.INSTANCE.log(new Status(4, ValidationPlugin.INSTANCE.getSymbolicName(), "Invocation of validation method failed for constraint: " + id, (Throwable)e));
            this.validationMethods.put(id, this.getFailOnMissingValidationMethod());
            result = this.failOnMissingValidationMethod(ctx);
        }
        return result;
    }

    private Method getValidationMethod(IValidationContext ctx) {
        String id = ctx.getCurrentConstraintId();
        Method result = this.validationMethods.get(id);
        if (result == null) {
            try {
                result = ((Object)((Object)this)).getClass().getMethod(this.getValidationMethodName(ctx), IValidationContext.class);
            }
            catch (Exception e) {
                ValidationPlugin.INSTANCE.log(new Status(4, ValidationPlugin.INSTANCE.getSymbolicName(), "Failed to look up validation method for constraint: " + id, (Throwable)e));
                result = this.getFailOnMissingValidationMethod();
            }
            this.validationMethods.put(id, result);
        }
        return result;
    }

    private String getValidationMethodName(IValidationContext ctx) {
        String constraintName = ctx.getCurrentConstraintId();
        int dot = constraintName.lastIndexOf(46);
        if (dot >= 0) {
            constraintName = constraintName.substring(dot + 1);
        }
        constraintName = UML2Util.getValidJavaIdentifier((String)constraintName);
        StringBuilder result = new StringBuilder();
        result.append(this.validationMethodPrefix);
        result.append(Character.toUpperCase(constraintName.charAt(0)));
        result.append(constraintName.substring(1));
        return result.toString();
    }

    private Method getFailOnMissingValidationMethod() {
        Method result;
        try {
            result = AbstractMultiConstraint.class.getDeclaredMethod("failOnMissingValidationMethod", IValidationContext.class);
        }
        catch (Exception e) {
            throw new Error("Error accessing known method.", e);
        }
        return result;
    }

    public IStatus failOnMissingValidationMethod(IValidationContext ctx) {
        return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)ctx.getTarget(), Collections.emptySet(), (int)4, (int)-1, (String)"Validation method not found or invalid in {0}: {1}", (Object[])new Object[]{((Object)((Object)this)).getClass().getName(), this.getValidationMethodName(ctx)});
    }
}

